/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import javafx.scene.Node;

public class JarReportEntry {
    private final String name;
    private final Status status;
    private final Class<?> klass;
    private final Throwable exception;

    public JarReportEntry(String name, Status status, Throwable exception, Class<?> klass) {
        assert (name != null);
        assert (klass != null || status != Status.OK);
        assert (exception == null || status != Status.OK);
        this.name = name;
        this.status = status;
        this.klass = klass;
        this.exception = exception;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isNode() {
        return this.klass == null ? false : Node.class.isAssignableFrom(this.klass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.status) {
            case OK: {
                assert (this.klass != null);
                sb.append(this.klass.getCanonicalName());
                sb.append(" - OK");
                break;
            }
            case CANNOT_LOAD: {
                assert (this.klass == null);
                assert (this.exception != null);
                sb.append(this.name);
                sb.append(" - CANNOT_LOAD - ");
                sb.append(this.exception.getMessage());
                break;
            }
            case CANNOT_INSTANTIATE: {
                assert (this.klass != null);
                sb.append(this.klass.getCanonicalName());
                sb.append(" - CANNOT_INSTANTIATE - ");
                sb.append(this.exception.getMessage());
                break;
            }
            case IGNORED: {
                assert (this.klass == null);
                sb.append(this.name);
                sb.append(" - IGNORED");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected status " + (Object)((Object)this.status));
            }
        }
        return sb.toString();
    }

    public static enum Status {
        IGNORED,
        CANNOT_LOAD,
        CANNOT_INSTANTIATE,
        OK;

    }
}

