/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;

public class ModelFactory {
    public static ExternalDependency createCopy(ExternalDependency dependency) {
        AbstractExternalDependency newDep;
        if (dependency instanceof ExternalProjectDependency) {
            newDep = new DefaultExternalProjectDependency((ExternalProjectDependency)dependency);
        } else if (dependency instanceof ExternalLibraryDependency) {
            newDep = new DefaultExternalLibraryDependency((ExternalLibraryDependency)dependency);
        } else if (dependency instanceof FileCollectionDependency) {
            newDep = new DefaultFileCollectionDependency((FileCollectionDependency)dependency);
        } else if (dependency instanceof UnresolvedExternalDependency) {
            newDep = new DefaultUnresolvedExternalDependency((UnresolvedExternalDependency)dependency);
        } else {
            throw new AssertionError((Object)("unknown dependency object which implements: " + Arrays.toString(dependency.getClass().getInterfaces())));
        }
        return newDep;
    }

    @Contract(value="null -> null")
    public static Collection<ExternalDependency> createCopy(@Nullable Collection<ExternalDependency> dependencies) {
        if (dependencies == null) {
            return null;
        }
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>(dependencies.size());
        for (ExternalDependency dependency : dependencies) {
            result.add(ModelFactory.createCopy(dependency));
        }
        return result;
    }
}

