/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class ByteBufferOutput
extends Output {
    protected ByteBuffer niobuffer;
    protected boolean varIntsEnabled = true;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    public ByteBufferOutput() {
    }

    public ByteBufferOutput(int n) {
        this(n, n);
    }

    public ByteBufferOutput(int n, int n2) {
        if (n2 < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + n2);
        }
        this.capacity = n;
        this.maxCapacity = n2 == -1 ? Integer.MAX_VALUE : n2;
        this.niobuffer = ByteBuffer.allocateDirect(n);
        this.niobuffer.order(this.byteOrder);
    }

    public ByteBufferOutput(OutputStream outputStream) {
        this(4096, 4096);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public ByteBufferOutput(OutputStream outputStream, int n) {
        this(n, n);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public ByteBufferOutput(ByteBuffer byteBuffer) {
        this(byteBuffer, 0, byteBuffer.position());
    }

    public ByteBufferOutput(ByteBuffer byteBuffer, int n, int n2) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.limit(n2);
        byteBuffer2.rewind();
        this.setBuffer(byteBuffer2, n2);
        byteBuffer.order(this.byteOrder);
    }

    public ByteOrder order() {
        return this.byteOrder;
    }

    public void order(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void release() {
        this.clear();
        UnsafeUtil.releaseBuffer(this.niobuffer);
        this.niobuffer = null;
    }

    public ByteBufferOutput(long l, int n) {
        this.niobuffer = UnsafeUtil.getDirectBufferAt(l, n);
        this.setBuffer(this.niobuffer, n);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.position = 0;
        this.total = 0;
    }

    public void setBuffer(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (n < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + n);
        }
        this.niobuffer = byteBuffer;
        this.maxCapacity = n == -1 ? Integer.MAX_VALUE : n;
        this.capacity = byteBuffer.capacity();
        this.position = 0;
        this.total = 0;
        this.outputStream = null;
    }

    public ByteBuffer getByteBuffer() {
        this.niobuffer.position(this.position);
        return this.niobuffer;
    }

    @Override
    public byte[] toBytes() {
        byte[] byArray = new byte[this.position];
        this.niobuffer.position(this.position);
        this.niobuffer.position(0);
        this.niobuffer.get(byArray, 0, this.position);
        return byArray;
    }

    @Override
    public void setPosition(int n) {
        this.position = n;
    }

    @Override
    public void clear() {
        this.niobuffer.clear();
        this.position = 0;
        this.total = 0;
    }

    @Override
    protected boolean require(int n) throws KryoException {
        if (this.capacity - this.position >= n) {
            return false;
        }
        if (n > this.maxCapacity) {
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + n);
        }
        this.flush();
        while (this.capacity - this.position < n) {
            if (this.capacity == this.maxCapacity) {
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + n);
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.capacity);
            this.niobuffer.position(0);
            byteBuffer.put(this.niobuffer);
            byteBuffer.order(this.byteOrder);
            this.niobuffer = byteBuffer;
        }
        return true;
    }

    @Override
    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            byte[] byArray = new byte[this.position];
            this.niobuffer.position(0);
            this.niobuffer.get(byArray);
            this.niobuffer.position(0);
            this.outputStream.write(byArray, 0, this.position);
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
        this.total += this.position;
        this.position = 0;
    }

    @Override
    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int n) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put((byte)n);
        ++this.position;
    }

    @Override
    public void write(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws KryoException {
        this.writeBytes(byArray, n, n2);
    }

    @Override
    public void writeByte(byte by) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put(by);
        ++this.position;
    }

    @Override
    public void writeByte(int n) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put((byte)n);
        ++this.position;
    }

    @Override
    public void writeBytes(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n3 = Math.min(this.capacity - this.position, n2);
        while (true) {
            this.niobuffer.put(byArray, n, n3);
            this.position += n3;
            if ((n2 -= n3) == 0) {
                return;
            }
            n += n3;
            n3 = Math.min(this.capacity, n2);
            this.require(n3);
        }
    }

    @Override
    public void writeInt(int n) throws KryoException {
        this.require(4);
        this.niobuffer.putInt(n);
        this.position += 4;
    }

    @Override
    public int writeInt(int n, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeInt(n);
            return 4;
        }
        return this.writeVarInt(n, bl);
    }

    @Override
    public int writeVarInt(int n, boolean bl) throws KryoException {
        this.niobuffer.position(this.position);
        int n2 = n;
        if (!bl) {
            n2 = n2 << 1 ^ n2 >> 31;
        }
        int n3 = 0;
        n3 = n2 & 0x7F;
        if ((n2 >>>= 7) == 0) {
            this.writeByte(n3);
            return 1;
        }
        n3 |= 0x80;
        n3 |= (n2 & 0x7F) << 8;
        if ((n2 >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n3);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 2;
        }
        n3 |= 0x8000;
        n3 |= (n2 & 0x7F) << 16;
        if ((n2 >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n3);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 3;
        }
        n3 |= 0x800000;
        n3 |= (n2 & 0x7F) << 24;
        if ((n2 >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n3);
            this.niobuffer.order(this.byteOrder);
            this.position -= 0;
            return 4;
        }
        long l = (long)(n3 |= Integer.MIN_VALUE) & 0xFFFFFFFFL | (long)n2 << 32;
        this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.writeLong(l);
        this.niobuffer.order(this.byteOrder);
        this.position -= 3;
        this.niobuffer.position(this.position);
        return 5;
    }

    @Override
    public void writeString(String string) throws KryoException {
        int n;
        int n2;
        this.niobuffer.position(this.position);
        if (string == null) {
            this.writeByte(128);
            return;
        }
        int n3 = string.length();
        if (n3 == 0) {
            this.writeByte(129);
            return;
        }
        boolean bl = false;
        if (n3 > 1 && n3 < 64) {
            bl = true;
            for (n2 = 0; n2 < n3; ++n2) {
                n = string.charAt(n2);
                if (n <= 127) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            if (this.capacity - this.position < n3) {
                this.writeAscii_slow(string, n3);
            } else {
                byte[] byArray = string.getBytes();
                this.niobuffer.put(byArray, 0, byArray.length);
                this.position += n3;
            }
            this.niobuffer.put(this.position - 1, (byte)(this.niobuffer.get(this.position - 1) | 0x80));
        } else {
            this.writeUtf8Length(n3 + 1);
            if (this.capacity - this.position >= n3) {
                char c;
                n = this.position;
                for (n2 = 0; n2 < n3 && (c = string.charAt(n2)) <= '\u007f'; ++n2) {
                    this.niobuffer.put(n++, (byte)c);
                }
                this.position = n;
                this.niobuffer.position(n);
            }
            if (n2 < n3) {
                this.writeString_slow(string, n3, n2);
            }
            this.niobuffer.position(this.position);
        }
    }

    @Override
    public void writeString(CharSequence charSequence) throws KryoException {
        int n;
        if (charSequence == null) {
            this.writeByte(128);
            return;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(n2 + 1);
        if (this.capacity - this.position >= n2) {
            char c;
            int n3 = this.position;
            for (n = 0; n < n2 && (c = charSequence.charAt(n)) <= '\u007f'; ++n) {
                this.niobuffer.put(n3++, (byte)c);
            }
            this.position = n3;
            this.niobuffer.position(n3);
        }
        if (n < n2) {
            this.writeString_slow(charSequence, n2, n);
        }
        this.niobuffer.position(this.position);
    }

    @Override
    public void writeAscii(String string) throws KryoException {
        if (string == null) {
            this.writeByte(128);
            return;
        }
        int n = string.length();
        if (n == 0) {
            this.writeByte(129);
            return;
        }
        if (this.capacity - this.position < n) {
            this.writeAscii_slow(string, n);
        } else {
            byte[] byArray = string.getBytes();
            this.niobuffer.put(byArray, 0, byArray.length);
            this.position += n;
        }
        this.niobuffer.put(this.position - 1, (byte)(this.niobuffer.get(this.position - 1) | 0x80));
    }

    private void writeUtf8Length(int n) {
        if (n >>> 6 == 0) {
            this.require(1);
            this.niobuffer.put((byte)(n | 0x80));
            ++this.position;
        } else if (n >>> 13 == 0) {
            this.require(2);
            this.niobuffer.put((byte)(n | 0x40 | 0x80));
            this.niobuffer.put((byte)(n >>> 6));
            this.position += 2;
        } else if (n >>> 20 == 0) {
            this.require(3);
            this.niobuffer.put((byte)(n | 0x40 | 0x80));
            this.niobuffer.put((byte)(n >>> 6 | 0x80));
            this.niobuffer.put((byte)(n >>> 13));
            this.position += 3;
        } else if (n >>> 27 == 0) {
            this.require(4);
            this.niobuffer.put((byte)(n | 0x40 | 0x80));
            this.niobuffer.put((byte)(n >>> 6 | 0x80));
            this.niobuffer.put((byte)(n >>> 13 | 0x80));
            this.niobuffer.put((byte)(n >>> 20));
            this.position += 4;
        } else {
            this.require(5);
            this.niobuffer.put((byte)(n | 0x40 | 0x80));
            this.niobuffer.put((byte)(n >>> 6 | 0x80));
            this.niobuffer.put((byte)(n >>> 13 | 0x80));
            this.niobuffer.put((byte)(n >>> 20 | 0x80));
            this.niobuffer.put((byte)(n >>> 27));
            this.position += 5;
        }
    }

    private void writeString_slow(CharSequence charSequence, int n, int n2) {
        while (n2 < n) {
            char c;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, n - n2));
            }
            if ((c = charSequence.charAt(n2)) <= '\u007f') {
                this.niobuffer.put(this.position++, (byte)c);
            } else if (c > '\u07ff') {
                this.niobuffer.put(this.position++, (byte)(0xE0 | c >> 12 & 0xF));
                this.require(2);
                this.niobuffer.put(this.position++, (byte)(0x80 | c >> 6 & 0x3F));
                this.niobuffer.put(this.position++, (byte)(0x80 | c & 0x3F));
            } else {
                this.niobuffer.put(this.position++, (byte)(0xC0 | c >> 6 & 0x1F));
                this.require(1);
                this.niobuffer.put(this.position++, (byte)(0x80 | c & 0x3F));
            }
            ++n2;
        }
    }

    private void writeAscii_slow(String string, int n) throws KryoException {
        ByteBuffer byteBuffer = this.niobuffer;
        int n2 = 0;
        int n3 = Math.min(n, this.capacity - this.position);
        while (n2 < n) {
            byte[] byArray = new byte[n];
            string.getBytes(n2, n2 + n3, byArray, 0);
            byteBuffer.put(byArray, 0, n3);
            this.position += n3;
            if (!this.require(n3 = Math.min(n - (n2 += n3), this.capacity))) continue;
            byteBuffer = this.niobuffer;
        }
    }

    @Override
    public void writeFloat(float f) throws KryoException {
        this.require(4);
        this.niobuffer.putFloat(f);
        this.position += 4;
    }

    @Override
    public int writeFloat(float f, float f2, boolean bl) throws KryoException {
        return this.writeInt((int)(f * f2), bl);
    }

    @Override
    public void writeShort(int n) throws KryoException {
        this.require(2);
        this.niobuffer.putShort((short)n);
        this.position += 2;
    }

    @Override
    public void writeLong(long l) throws KryoException {
        this.require(8);
        this.niobuffer.putLong(l);
        this.position += 8;
    }

    @Override
    public int writeLong(long l, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeLong(l);
            return 8;
        }
        return this.writeVarLong(l, bl);
    }

    @Override
    public int writeVarLong(long l, boolean bl) throws KryoException {
        if (!bl) {
            l = l << 1 ^ l >> 63;
        }
        int n = 0;
        n = (int)(l & 0x7FL);
        if ((l >>>= 7) == 0L) {
            this.writeByte(n);
            return 1;
        }
        n |= 0x80;
        n = (int)((long)n | (l & 0x7FL) << 8);
        if ((l >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 2;
        }
        n |= 0x8000;
        n = (int)((long)n | (l & 0x7FL) << 16);
        if ((l >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 3;
        }
        n |= 0x800000;
        n = (int)((long)n | (l & 0x7FL) << 24);
        if ((l >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(n);
            this.niobuffer.order(this.byteOrder);
            this.position -= 0;
            return 4;
        }
        long l2 = (long)(n |= Integer.MIN_VALUE) & 0xFFFFFFFFL;
        l2 |= (l & 0x7FL) << 32;
        if ((l >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l2);
            this.niobuffer.order(this.byteOrder);
            this.position -= 3;
            this.niobuffer.position(this.position);
            return 5;
        }
        l2 |= 0x8000000000L;
        l2 |= (l & 0x7FL) << 40;
        if ((l >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l2);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 6;
        }
        l2 |= 0x800000000000L;
        l2 |= (l & 0x7FL) << 48;
        if ((l >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l2);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 7;
        }
        l2 |= 0x80000000000000L;
        l2 |= (l & 0x7FL) << 56;
        if ((l >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(l2);
            this.niobuffer.order(this.byteOrder);
            return 8;
        }
        this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.writeLong(l2 |= Long.MIN_VALUE);
        this.niobuffer.order(this.byteOrder);
        this.write((byte)l);
        return 9;
    }

    public int writeLongS(long l, boolean bl) throws KryoException {
        if (!bl) {
            l = l << 1 ^ l >> 63;
        }
        if (l >>> 7 == 0L) {
            this.require(1);
            this.niobuffer.put((byte)l);
            ++this.position;
            return 1;
        }
        if (l >>> 14 == 0L) {
            this.require(2);
            this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
            this.niobuffer.put((byte)(l >>> 7));
            this.position += 2;
            return 2;
        }
        if (l >>> 21 == 0L) {
            this.require(3);
            this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
            this.niobuffer.put((byte)(l >>> 7 | 0x80L));
            this.niobuffer.put((byte)(l >>> 14));
            this.position += 3;
            return 3;
        }
        if (l >>> 28 == 0L) {
            this.require(4);
            this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
            this.niobuffer.put((byte)(l >>> 7 | 0x80L));
            this.niobuffer.put((byte)(l >>> 14 | 0x80L));
            this.niobuffer.put((byte)(l >>> 21));
            this.position += 4;
            return 4;
        }
        if (l >>> 35 == 0L) {
            this.require(5);
            this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
            this.niobuffer.put((byte)(l >>> 7 | 0x80L));
            this.niobuffer.put((byte)(l >>> 14 | 0x80L));
            this.niobuffer.put((byte)(l >>> 21 | 0x80L));
            this.niobuffer.put((byte)(l >>> 28));
            this.position += 5;
            return 5;
        }
        if (l >>> 42 == 0L) {
            this.require(6);
            this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
            this.niobuffer.put((byte)(l >>> 7 | 0x80L));
            this.niobuffer.put((byte)(l >>> 14 | 0x80L));
            this.niobuffer.put((byte)(l >>> 21 | 0x80L));
            this.niobuffer.put((byte)(l >>> 28 | 0x80L));
            this.niobuffer.put((byte)(l >>> 35));
            this.position += 6;
            return 6;
        }
        if (l >>> 49 == 0L) {
            this.require(7);
            this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
            this.niobuffer.put((byte)(l >>> 7 | 0x80L));
            this.niobuffer.put((byte)(l >>> 14 | 0x80L));
            this.niobuffer.put((byte)(l >>> 21 | 0x80L));
            this.niobuffer.put((byte)(l >>> 28 | 0x80L));
            this.niobuffer.put((byte)(l >>> 35 | 0x80L));
            this.niobuffer.put((byte)(l >>> 42));
            this.position += 7;
            return 7;
        }
        if (l >>> 56 == 0L) {
            this.require(8);
            this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
            this.niobuffer.put((byte)(l >>> 7 | 0x80L));
            this.niobuffer.put((byte)(l >>> 14 | 0x80L));
            this.niobuffer.put((byte)(l >>> 21 | 0x80L));
            this.niobuffer.put((byte)(l >>> 28 | 0x80L));
            this.niobuffer.put((byte)(l >>> 35 | 0x80L));
            this.niobuffer.put((byte)(l >>> 42 | 0x80L));
            this.niobuffer.put((byte)(l >>> 49));
            this.position += 8;
            return 8;
        }
        this.require(9);
        this.niobuffer.put((byte)(l & 0x7FL | 0x80L));
        this.niobuffer.put((byte)(l >>> 7 | 0x80L));
        this.niobuffer.put((byte)(l >>> 14 | 0x80L));
        this.niobuffer.put((byte)(l >>> 21 | 0x80L));
        this.niobuffer.put((byte)(l >>> 28 | 0x80L));
        this.niobuffer.put((byte)(l >>> 35 | 0x80L));
        this.niobuffer.put((byte)(l >>> 42 | 0x80L));
        this.niobuffer.put((byte)(l >>> 49 | 0x80L));
        this.niobuffer.put((byte)(l >>> 56));
        this.position += 9;
        return 9;
    }

    @Override
    public void writeBoolean(boolean bl) throws KryoException {
        this.require(1);
        this.niobuffer.put((byte)(bl ? 1 : 0));
        ++this.position;
    }

    @Override
    public void writeChar(char c) throws KryoException {
        this.require(2);
        this.niobuffer.putChar(c);
        this.position += 2;
    }

    @Override
    public void writeDouble(double d) throws KryoException {
        this.require(8);
        this.niobuffer.putDouble(d);
        this.position += 8;
    }

    @Override
    public int writeDouble(double d, double d2, boolean bl) throws KryoException {
        return this.writeLong((long)(d * d2), bl);
    }

    @Override
    public void writeInts(int[] nArray) throws KryoException {
        if (this.capacity - this.position >= nArray.length * 4 && this.isNativeOrder()) {
            IntBuffer intBuffer = this.niobuffer.asIntBuffer();
            intBuffer.put(nArray);
            this.position += nArray.length * 4;
        } else {
            super.writeInts(nArray);
        }
    }

    @Override
    public void writeLongs(long[] lArray) throws KryoException {
        if (this.capacity - this.position >= lArray.length * 8 && this.isNativeOrder()) {
            LongBuffer longBuffer = this.niobuffer.asLongBuffer();
            longBuffer.put(lArray);
            this.position += lArray.length * 8;
        } else {
            super.writeLongs(lArray);
        }
    }

    @Override
    public void writeFloats(float[] fArray) throws KryoException {
        if (this.capacity - this.position >= fArray.length * 4 && this.isNativeOrder()) {
            FloatBuffer floatBuffer = this.niobuffer.asFloatBuffer();
            floatBuffer.put(fArray);
            this.position += fArray.length * 4;
        } else {
            super.writeFloats(fArray);
        }
    }

    @Override
    public void writeShorts(short[] sArray) throws KryoException {
        if (this.capacity - this.position >= sArray.length * 2 && this.isNativeOrder()) {
            ShortBuffer shortBuffer = this.niobuffer.asShortBuffer();
            shortBuffer.put(sArray);
            this.position += sArray.length * 2;
        } else {
            super.writeShorts(sArray);
        }
    }

    @Override
    public void writeChars(char[] cArray) throws KryoException {
        if (this.capacity - this.position >= cArray.length * 2 && this.isNativeOrder()) {
            CharBuffer charBuffer = this.niobuffer.asCharBuffer();
            charBuffer.put(cArray);
            this.position += cArray.length * 2;
        } else {
            super.writeChars(cArray);
        }
    }

    @Override
    public void writeDoubles(double[] dArray) throws KryoException {
        if (this.capacity - this.position >= dArray.length * 8 && this.isNativeOrder()) {
            DoubleBuffer doubleBuffer = this.niobuffer.asDoubleBuffer();
            doubleBuffer.put(dArray);
            this.position += dArray.length * 8;
        } else {
            super.writeDoubles(dArray);
        }
    }

    private boolean isNativeOrder() {
        return this.byteOrder == nativeOrder;
    }

    public boolean getVarIntsEnabled() {
        return this.varIntsEnabled;
    }

    public void setVarIntsEnabled(boolean bl) {
        this.varIntsEnabled = bl;
    }
}

