/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFileImpl;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlProperty
implements IProperty,
PomRenameableTarget,
PsiTarget {
    @NotNull
    private final XmlTag myTag;
    private final XmlPropertiesFileImpl myPropertiesFile;

    public XmlProperty(@NotNull XmlTag tag, XmlPropertiesFileImpl xmlPropertiesFile) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/properties/xml/XmlProperty", "<init>"));
        }
        this.myTag = tag;
        this.myPropertiesFile = xmlPropertiesFile;
    }

    @Override
    public String getName() {
        return this.myTag.getAttributeValue("key");
    }

    public boolean isWritable() {
        return this.myTag.isWritable();
    }

    @Override
    public PsiElement setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/properties/xml/XmlProperty", "setName"));
        }
        return this.myTag.setAttribute("key", name);
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public String getValue() {
        return this.myTag.getValue().getText();
    }

    @Override
    public String getUnescapedValue() {
        return this.getValue();
    }

    @Override
    public String getUnescapedKey() {
        return this.getKey();
    }

    @Override
    public void setValue(@NonNls @NotNull String value) throws IncorrectOperationException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/properties/xml/XmlProperty", "setValue"));
        }
        this.myTag.getValue().setText(value);
    }

    @Override
    public PropertiesFile getPropertiesFile() throws PsiInvalidElementAccessException {
        return this.myPropertiesFile;
    }

    @Override
    public String getDocCommentText() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement getPsiElement() {
        PsiElement psiElement = PomService.convertToPsi((PsiTarget)this);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlProperty", "getPsiElement"));
        }
        return psiElement;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.PROPERTY_ICON;
    }

    public boolean isValid() {
        return this.myTag.isValid();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlProperty", "getNavigationElement"));
        }
        return xmlTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlProperty property = (XmlProperty)o;
        return this.myTag.equals(property.myTag);
    }

    public int hashCode() {
        return this.myTag.hashCode();
    }

    public String toString() {
        return "XmlProperty: key = '" + this.getKey() + "', value = '" + this.getValue() + "'";
    }
}

