/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.tasks.jira.jql.JqlTokenTypes;
import com.intellij.tasks.jira.jql.psi.JqlElementVisitor;
import com.intellij.tasks.jira.jql.psi.JqlSortKey;
import com.intellij.tasks.jira.jql.psi.impl.JqlElementImpl;
import org.jetbrains.annotations.NotNull;

public class JqlSortKeyImpl
extends JqlElementImpl
implements JqlSortKey {
    public JqlSortKeyImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/tasks/jira/jql/psi/impl/JqlSortKeyImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(JqlElementVisitor visitor) {
        visitor.visitJqlSortKey(this);
    }

    @Override
    @NotNull
    public String getFieldName() {
        PsiElement fieldNode = this.getFirstChild();
        assert (fieldNode != null);
        String string = JqlSortKeyImpl.unescape(fieldNode.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/psi/impl/JqlSortKeyImpl", "getFieldName"));
        }
        return string;
    }

    @Override
    public boolean isAscending() {
        PsiElement order = this.findChildByType(JqlTokenTypes.SORT_ORDERS);
        return order == null || order.getNode().getElementType() == JqlTokenTypes.ASC_KEYWORD;
    }
}

