/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.IdeaClassFinder;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.impl.source.tree.java.PsiSwitchStatementImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageData;
import jetbrains.coverage.report.ReportBuilderFactory;
import jetbrains.coverage.report.ReportGenerationFailedException;
import jetbrains.coverage.report.SourceCodeProvider;
import jetbrains.coverage.report.html.HTMLReportBuilder;
import jetbrains.coverage.report.idea.IDEACoverageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance((String)JavaCoverageEngine.class.getName());

    public static JavaCoverageEngine getInstance() {
        return (JavaCoverageEngine)Extensions.findExtension((ExtensionPointName)EP_NAME, JavaCoverageEngine.class);
    }

    @Override
    public boolean isApplicableTo(@Nullable RunConfigurationBase conf) {
        if (conf instanceof CommonJavaRunConfigurationParameters) {
            return true;
        }
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!extension.isApplicableTo(conf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHavePerTestCoverage(@Nullable RunConfigurationBase conf) {
        return !(conf instanceof ApplicationConfiguration) && conf instanceof CommonJavaRunConfigurationParameters;
    }

    @Override
    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@Nullable RunConfigurationBase conf) {
        JavaCoverageEnabledConfiguration javaCoverageEnabledConfiguration = new JavaCoverageEnabledConfiguration(conf, this);
        if (javaCoverageEnabledConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "createCoverageEnabledConfiguration"));
        }
        return javaCoverageEnabledConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "covRunner", "com/intellij/coverage/JavaCoverageEngine", "createCoverageSuite"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/coverage/JavaCoverageEngine", "createCoverageSuite"));
        }
        if (coverageDataFileProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataFileProvider", "com/intellij/coverage/JavaCoverageEngine", "createCoverageSuite"));
        }
        return this.createSuite(covRunner, name, coverageDataFileProvider, filters, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, (Project)project2);
    }

    @Override
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "covRunner", "com/intellij/coverage/JavaCoverageEngine", "createCoverageSuite"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/coverage/JavaCoverageEngine", "createCoverageSuite"));
        }
        if (coverageDataFileProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataFileProvider", "com/intellij/coverage/JavaCoverageEngine", "createCoverageSuite"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/coverage/JavaCoverageEngine", "createCoverageSuite"));
        }
        if (config instanceof JavaCoverageEnabledConfiguration) {
            JavaCoverageEnabledConfiguration javaConfig = (JavaCoverageEnabledConfiguration)config;
            return this.createSuite(covRunner, name, coverageDataFileProvider, javaConfig.getPatterns(), new Date().getTime(), javaConfig.isTrackPerTestCoverage() && !javaConfig.isSampling(), !javaConfig.isSampling(), javaConfig.isTrackTestFolders(), config.getConfiguration().getProject());
        }
        return null;
    }

    @Override
    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageRunner", "com/intellij/coverage/JavaCoverageEngine", "createEmptyCoverageSuite"));
        }
        return new JavaCoverageSuite(this);
    }

    @Override
    @NotNull
    public CoverageAnnotator getCoverageAnnotator(Project project) {
        JavaCoverageAnnotator javaCoverageAnnotator = JavaCoverageAnnotator.getInstance(project);
        if (javaCoverageAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "getCoverageAnnotator"));
        }
        return javaCoverageAnnotator;
    }

    @Override
    public boolean coverageEditorHighlightingApplicableTo(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/coverage/JavaCoverageEngine", "coverageEditorHighlightingApplicableTo"));
        }
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        Module module = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            @Nullable
            public Module compute() {
                return ModuleUtil.findModuleForPsiElement((PsiElement)psiFile);
            }
        });
        return module != null;
    }

    @Override
    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/coverage/JavaCoverageEngine", "acceptedByFilters"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine", "acceptedByFilters"));
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Project project = psiFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (!suite.isTrackTestFolders() && fileIndex.isInTestSourceContent(virtualFile)) {
            return false;
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            List<PsiPackage> packages = javaSuite.getCurrentSuitePackages(project);
            if (JavaCoverageEngine.isUnderFilteredPackages((PsiClassOwner)psiFile, packages)) {
                return true;
            }
            List<PsiClass> classes = javaSuite.getCurrentSuiteClasses(project);
            for (PsiClass aClass : classes) {
                PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiClass)aClass).getContainingFile());
                if (!psiFile.equals(containingFile)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean recompileProjectAndRerunAction(@NotNull Module module, final @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/coverage/JavaCoverageEngine", "recompileProjectAndRerunAction"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine", "recompileProjectAndRerunAction"));
        }
        if (chooseSuiteAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooseSuiteAction", "com/intellij/coverage/JavaCoverageEngine", "recompileProjectAndRerunAction"));
        }
        VirtualFile outputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        VirtualFile testOutputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests();
        if (outputpath == null && JavaCoverageEngine.isModuleOutputNeeded(module, JavaSourceRootType.SOURCE) || suite.isTrackTestFolders() && testOutputpath == null && JavaCoverageEngine.isModuleOutputNeeded(module, JavaSourceRootType.TEST_SOURCE)) {
            final Project project = module.getProject();
            if (suite.isModuleChecked(module)) {
                return false;
            }
            suite.checkModule(module);
            Runnable runnable = () -> {
                if (suite == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine", "lambda$recompileProjectAndRerunAction$0"));
                }
                if (Messages.showOkCancelDialog((String)"Project class files are out of date. Would you like to recompile? The refusal to do it will result in incomplete coverage information", (String)"Project is out of date", (Icon)Messages.getWarningIcon()) == 0) {
                    CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
                    compilerManager.make(compilerManager.createProjectCompileScope(project), new CompileStatusNotification(){

                        public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                            if (aborted || errors != 0) {
                                return;
                            }
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (suite == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine$2", "lambda$finished$0"));
                                }
                                if (project.isDisposed()) {
                                    return;
                                }
                                CoverageDataManager.getInstance(project).chooseSuitesBundle(suite);
                            });
                        }
                    });
                } else if (!project.isDisposed()) {
                    CoverageDataManager.getInstance(project).chooseSuitesBundle(null);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable);
            return true;
        }
        return false;
    }

    private static boolean isModuleOutputNeeded(Module module, JavaSourceRootType rootType) {
        return !ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).isEmpty();
    }

    public static boolean isUnderFilteredPackages(final PsiClassOwner javaFile, List<PsiPackage> packages) {
        PsiPackage hisPackage = (PsiPackage)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiPackage>(){

            public PsiPackage compute() {
                return JavaPsiFacade.getInstance((Project)javaFile.getProject()).findPackage(javaFile.getPackageName());
            }
        });
        if (hisPackage == null) {
            return false;
        }
        for (PsiPackage aPackage : packages) {
            if (!PsiTreeUtil.isAncestor((PsiElement)aPackage, (PsiElement)hisPackage, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        byte[] content;
        if (classFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFile", "com/intellij/coverage/JavaCoverageEngine", "collectSrcLinesForUntouchedFile"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine", "collectSrcLinesForUntouchedFile"));
        }
        ArrayList<Integer> uncoveredLines = new ArrayList<Integer>();
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        try {
            SourceLineCounterUtil.collectSrcLinesForUntouchedFiles(uncoveredLines, content, suite.isTracingEnabled());
        }
        catch (Exception e) {
            LOG.error("Fail to process class from: " + classFile.getPath(), (Throwable)e);
        }
        return uncoveredLines;
    }

    @Override
    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/coverage/JavaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/coverage/JavaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/coverage/JavaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine", "includeUntouchedFileInCoverage"));
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (!javaSuite.isClassFiltered(qualifiedName) && !javaSuite.isPackageFiltered(JavaCoverageEngine.getPackageName(sourceFile))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/intellij/coverage/JavaCoverageEngine", "getQualifiedName"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/coverage/JavaCoverageEngine", "getQualifiedName"));
        }
        String packageFQName = JavaCoverageEngine.getPackageName(sourceFile);
        return StringUtil.getQualifiedName((String)packageFQName, (String)FileUtil.getNameWithoutExtension((File)outputFile));
    }

    @Override
    @NotNull
    public Set<String> getQualifiedNames(final @NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/coverage/JavaCoverageEngine", "getQualifiedNames"));
        }
        final PsiClass[] classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

            public PsiClass[] compute() {
                return ((PsiClassOwner)sourceFile).getClasses();
            }
        });
        HashSet qNames = new HashSet();
        for (final JavaCoverageEngineExtension javaCoverageEngineExtension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>((Set)qNames){
                final /* synthetic */ Set val$qNames;
                {
                    this.val$qNames = set;
                }

                public Boolean compute() {
                    return javaCoverageEngineExtension.suggestQualifiedName(sourceFile, classes, this.val$qNames);
                }
            })).booleanValue()) continue;
            HashSet hashSet = qNames;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "getQualifiedNames"));
            }
            return hashSet;
        }
        for (JavaCoverageEngineExtension javaCoverageEngineExtension : classes) {
            String qName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>((PsiClass)javaCoverageEngineExtension){
                final /* synthetic */ PsiClass val$aClass;
                {
                    this.val$aClass = psiClass;
                }

                @Nullable
                public String compute() {
                    return this.val$aClass.getQualifiedName();
                }
            });
            if (qName == null) continue;
            qNames.add(qName);
        }
        HashSet hashSet = qNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "getQualifiedNames"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<File> getCorrespondingOutputFiles(final @NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        PsiClass[] classes;
        File vDir;
        if (srcFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcFile", "com/intellij/coverage/JavaCoverageEngine", "getCorrespondingOutputFiles"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageEngine", "getCorrespondingOutputFiles"));
        }
        if (module == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "getCorrespondingOutputFiles"));
            }
            return set;
        }
        HashSet classFiles = new HashSet();
        VirtualFile outputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        VirtualFile testOutputpath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPathForTests();
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!extension.collectOutputFiles(srcFile, outputpath, testOutputpath, suite, (Set<File>)classFiles)) continue;
            HashSet hashSet = classFiles;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "getCorrespondingOutputFiles"));
            }
            return hashSet;
        }
        String packageFQName = JavaCoverageEngine.getPackageName(srcFile);
        String packageVmName = packageFQName.replace('.', '/');
        ArrayList children = new ArrayList();
        File file = outputpath == null ? null : (vDir = packageVmName.length() > 0 ? new File(outputpath.getPath() + File.separator + packageVmName) : VfsUtilCore.virtualToIoFile((VirtualFile)outputpath));
        if (vDir != null && vDir.exists()) {
            Collections.addAll(children, vDir.listFiles());
        }
        if (suite.isTrackTestFolders()) {
            File testDir;
            File file2 = testOutputpath == null ? null : (testDir = packageVmName.length() > 0 ? new File(testOutputpath.getPath() + File.separator + packageVmName) : VfsUtilCore.virtualToIoFile((VirtualFile)testOutputpath));
            if (testDir != null && testDir.exists()) {
                Collections.addAll(children, testDir.listFiles());
            }
        }
        for (final PsiClass psiClass : classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

            public PsiClass[] compute() {
                return ((PsiClassOwner)srcFile).getClasses();
            }
        })) {
            String className = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return psiClass.getName();
                }
            });
            for (File child : children) {
                String childName;
                if (!FileUtilRt.extensionEquals((String)child.getName(), (String)StdFileTypes.CLASS.getDefaultExtension()) || !(childName = FileUtil.getNameWithoutExtension((File)child)).equals(className) && (!childName.startsWith(className) || childName.charAt(className.length()) != '$')) continue;
                classFiles.add(child);
            }
        }
        HashSet hashSet = classFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "getCorrespondingOutputFiles"));
        }
        return hashSet;
    }

    @Override
    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/JavaCoverageEngine", "generateBriefReport"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/coverage/JavaCoverageEngine", "generateBriefReport"));
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Hits: ");
        if (lineData == null) {
            buf.append(0);
            return buf.toString();
        }
        buf.append(lineData.getHits()).append("\n");
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            String report = extension.generateBriefReport(editor, psiFile, lineNumber, startOffset, endOffset, lineData);
            if (report == null) continue;
            buf.append(report);
            return report;
        }
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        Project project = editor.getProject();
        for (int offset = startOffset; offset < endOffset; ++offset) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PsiStatement.class);
            PsiExpression condition = null;
            if (parent instanceof PsiIfStatement) {
                condition = ((PsiIfStatement)parent).getCondition();
            } else if (parent instanceof PsiSwitchStatement) {
                condition = ((PsiSwitchStatement)parent).getExpression();
            } else if (parent instanceof PsiDoWhileStatement) {
                condition = ((PsiDoWhileStatement)parent).getCondition();
            } else if (parent instanceof PsiForStatement) {
                condition = ((PsiForStatement)parent).getCondition();
            } else if (parent instanceof PsiWhileStatement) {
                condition = ((PsiWhileStatement)parent).getCondition();
            } else if (parent instanceof PsiForeachStatement) {
                condition = ((PsiForeachStatement)parent).getIteratedValue();
            } else if (parent instanceof PsiAssertStatement) {
                condition = ((PsiAssertStatement)parent).getAssertCondition();
            }
            if (condition == null || !PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)psiFile.findElementAt(offset), (boolean)false)) continue;
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance((Project)project).getControlFlow(parent, (ControlFlowPolicy)AllVariablesControlFlowPolicy.getInstance());
                for (Instruction instruction : controlFlow.getInstructions()) {
                    PsiExpression psiExpression;
                    if (!(instruction instanceof ConditionalBranchingInstruction) || expressions.contains(psiExpression = ((ConditionalBranchingInstruction)instruction).expression)) continue;
                    expressions.add(psiExpression);
                }
                continue;
            }
            catch (AnalysisCanceledException e) {
                return buf.toString();
            }
        }
        String indent = "    ";
        try {
            int idx = 0;
            int hits = 0;
            if (lineData.getJumps() != null) {
                for (JumpData jumpData : lineData.getJumps()) {
                    PsiExpression expression;
                    PsiElement parentExpression;
                    JumpData jumpData2 = jumpData;
                    if (jumpData2.getTrueHits() + jumpData2.getFalseHits() <= 0) continue;
                    boolean reverse = (parentExpression = (expression = (PsiExpression)expressions.get(idx++)).getParent()) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parentExpression).getOperationTokenType() == JavaTokenType.OROR || parentExpression instanceof PsiDoWhileStatement || parentExpression instanceof PsiAssertStatement;
                    buf.append("    ").append(expression.getText()).append("\n");
                    buf.append("    ").append("    ").append("true hits: ").append(reverse ? jumpData2.getFalseHits() : jumpData2.getTrueHits()).append("\n");
                    buf.append("    ").append("    ").append("false hits: ").append(reverse ? jumpData2.getTrueHits() : jumpData2.getFalseHits()).append("\n");
                    hits += jumpData2.getTrueHits() + jumpData2.getFalseHits();
                }
            }
            if (lineData.getSwitches() != null) {
                for (JumpData jumpData : lineData.getSwitches()) {
                    SwitchData switchData = (SwitchData)jumpData;
                    PsiExpression conditionExpression = (PsiExpression)expressions.get(idx++);
                    buf.append("    ").append(conditionExpression.getText()).append("\n");
                    int i = 0;
                    for (int key : switchData.getKeys()) {
                        int switchHits = switchData.getHits()[i++];
                        buf.append("    ").append("    ").append("case ").append(key).append(": ").append(switchHits).append("\n");
                        hits += switchHits;
                    }
                    int defaultHits = switchData.getDefaultHits();
                    boolean hasDefaultLabel = JavaCoverageEngine.hasDefaultLabel((PsiElement)conditionExpression);
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    if (!hasDefaultLabel) {
                        defaultHits -= hits;
                    }
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    buf.append("    ").append("    ").append("default: ").append(defaultHits).append("\n");
                    hits += defaultHits;
                }
            }
            if (lineData.getHits() > hits && hits > 0) {
                buf.append("Unknown outcome: ").append(lineData.getHits() - hits);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return "Hits: " + lineData.getHits();
        }
        return buf.toString();
    }

    @Override
    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coverage/JavaCoverageEngine", "getTestMethodName"));
        }
        if (testProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testProxy", "com/intellij/coverage/JavaCoverageEngine", "getTestMethodName"));
        }
        return testProxy.toString();
    }

    @Override
    @NotNull
    public List<PsiElement> findTestsByNames(@NotNull String[] testNames, @NotNull Project project) {
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/intellij/coverage/JavaCoverageEngine", "findTestsByNames"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/JavaCoverageEngine", "findTestsByNames"));
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        block0: for (String testName : testNames) {
            PsiClass psiClass = facade.findClass(StringUtil.getPackageName((String)testName, (char)'_').replaceAll("\\_", "\\."), projectScope);
            int lastIdx = testName.lastIndexOf("_");
            if (psiClass != null) {
                JavaCoverageEngine.collectTestsByName(elements, testName, psiClass, lastIdx);
                continue;
            }
            String className = testName;
            while (lastIdx > 0) {
                className = className.substring(0, lastIdx - 1);
                psiClass = facade.findClass(StringUtil.getPackageName((String)className, (char)'_').replaceAll("\\_", "\\."), projectScope);
                lastIdx = className.lastIndexOf("_");
                if (psiClass == null) continue;
                JavaCoverageEngine.collectTestsByName(elements, testName, psiClass, lastIdx);
                continue block0;
            }
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "findTestsByNames"));
        }
        return arrayList;
    }

    private static void collectTestsByName(List<PsiElement> elements, String testName, PsiClass psiClass, int lastIdx) {
        PsiMethod[] testsByName = psiClass.findMethodsByName(testName.substring(lastIdx + 1), true);
        if (testsByName.length == 1) {
            elements.add((PsiElement)testsByName[0]);
        }
    }

    private static boolean hasDefaultLabel(PsiElement conditionExpression) {
        PsiElement bodyElement;
        boolean hasDefault = false;
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)conditionExpression, PsiSwitchStatement.class);
        PsiCodeBlock body = ((PsiSwitchStatementImpl)conditionExpression.getParent()).getBody();
        if (body != null && (bodyElement = body.getFirstBodyElement()) != null) {
            PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)bodyElement, PsiSwitchLabelStatement.class);
            while (label != null) {
                if (label.getEnclosingSwitchStatement() == switchStatement) {
                    hasDefault |= label.isDefaultCase();
                }
                label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiSwitchLabelStatement.class);
            }
        }
        return hasDefault;
    }

    protected JavaCoverageSuite createSuite(CoverageRunner acceptedCovRunner, String name, CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        return new JavaCoverageSuite(name, coverageDataFileProvider, filters, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, acceptedCovRunner, this, project);
    }

    @NotNull
    protected static String getPackageName(final PsiFile sourceFile) {
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return ((PsiClassOwner)sourceFile).getPackageName();
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine", "getPackageName"));
        }
        return string;
    }

    protected static void generateJavaReport(final @NotNull Project project, final File tempFile, final CoverageSuitesBundle currentSuite) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/JavaCoverageEngine", "generateJavaReport"));
        }
        final ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        final ProjectData projectData = currentSuite.getCoverageData();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Generating coverage report ..."){
            final Exception[] myExceptions;
            {
                super(arg0, arg1);
                this.myExceptions = new Exception[1];
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/JavaCoverageEngine$10", "run"));
                }
                try {
                    new SaveHook(tempFile, true, (ClassFinder)new IdeaClassFinder(project, currentSuite)).save(projectData);
                    HTMLReportBuilder builder = ReportBuilderFactory.createHTMLReportBuilder();
                    builder.setReportDir(new File(settings.OUTPUT_DIRECTORY));
                    SourceCodeProvider sourceCodeProvider = new SourceCodeProvider(){

                        public String getSourceCode(@NotNull String classname) throws IOException {
                            if (classname == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classname", "com/intellij/coverage/JavaCoverageEngine$10$1", "getSourceCode"));
                            }
                            return (String)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                                if (project == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/JavaCoverageEngine$10$1", "lambda$getSourceCode$0"));
                                }
                                if (classname == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classname", "com/intellij/coverage/JavaCoverageEngine$10$1", "lambda$getSourceCode$0"));
                                }
                                if (project.isDisposed()) {
                                    return "";
                                }
                                PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)project), (String)classname);
                                return psiClass != null ? psiClass.getNavigationElement().getContainingFile().getText() : "";
                            });
                        }
                    };
                    builder.generateReport((CoverageData)new IDEACoverageData(projectData, sourceCodeProvider){

                        @NotNull
                        public Collection<ClassInfo> getClasses() {
                            Collection classes = super.getClasses();
                            if (!currentSuite.isTrackTestFolders()) {
                                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                                GlobalSearchScope productionScope = GlobalSearchScopes.projectProductionScope((Project)project);
                                Iterator iterator = classes.iterator();
                                while (iterator.hasNext()) {
                                    ClassInfo aClass = (ClassInfo)iterator.next();
                                    PsiClass psiClass = (PsiClass)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                                        if (project == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/JavaCoverageEngine$10$2", "lambda$getClasses$0"));
                                        }
                                        if (project.isDisposed()) {
                                            return null;
                                        }
                                        return psiFacade.findClass(aClass.getFQName(), productionScope);
                                    });
                                    if (psiClass != null) continue;
                                    iterator.remove();
                                }
                            }
                            Collection collection = classes;
                            if (collection == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageEngine$10$2", "getClasses"));
                            }
                            return collection;
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (ReportGenerationFailedException e) {
                    this.myExceptions[0] = e;
                }
            }

            public void onSuccess() {
                if (this.myExceptions[0] != null) {
                    Messages.showErrorDialog((Project)project, (String)this.myExceptions[0].getMessage(), (String)CommonBundle.getErrorTitle());
                    return;
                }
                if (settings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(settings.OUTPUT_DIRECTORY, "index.html"));
                }
            }
        });
    }

    @Override
    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/JavaCoverageEngine", "isReportGenerationAvailable"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/coverage/JavaCoverageEngine", "isReportGenerationAvailable"));
        }
        if (currentSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSuite", "com/intellij/coverage/JavaCoverageEngine", "isReportGenerationAvailable"));
        }
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return projectSdk != null;
    }

    @Override
    public final void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/JavaCoverageEngine", "generateReport"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/coverage/JavaCoverageEngine", "generateReport"));
        }
        if (currentSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSuite", "com/intellij/coverage/JavaCoverageEngine", "generateReport"));
        }
        try {
            File tempFile = FileUtil.createTempFile((String)"temp", (String)"");
            tempFile.deleteOnExit();
            JavaCoverageEngine.generateJavaReport(project, tempFile, currentSuite);
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
    }

    @Override
    public String getPresentableText() {
        return "Java Coverage";
    }

    @Override
    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return new JavaCoverageViewExtension((JavaCoverageAnnotator)this.getCoverageAnnotator(project), project, suiteBundle, stateBean);
    }

    public boolean isSourceMapNeeded(RunConfigurationBase configuration) {
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])Extensions.getExtensions(JavaCoverageEngineExtension.EP_NAME)) {
            if (!extension.isSourceMapNeeded(configuration)) continue;
            return true;
        }
        return false;
    }
}

