/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public final class FunctionUtils {
    private FunctionUtils() {
    }

    public static <T, V> Predicate<T> where(Function<T, V> function, Predicate<? super V> predicate) {
        Preconditions.notNull(function, "function must not be null");
        Preconditions.notNull(predicate, "predicate must not be null");
        return input -> predicate.test((Object)function.apply(input));
    }
}

