/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "RenameIdentifierFix", "idea-android"})
public final class IllegalIdentifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element2) {
                boolean bl;
                block5: {
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    ASTNode aSTNode = element2.getNode();
                    if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.IDENTIFIER)) ^ true) {
                        return;
                    }
                    String text2 = element2.getText();
                    if (!StringsKt.startsWith$default((CharSequence)text2, (char)'`', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)text2, (char)'`', (boolean)false, (int)2, null)) {
                        return;
                    }
                    String unquotedName = KtPsiUtil.unquoteIdentifier(text2);
                    CharSequence charSequence = unquotedName;
                    if (charSequence.length() == 0) {
                        return;
                    }
                    charSequence = unquotedName;
                    CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
                    while (charIterator.hasNext()) {
                        char element$iv = charIterator.nextChar();
                        char it = element$iv;
                        if (this.isValidDalvikCharacter(it)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (!bl && this.checkAndroidFacet(element2)) {
                    this.$holder.registerProblem(element2, "Identifier not allowed in Android projects", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{new RenameIdentifierFix()});
                }
            }

            public final boolean checkAndroidFacet(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                return AndroidUtilKt.getAndroidFacetForFile(element2) != null || ApplicationManager.getApplication().isUnitTestMode();
            }

            public final boolean isValidDalvikCharacter(char c) {
                boolean bl;
                char c2;
                char c3 = c2 = c;
                boolean bl2 = true;
                if (c3 < 'A') {
                    bl2 = false;
                }
                boolean bl3 = true;
                if (c3 > 'Z') {
                    bl3 = false;
                }
                if (bl2 & bl3) {
                    bl = true;
                } else {
                    char c4 = c2;
                    boolean bl4 = true;
                    if (c4 < 'a') {
                        bl4 = false;
                    }
                    boolean bl5 = true;
                    if (c4 > 'z') {
                        bl5 = false;
                    }
                    if (bl4 & bl5) {
                        bl = true;
                    } else {
                        char c5 = c2;
                        boolean bl6 = true;
                        if (c5 < '0') {
                            bl6 = false;
                        }
                        boolean bl7 = true;
                        if (c5 > '9') {
                            bl7 = false;
                        }
                        if (bl6 & bl7) {
                            bl = true;
                        } else if (c2 == '$' || c2 == '-' || c2 == '_') {
                            bl = true;
                        } else {
                            char c6 = c2;
                            boolean bl8 = true;
                            if (c6 < '\u00a1') {
                                bl8 = false;
                            }
                            boolean bl9 = true;
                            if (c6 > '\u1fff') {
                                bl9 = false;
                            }
                            if (bl8 & bl9) {
                                bl = true;
                            } else {
                                char c7 = c2;
                                boolean bl10 = true;
                                if (c7 < '\u2010') {
                                    bl10 = false;
                                }
                                boolean bl11 = true;
                                if (c7 > '\u2027') {
                                    bl11 = false;
                                }
                                if (bl10 & bl11) {
                                    bl = true;
                                } else {
                                    char c8 = c2;
                                    boolean bl12 = true;
                                    if (c8 < '\u2030') {
                                        bl12 = false;
                                    }
                                    boolean bl13 = true;
                                    if (c8 > '\ud7ff') {
                                        bl13 = false;
                                    }
                                    if (bl12 & bl13) {
                                        bl = true;
                                    } else {
                                        char c9 = c2;
                                        boolean bl14 = true;
                                        if (c9 < '\ue000') {
                                            bl14 = false;
                                        }
                                        boolean bl15 = true;
                                        if (c9 > '\uffef') {
                                            bl15 = false;
                                        }
                                        bl = bl14 & bl15;
                                    }
                                }
                            }
                        }
                    }
                }
                return bl;
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$RenameIdentifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea-android"})
    public static final class RenameIdentifierFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Rename";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block4: {
                void elements$iv;
                RenameHandler renameHandler;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement = descriptor2.getPsiElement();
                if (psiElement == null) {
                    return;
                }
                PsiElement element2 = psiElement;
                PsiFile psiFile = element2.getContainingFile();
                if (psiFile == null) {
                    return;
                }
                PsiFile file2 = psiFile;
                if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                    return;
                }
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                FileEditor fileEditor = editorManager.getSelectedEditor(file2.getVirtualFile());
                if (fileEditor == null) {
                    return;
                }
                FileEditor editor = fileEditor;
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
                RenameHandler renameHandler2 = renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
                if (renameHandler2 == null) break block4;
                PsiElement[] psiElementArray = new PsiElement[]{element2};
                Project project2 = project;
                RenameHandler renameHandler3 = renameHandler2;
                Object[] objectArray = (Object[])elements$iv;
                renameHandler3.invoke(project2, (PsiElement[])objectArray, dataContext);
            }
        }
    }
}

