/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.DebugInfoUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;

public class CheckerTestUtil {
    public static final Comparator<Diagnostic> DIAGNOSTIC_COMPARATOR = new Comparator<Diagnostic>(){

        @Override
        public int compare(@NotNull Diagnostic o1, @NotNull Diagnostic o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "compare"));
            }
            List<TextRange> ranges1 = o1.getTextRanges();
            List<TextRange> ranges2 = o2.getTextRanges();
            int minNumberOfRanges = ranges1.size() < ranges2.size() ? ranges1.size() : ranges2.size();
            for (int i = 0; i < minNumberOfRanges; ++i) {
                int endOffset2;
                int startOffset2;
                TextRange range1 = ranges1.get(i);
                TextRange range2 = ranges2.get(i);
                int startOffset1 = range1.getStartOffset();
                if (startOffset1 != (startOffset2 = range2.getStartOffset())) {
                    return startOffset1 - range2.getStartOffset();
                }
                int endOffset1 = range1.getEndOffset();
                if (endOffset1 == (endOffset2 = range2.getEndOffset())) continue;
                return endOffset2 - endOffset1;
            }
            return ranges1.size() - ranges2.size();
        }
    };
    private static final String IGNORE_DIAGNOSTIC_PARAMETER = "IGNORE";
    private static final String SHOULD_BE_ESCAPED = "\\)\\(;";
    private static final String DIAGNOSTIC_PARAMETER = "(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+";
    private static final String INDIVIDUAL_DIAGNOSTIC = "(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?";
    private static final Pattern RANGE_START_OR_END_PATTERN = Pattern.compile("(<!(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?(,\\s*(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?)*!>)|(<!>)");
    private static final Pattern INDIVIDUAL_DIAGNOSTIC_PATTERN = Pattern.compile("(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?");
    private static final Pattern INDIVIDUAL_PARAMETER_PATTERN = Pattern.compile("(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+");

    @NotNull
    public static List<Diagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext2, final @NotNull PsiElement root, boolean markDynamicCalls, @Nullable List<DeclarationDescriptor> dynamicCallDescriptors) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        ArrayList<Diagnostic> diagnostics2 = new ArrayList<Diagnostic>();
        diagnostics2.addAll(Collections2.filter(bindingContext2.getDiagnostics().all(), (Predicate)new Predicate<Diagnostic>(){

            public boolean apply(Diagnostic diagnostic) {
                return PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)diagnostic.getPsiElement(), (boolean)false);
            }
        }));
        for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges(root)) {
            diagnostics2.add(new SyntaxErrorDiagnostic(errorElement));
        }
        List<Diagnostic> debugAnnotations = CheckerTestUtil.getDebugInfoDiagnostics(root, bindingContext2, markDynamicCalls, dynamicCallDescriptors);
        diagnostics2.addAll(debugAnnotations);
        ArrayList<Diagnostic> arrayList = diagnostics2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        return arrayList;
    }

    @NotNull
    private static List<Diagnostic> getDebugInfoDiagnostics(@NotNull PsiElement root, @NotNull BindingContext bindingContext2, final boolean markDynamicCalls, final @Nullable List<DeclarationDescriptor> dynamicCallDescriptors) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        final ArrayList debugAnnotations = Lists.newArrayList();
        DebugInfoUtil.markDebugAnnotations(root, bindingContext2, new DebugInfoUtil.DebugInfoReporter(){

            @Override
            public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportElementWithErrorType"));
                }
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.ELEMENT_WITH_ERROR_TYPE);
            }

            @Override
            public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportMissingUnresolved"));
                }
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.MISSING_UNRESOLVED);
            }

            @Override
            public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportUnresolvedWithTarget"));
                }
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportUnresolvedWithTarget"));
                }
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.UNRESOLVED_WITH_TARGET);
            }

            @Override
            public void reportDynamicCall(@NotNull KtElement element2, DeclarationDescriptor declarationDescriptor) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportDynamicCall"));
                }
                if (dynamicCallDescriptors != null) {
                    dynamicCallDescriptors.add(declarationDescriptor);
                }
                if (markDynamicCalls) {
                    this.newDiagnostic(element2, DebugInfoDiagnosticFactory.DYNAMIC);
                }
            }

            private void newDiagnostic(KtElement element2, DebugInfoDiagnosticFactory factory2) {
                debugAnnotations.add(new DebugInfoDiagnostic(element2, factory2));
            }
        });
        for (KtExpression expression2 : bindingContext2.getSliceContents(BindingContext.SMARTCAST).keySet()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression2, (boolean)false)) continue;
            debugAnnotations.add(new DebugInfoDiagnostic(expression2, DebugInfoDiagnosticFactory.SMARTCAST));
        }
        for (KtExpression expression2 : bindingContext2.getSliceContents(BindingContext.IMPLICIT_RECEIVER_SMARTCAST).keySet()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression2, (boolean)false)) continue;
            debugAnnotations.add(new DebugInfoDiagnostic(expression2, DebugInfoDiagnosticFactory.IMPLICIT_RECEIVER_SMARTCAST));
        }
        for (KtExpression expression2 : bindingContext2.getSliceContents(BindingContext.SMARTCAST_NULL).keySet()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression2, (boolean)false)) continue;
            debugAnnotations.add(new DebugInfoDiagnostic(expression2, DebugInfoDiagnosticFactory.CONSTANT));
        }
        for (KtExpression expression2 : bindingContext2.getSliceContents(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN).keySet()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression2, (boolean)false)) continue;
            debugAnnotations.add(new DebugInfoDiagnostic(expression2, DebugInfoDiagnosticFactory.IMPLICIT_EXHAUSTIVE));
        }
        ArrayList arrayList = debugAnnotations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        return arrayList;
    }

    public static void diagnosticsDiff(Map<Diagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, List<DiagnosedRange> expected, Collection<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        CheckerTestUtil.assertSameFile(actual);
        Iterator<DiagnosedRange> expectedDiagnostics = expected.iterator();
        List<DiagnosticDescriptor> sortedDiagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(actual);
        Iterator<DiagnosticDescriptor> actualDiagnostics = sortedDiagnosticDescriptors.iterator();
        DiagnosedRange currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
        DiagnosticDescriptor currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        while (currentExpected != null || currentActual != null) {
            if (currentExpected != null) {
                if (currentActual == null) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                int expectedStart = currentExpected.getStart();
                int actualStart = currentActual.getStart();
                int expectedEnd = currentExpected.getEnd();
                int actualEnd = currentActual.getEnd();
                if (expectedStart < actualStart) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedStart > actualStart) {
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                if (expectedEnd > actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedEnd < actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                CheckerTestUtil.compareDiagnostics(callbacks, currentExpected, currentActual, diagnosticToExpectedDiagnostic);
                currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                continue;
            }
            assert (currentActual != null);
            CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
            currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        }
    }

    private static void compareDiagnostics(@NotNull DiagnosticDiffCallbacks callbacks, @NotNull DiagnosedRange currentExpected, @NotNull DiagnosticDescriptor currentActual, @NotNull Map<Diagnostic, TextDiagnostic> diagnosticToInput) {
        if (callbacks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callbacks", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (currentExpected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentExpected", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (currentActual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentActual", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (diagnosticToInput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticToInput", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        int expectedStart = currentExpected.getStart();
        int expectedEnd = currentExpected.getEnd();
        int actualStart = currentActual.getStart();
        int actualEnd = currentActual.getEnd();
        assert (expectedStart == actualStart && expectedEnd == actualEnd);
        Map<Diagnostic, TextDiagnostic> actualDiagnostics = currentActual.getTextDiagnosticsMap();
        List<TextDiagnostic> expectedDiagnostics = currentExpected.getDiagnostics();
        for (TextDiagnostic expectedDiagnostic : expectedDiagnostics) {
            boolean diagnosticFound = false;
            for (Diagnostic actualDiagnostic : actualDiagnostics.keySet()) {
                TextDiagnostic actualTextDiagnostic = actualDiagnostics.get(actualDiagnostic);
                if (!expectedDiagnostic.getName().equals(actualTextDiagnostic.getName())) continue;
                if (!CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic)) {
                    callbacks.wrongParametersDiagnostic(expectedDiagnostic, actualTextDiagnostic, expectedStart, expectedEnd);
                }
                actualDiagnostics.remove(actualDiagnostic);
                diagnosticToInput.put(actualDiagnostic, expectedDiagnostic);
                diagnosticFound = true;
                break;
            }
            if (diagnosticFound) continue;
            callbacks.missingDiagnostic(expectedDiagnostic, expectedStart, expectedEnd);
        }
        for (TextDiagnostic unexpectedDiagnostic : actualDiagnostics.values()) {
            callbacks.unexpectedDiagnostic(unexpectedDiagnostic, actualStart, actualEnd);
        }
    }

    private static boolean compareTextDiagnostic(@NotNull TextDiagnostic expected, @NotNull TextDiagnostic actual) {
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareTextDiagnostic"));
        }
        if (actual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actual", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareTextDiagnostic"));
        }
        if (!expected.getName().equals(actual.getName())) {
            return false;
        }
        if (expected.getParameters() == null) {
            return true;
        }
        if (actual.getParameters() == null || expected.getParameters().size() != actual.getParameters().size()) {
            return false;
        }
        for (int index2 = 0; index2 < expected.getParameters().size(); ++index2) {
            String expectedParameter = expected.getParameters().get(index2);
            String actualParameter = actual.getParameters().get(index2);
            if (expectedParameter.equals(IGNORE_DIAGNOSTIC_PARAMETER) || expectedParameter.equals(actualParameter)) continue;
            return false;
        }
        return true;
    }

    private static void assertSameFile(Collection<Diagnostic> actual) {
        if (actual.isEmpty()) {
            return;
        }
        PsiFile file2 = actual.iterator().next().getPsiElement().getContainingFile();
        for (Diagnostic diagnostic : actual) {
            assert (diagnostic.getPsiFile().equals(file2)) : "All diagnostics should come from the same file: " + diagnostic.getPsiFile() + ", " + file2;
        }
    }

    private static void unexpectedDiagnostics(List<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        for (Diagnostic diagnostic : actual) {
            List<TextRange> textRanges = diagnostic.getTextRanges();
            for (TextRange textRange : textRanges) {
                callbacks.unexpectedDiagnostic(TextDiagnostic.asTextDiagnostic(diagnostic), textRange.getStartOffset(), textRange.getEndOffset());
            }
        }
    }

    private static void missingDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected) {
        for (TextDiagnostic diagnostic : currentExpected.getDiagnostics()) {
            callbacks.missingDiagnostic(diagnostic, currentExpected.getStart(), currentExpected.getEnd());
        }
    }

    private static <T> T safeAdvance(Iterator<T> iterator2) {
        return iterator2.hasNext() ? (T)iterator2.next() : null;
    }

    public static String parseDiagnosedRanges(String text2, List<DiagnosedRange> result2) {
        Matcher matcher2 = RANGE_START_OR_END_PATTERN.matcher(text2);
        Stack opened = new Stack();
        int offsetCompensation = 0;
        while (matcher2.find()) {
            int effectiveOffset = matcher2.start() - offsetCompensation;
            String matchedText = matcher2.group();
            if ("<!>".equals(matchedText)) {
                ((DiagnosedRange)opened.pop()).setEnd(effectiveOffset);
            } else {
                Matcher diagnosticTypeMatcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(matchedText);
                DiagnosedRange range = new DiagnosedRange(effectiveOffset);
                while (diagnosticTypeMatcher.find()) {
                    range.addDiagnostic(diagnosticTypeMatcher.group());
                }
                opened.push((Object)range);
                result2.add(range);
            }
            offsetCompensation += matchedText.length();
        }
        assert (opened.isEmpty()) : "Stack is not empty";
        matcher2.reset();
        return matcher2.replaceAll("");
    }

    public static StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<Diagnostic> diagnostics2) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnostics2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        return CheckerTestUtil.addDiagnosticMarkersToText(psiFile, diagnostics2, Collections.<Diagnostic, TextDiagnostic>emptyMap(), new Function<PsiFile, String>(){

            public String fun(PsiFile file2) {
                return file2.getText();
            }
        });
    }

    public static StringBuffer addDiagnosticMarkersToText(final @NotNull PsiFile psiFile, @NotNull Collection<Diagnostic> diagnostics2, @NotNull Map<Diagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, @NotNull Function<PsiFile, String> getFileText) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnostics2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnosticToExpectedDiagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticToExpectedDiagnostic", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (getFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getFileText", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        String text2 = (String)getFileText.fun((Object)psiFile);
        StringBuffer result2 = new StringBuffer();
        if (!(diagnostics2 = Collections2.filter(diagnostics2, (Predicate)new Predicate<Diagnostic>(){

            public boolean apply(Diagnostic diagnostic) {
                return psiFile.equals(diagnostic.getPsiFile());
            }
        })).isEmpty()) {
            List<DiagnosticDescriptor> diagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(diagnostics2);
            Stack opened = new Stack();
            ListIterator<DiagnosticDescriptor> iterator2 = diagnosticDescriptors.listIterator();
            DiagnosticDescriptor currentDescriptor = iterator2.next();
            for (int i = 0; i < text2.length(); ++i) {
                char c = text2.charAt(i);
                while (!opened.isEmpty() && i == ((DiagnosticDescriptor)opened.peek()).end) {
                    CheckerTestUtil.closeDiagnosticString(result2);
                    opened.pop();
                }
                while (currentDescriptor != null && i == currentDescriptor.start) {
                    CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic);
                    if (currentDescriptor.getEnd() == i) {
                        CheckerTestUtil.closeDiagnosticString(result2);
                    } else {
                        opened.push((Object)currentDescriptor);
                    }
                    if (iterator2.hasNext()) {
                        currentDescriptor = iterator2.next();
                        continue;
                    }
                    currentDescriptor = null;
                }
                result2.append(c);
            }
            if (currentDescriptor != null) {
                assert (currentDescriptor.start == text2.length());
                assert (currentDescriptor.end == text2.length());
                CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic);
                opened.push((Object)currentDescriptor);
            }
            while (!opened.isEmpty() && text2.length() == ((DiagnosticDescriptor)opened.peek()).end) {
                CheckerTestUtil.closeDiagnosticString(result2);
                opened.pop();
            }
            assert (opened.isEmpty()) : "Stack is not empty: " + opened;
        } else {
            result2.append(text2);
        }
        return result2;
    }

    private static void openDiagnosticsString(StringBuffer result2, DiagnosticDescriptor currentDescriptor, Map<Diagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic) {
        result2.append("<!");
        Iterator iterator2 = currentDescriptor.diagnostics.iterator();
        while (iterator2.hasNext()) {
            Diagnostic diagnostic = (Diagnostic)iterator2.next();
            if (diagnosticToExpectedDiagnostic.containsKey(diagnostic)) {
                TextDiagnostic actualTextDiagnostic;
                TextDiagnostic expectedDiagnostic = diagnosticToExpectedDiagnostic.get(diagnostic);
                if (CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic = TextDiagnostic.asTextDiagnostic(diagnostic))) {
                    result2.append(expectedDiagnostic.asString());
                } else {
                    result2.append(actualTextDiagnostic.asString());
                }
            } else {
                result2.append(diagnostic.getFactory().getName());
            }
            if (!iterator2.hasNext()) continue;
            result2.append(", ");
        }
        result2.append("!>");
    }

    private static void closeDiagnosticString(StringBuffer result2) {
        result2.append("<!>");
    }

    @NotNull
    private static List<DiagnosticDescriptor> getSortedDiagnosticDescriptors(@NotNull Collection<Diagnostic> diagnostics2) {
        if (diagnostics2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getSortedDiagnosticDescriptors"));
        }
        LinkedListMultimap diagnosticsGroupedByRanges = LinkedListMultimap.create();
        for (Diagnostic diagnostic : diagnostics2) {
            if (!diagnostic.isValid()) continue;
            for (TextRange textRange : diagnostic.getTextRanges()) {
                diagnosticsGroupedByRanges.put((Object)textRange, (Object)diagnostic);
            }
        }
        ArrayList diagnosticDescriptors = Lists.newArrayList();
        for (TextRange range : diagnosticsGroupedByRanges.keySet()) {
            diagnosticDescriptors.add(new DiagnosticDescriptor(range.getStartOffset(), range.getEndOffset(), diagnosticsGroupedByRanges.get((Object)range)));
        }
        Collections.sort(diagnosticDescriptors, new Comparator<DiagnosticDescriptor>(){

            @Override
            public int compare(@NotNull DiagnosticDescriptor d1, @NotNull DiagnosticDescriptor d2) {
                if (d1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d1", "org/jetbrains/kotlin/checkers/CheckerTestUtil$6", "compare"));
                }
                if (d2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d2", "org/jetbrains/kotlin/checkers/CheckerTestUtil$6", "compare"));
                }
                return d1.start != d2.start ? d1.start - d2.start : d2.end - d1.end;
            }
        });
        ArrayList arrayList = diagnosticDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getSortedDiagnosticDescriptors"));
        }
        return arrayList;
    }

    public static class DiagnosedRange {
        private final int start;
        private int end;
        private final List<TextDiagnostic> diagnostics = ContainerUtil.newSmartList();
        private PsiFile file;

        protected DiagnosedRange(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<TextDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void addDiagnostic(String diagnostic) {
            this.diagnostics.add(TextDiagnostic.parseDiagnostic(diagnostic));
        }

        public void setFile(@NotNull PsiFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DiagnosedRange", "setFile"));
            }
            this.file = file2;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.file;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DiagnosedRange", "getFile"));
            }
            return psiFile;
        }
    }

    public static class TextDiagnostic {
        @NotNull
        private final String name;
        @Nullable
        private final List<String> parameters;

        @NotNull
        private static TextDiagnostic parseDiagnostic(String text2) {
            Matcher matcher2 = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(text2);
            if (!matcher2.find()) {
                throw new IllegalArgumentException("Could not parse diagnostic: " + text2);
            }
            String name2 = matcher2.group(1);
            String parameters2 = matcher2.group(2);
            if (parameters2 == null) {
                TextDiagnostic textDiagnostic = new TextDiagnostic(name2, null);
                if (textDiagnostic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "parseDiagnostic"));
                }
                return textDiagnostic;
            }
            SmartList parsedParameters = new SmartList();
            Matcher parametersMatcher = INDIVIDUAL_PARAMETER_PATTERN.matcher(parameters2);
            while (parametersMatcher.find()) {
                parsedParameters.add(TextDiagnostic.unescape(parametersMatcher.group().trim()));
            }
            TextDiagnostic textDiagnostic = new TextDiagnostic(name2, (List<String>)parsedParameters);
            if (textDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "parseDiagnostic"));
            }
            return textDiagnostic;
        }

        @NotNull
        private static String escape(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "escape"));
            }
            String string = s.replaceAll("([\\)\\(;])", "\\\\$1");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "escape"));
            }
            return string;
        }

        @NotNull
        private static String unescape(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "unescape"));
            }
            String string = s.replaceAll("\\\\([\\)\\(;])", "$1");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "unescape"));
            }
            return string;
        }

        @NotNull
        public static TextDiagnostic asTextDiagnostic(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
            }
            DiagnosticRenderer renderer2 = DefaultErrorMessages.getRendererForDiagnostic(diagnostic);
            String diagnosticName = diagnostic.getFactory().getName();
            if (renderer2 instanceof AbstractDiagnosticWithParametersRenderer) {
                Object[] renderParameters = ((AbstractDiagnosticWithParametersRenderer)renderer2).renderParameters(diagnostic);
                List parameters2 = ContainerUtil.map((Object[])renderParameters, (Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return o != null ? o.toString() : "null";
                    }
                });
                TextDiagnostic textDiagnostic = new TextDiagnostic(diagnosticName, parameters2);
                if (textDiagnostic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
                }
                return textDiagnostic;
            }
            TextDiagnostic textDiagnostic = new TextDiagnostic(diagnosticName, null);
            if (textDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
            }
            return textDiagnostic;
        }

        public TextDiagnostic(@NotNull String name2, @Nullable List<String> parameters2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "<init>"));
            }
            this.name = name2;
            this.parameters = parameters2;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "getName"));
            }
            return string;
        }

        @Nullable
        public List<String> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextDiagnostic that = (TextDiagnostic)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = 31 * result2 + (this.parameters != null ? this.parameters.hashCode() : 0);
            return result2;
        }

        @NotNull
        public String asString() {
            if (this.parameters == null) {
                String string = this.name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asString"));
                }
                return string;
            }
            String string = this.name + '(' + StringUtil.join(this.parameters, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return TextDiagnostic.escape(s);
                }
            }, (String)"; ") + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asString"));
            }
            return string;
        }
    }

    private static class DiagnosticDescriptor {
        private final int start;
        private final int end;
        private final List<Diagnostic> diagnostics;

        DiagnosticDescriptor(int start, int end, List<Diagnostic> diagnostics2) {
            this.start = start;
            this.end = end;
            this.diagnostics = diagnostics2;
        }

        public Map<Diagnostic, TextDiagnostic> getTextDiagnosticsMap() {
            IdentityHashMap<Diagnostic, TextDiagnostic> diagnosticMap = new IdentityHashMap<Diagnostic, TextDiagnostic>();
            for (Diagnostic diagnostic : this.diagnostics) {
                diagnosticMap.put(diagnostic, TextDiagnostic.asTextDiagnostic(diagnostic));
            }
            return diagnosticMap;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<Diagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public TextRange getTextRange() {
            return new TextRange(this.start, this.end);
        }
    }

    public static class DebugInfoDiagnostic
    extends AbstractDiagnosticForTests {
        public DebugInfoDiagnostic(@NotNull KtElement element2, @NotNull DebugInfoDiagnosticFactory factory2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            super((PsiElement)element2, factory2);
        }
    }

    public static class DebugInfoDiagnosticFactory
    extends DiagnosticFactory<DebugInfoDiagnostic> {
        public static final DebugInfoDiagnosticFactory SMARTCAST = new DebugInfoDiagnosticFactory("SMARTCAST");
        public static final DebugInfoDiagnosticFactory IMPLICIT_RECEIVER_SMARTCAST = new DebugInfoDiagnosticFactory("IMPLICIT_RECEIVER_SMARTCAST");
        public static final DebugInfoDiagnosticFactory CONSTANT = new DebugInfoDiagnosticFactory("CONSTANT");
        public static final DebugInfoDiagnosticFactory IMPLICIT_EXHAUSTIVE = new DebugInfoDiagnosticFactory("IMPLICIT_EXHAUSTIVE");
        public static final DebugInfoDiagnosticFactory ELEMENT_WITH_ERROR_TYPE = new DebugInfoDiagnosticFactory("ELEMENT_WITH_ERROR_TYPE");
        public static final DebugInfoDiagnosticFactory UNRESOLVED_WITH_TARGET = new DebugInfoDiagnosticFactory("UNRESOLVED_WITH_TARGET");
        public static final DebugInfoDiagnosticFactory MISSING_UNRESOLVED = new DebugInfoDiagnosticFactory("MISSING_UNRESOLVED");
        public static final DebugInfoDiagnosticFactory DYNAMIC = new DebugInfoDiagnosticFactory("DYNAMIC");
        private final String name;

        private DebugInfoDiagnosticFactory(String name2, Severity severity) {
            super(severity);
            this.name = name2;
        }

        private DebugInfoDiagnosticFactory(String name2) {
            this(name2, Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            String string = "DEBUG_INFO_" + this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnosticFactory", "getName"));
            }
            return string;
        }
    }

    public static class SyntaxErrorDiagnostic
    extends AbstractDiagnosticForTests {
        public SyntaxErrorDiagnostic(@NotNull PsiErrorElement errorElement) {
            if (errorElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorElement", "org/jetbrains/kotlin/checkers/CheckerTestUtil$SyntaxErrorDiagnostic", "<init>"));
            }
            super((PsiElement)errorElement, SyntaxErrorDiagnosticFactory.INSTANCE);
        }
    }

    public static class SyntaxErrorDiagnosticFactory
    extends DiagnosticFactory<SyntaxErrorDiagnostic> {
        public static final SyntaxErrorDiagnosticFactory INSTANCE = new SyntaxErrorDiagnosticFactory();

        private SyntaxErrorDiagnosticFactory() {
            super(Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            if ("SYNTAX" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$SyntaxErrorDiagnosticFactory", "getName"));
            }
            return "SYNTAX";
        }
    }

    public static class AbstractDiagnosticForTests
    implements Diagnostic {
        private final PsiElement element;
        private final DiagnosticFactory<?> factory;

        public AbstractDiagnosticForTests(@NotNull PsiElement element2, @NotNull DiagnosticFactory<?> factory2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            this.element = element2;
            this.factory = factory2;
        }

        @Override
        @NotNull
        public DiagnosticFactory<?> getFactory() {
            DiagnosticFactory<?> diagnosticFactory = this.factory;
            if (diagnosticFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getFactory"));
            }
            return diagnosticFactory;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            Severity severity = Severity.ERROR;
            if (severity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getSeverity"));
            }
            return severity;
        }

        @Override
        @NotNull
        public PsiElement getPsiElement() {
            PsiElement psiElement = this.element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiElement"));
            }
            return psiElement;
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            List<TextRange> list2 = Collections.singletonList(this.element.getTextRange());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getTextRanges"));
            }
            return list2;
        }

        @Override
        @NotNull
        public PsiFile getPsiFile() {
            PsiFile psiFile = this.element.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiFile"));
            }
            return psiFile;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static interface DiagnosticDiffCallbacks {
        public void missingDiagnostic(TextDiagnostic var1, int var2, int var3);

        public void wrongParametersDiagnostic(TextDiagnostic var1, TextDiagnostic var2, int var3, int var4);

        public void unexpectedDiagnostic(TextDiagnostic var1, int var2, int var3);
    }
}

