/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codegen/SourceInfo;", "", "source", "", "pathOrCleanFQN", "linesInFile", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "getLinesInFile", "()I", "getPathOrCleanFQN", "()Ljava/lang/String;", "getSource", "component1", "component2", "component3", "copy", "Companion", "backend"})
public final class SourceInfo {
    @NotNull
    private final String source;
    @NotNull
    private final String pathOrCleanFQN;
    private final int linesInFile;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getPathOrCleanFQN() {
        return this.pathOrCleanFQN;
    }

    public final int getLinesInFile() {
        return this.linesInFile;
    }

    public SourceInfo(@NotNull String source, @NotNull String pathOrCleanFQN, int linesInFile) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pathOrCleanFQN, (String)"pathOrCleanFQN");
        this.source = source;
        this.pathOrCleanFQN = pathOrCleanFQN;
        this.linesInFile = linesInFile;
    }

    @NotNull
    public final String component1() {
        return this.source;
    }

    @NotNull
    public final String component2() {
        return this.pathOrCleanFQN;
    }

    public final int component3() {
        return this.linesInFile;
    }

    @NotNull
    public final SourceInfo copy(@NotNull String source, @NotNull String pathOrCleanFQN, int linesInFile) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pathOrCleanFQN, (String)"pathOrCleanFQN");
        return new SourceInfo(source, pathOrCleanFQN, linesInFile);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SourceInfo copy$default(SourceInfo sourceInfo, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n2 & 1) != 0) {
            string = sourceInfo.source;
        }
        if ((n2 & 2) != 0) {
            string2 = sourceInfo.pathOrCleanFQN;
        }
        if ((n2 & 4) != 0) {
            n = sourceInfo.linesInFile;
        }
        return sourceInfo.copy(string, string2, n);
    }

    public String toString() {
        return "SourceInfo(source=" + this.source + ", pathOrCleanFQN=" + this.pathOrCleanFQN + ", linesInFile=" + this.linesInFile + ")";
    }

    public int hashCode() {
        String string = this.source;
        String string2 = this.pathOrCleanFQN;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + this.linesInFile;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SourceInfo)) break block3;
                SourceInfo sourceInfo = (SourceInfo)object;
                if (!Intrinsics.areEqual((Object)this.source, (Object)sourceInfo.source) || !Intrinsics.areEqual((Object)this.pathOrCleanFQN, (Object)sourceInfo.pathOrCleanFQN) || !(this.linesInFile == sourceInfo.linesInFile)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/codegen/SourceInfo$Companion;", "", "()V", "createInfo", "Lorg/jetbrains/kotlin/codegen/SourceInfo;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "internalClassName", "", "backend"})
    public static final class Companion {
        @NotNull
        public final SourceInfo createInfo(@Nullable KtElement element2, @NotNull String internalClassName) {
            Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
            boolean bl = element2 != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Couldn't create source mapper for null element " + internalClassName;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtElement ktElement = element2;
            if (ktElement == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement = (PsiElement)ktElement.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element!!.containingFile");
            Integer lineNumbers = CodegenUtil.getLineNumberForElement(psiElement, true);
            boolean $i$a$1$assert = lineNumbers != null;
            if (_Assertions.ENABLED && !$i$a$1$assert) {
                String string = "Couldn't extract line count in " + element2.getContainingFile();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            boolean isTopLevel = element2 instanceof KtFile || element2 instanceof KtNamedFunction && element2.getParent() instanceof KtFile;
            String cleanedClassFqName = !isTopLevel ? internalClassName : StringsKt.substringBefore$default((String)internalClassName, (char)'$', null, (int)2, null);
            String string = element2.getContainingKtFile().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.getContainingKtFile().name");
            Integer n = lineNumbers;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            return new SourceInfo(string, cleanedClassFqName, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

