/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.And;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CoercionValue;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCallStackValue;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OperationStackValue;
import org.jetbrains.kotlin.codegen.Or;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.synthetic.SamAdapterExtensionFunctionDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    private static final String NULLABLE_BYTE_TYPE_NAME = "java/lang/Byte";
    private static final String NULLABLE_SHORT_TYPE_NAME = "java/lang/Short";
    private static final String NULLABLE_LONG_TYPE_NAME = "java/lang/Long";
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    private static final StackValue UNIT = StackValue.operation(AsmTypes.UNIT_TYPE, new Function1<InstructionAdapter, Unit>(){

        public Unit invoke(InstructionAdapter v) {
            v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
            return null;
        }
    });
    @NotNull
    public final Type type;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "<init>"));
        }
        this(type2, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "<init>"));
        }
        this.type = type2;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "moveToTopOfStack"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "moveToTopOfStack"));
        }
        this.put(type2, v);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        this.put(type2, v, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        if (!skipReceiver) {
            this.putReceiver(v, true);
        }
        this.putSelector(type2, v);
    }

    public abstract void putSelector(@NotNull Type var1, @NotNull InstructionAdapter var2);

    public boolean isNonStaticAccess(boolean isRead) {
        return false;
    }

    public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "putReceiver"));
        }
    }

    public void dup(@NotNull InstructionAdapter v, boolean withReceiver2) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "dup"));
        }
        if (!Type.VOID_TYPE.equals((Object)this.type)) {
            AsmUtil.dup(v, this.type);
        }
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        this.store(value2, v, false);
    }

    public boolean canHaveSideEffects() {
        return this.canHaveSideEffects;
    }

    public void store(@NotNull StackValue value2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        if (!skipReceiver) {
            this.putReceiver(v, false);
        }
        value2.put(value2.type, v);
        this.storeSelector(value2.type, v);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue", "storeSelector"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "storeSelector"));
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    @NotNull
    public static Local local(int index2, @NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "local"));
        }
        Local local = new Local(index2, type2);
        if (local == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "local"));
        }
        return local;
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "shared"));
        }
        Shared shared = new Shared(index2, type2);
        if (shared == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "shared"));
        }
        return shared;
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "onStack"));
        }
        StackValue stackValue = type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "onStack"));
        }
        return stackValue;
    }

    @NotNull
    public static StackValue constant(@Nullable Object value2, @NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "constant"));
        }
        if (type2 == Type.BOOLEAN_TYPE) {
            assert (value2 instanceof Boolean) : "Value for boolean constant should have boolean type: " + value2;
            BranchedValue branchedValue = BranchedValue.Companion.booleanConstant((Boolean)value2);
            if (branchedValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "constant"));
            }
            return branchedValue;
        }
        Constant constant = new Constant(value2, type2);
        if (constant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "constant"));
        }
        return constant;
    }

    @NotNull
    public static StackValue cmp(@NotNull IElementType opToken, @NotNull Type type2, StackValue left, StackValue right) {
        if (opToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/StackValue", "cmp"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "cmp"));
        }
        StackValue stackValue = BranchedValue.Companion.cmp(opToken, type2, left, right);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "cmp"));
        }
        return stackValue;
    }

    @NotNull
    public static StackValue not(@NotNull StackValue stackValue) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/StackValue", "not"));
        }
        StackValue stackValue2 = BranchedValue.Companion.createInvertValue(stackValue);
        if (stackValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "not"));
        }
        return stackValue2;
    }

    public static StackValue or(@NotNull StackValue left, @NotNull StackValue right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/codegen/StackValue", "or"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/codegen/StackValue", "or"));
        }
        return new Or(left, right);
    }

    public static StackValue and(@NotNull StackValue left, @NotNull StackValue right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/codegen/StackValue", "and"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/codegen/StackValue", "and"));
        }
        return new And(left, right);
    }

    public static StackValue compareIntWithZero(@NotNull StackValue argument2, int operation) {
        if (argument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/StackValue", "compareIntWithZero"));
        }
        return new BranchedValue(argument2, null, Type.INT_TYPE, operation);
    }

    public static StackValue compareWithNull(@NotNull StackValue argument2, int operation) {
        if (argument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/StackValue", "compareWithNull"));
        }
        return new BranchedValue(argument2, null, AsmTypes.OBJECT_TYPE, operation);
    }

    @NotNull
    public static StackValue arrayElement(@NotNull Type type2, StackValue array, StackValue index2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "arrayElement"));
        }
        ArrayElement arrayElement = new ArrayElement(type2, array, index2);
        if (arrayElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "arrayElement"));
        }
        return arrayElement;
    }

    @NotNull
    public static StackValue collectionElement(CollectionElementReceiver collectionElementReceiver, Type type2, ResolvedCall<FunctionDescriptor> getter, ResolvedCall<FunctionDescriptor> setter, ExpressionCodegen codegen) {
        CollectionElement collectionElement = new CollectionElement(collectionElementReceiver, type2, getter, setter, codegen);
        if (collectionElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "collectionElement"));
        }
        return collectionElement;
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name2, boolean isStatic, @NotNull StackValue receiver) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        Field field2 = StackValue.field(type2, owner, name2, isStatic, receiver, null);
        if (field2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        return field2;
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name2, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        Field field2 = new Field(type2, owner, name2, isStatic, receiver, descriptor2);
        if (field2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        return field2;
    }

    @NotNull
    public static Field field(@NotNull Field field2, @NotNull StackValue newReceiver) {
        if (field2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (newReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReceiver", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        Field field3 = StackValue.field(field2.type, field2.owner, field2.name, field2.isStaticPut, newReceiver, field2.descriptor);
        if (field3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        return field3;
    }

    @NotNull
    public static Field field(@NotNull FieldInfo info, @NotNull StackValue receiver) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        Field field2 = StackValue.field(info.getFieldType(), Type.getObjectType((String)info.getOwnerInternalName()), info.getFieldName(), info.isStatic(), receiver);
        if (field2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        return field2;
    }

    @NotNull
    public static StackValue changeReceiverForFieldAndSharedVar(@NotNull StackValueWithSimpleReceiver stackValue, @Nullable StackValue newReceiver) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
        }
        if (newReceiver != null && !stackValue.isStaticPut) {
            if (stackValue instanceof Field) {
                Field field2 = StackValue.field((Field)stackValue, newReceiver);
                if (field2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
                }
                return field2;
            }
            if (stackValue instanceof FieldForSharedVar) {
                FieldForSharedVar fieldForSharedVar = StackValue.fieldForSharedVar((FieldForSharedVar)stackValue, newReceiver);
                if (fieldForSharedVar == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
                }
                return fieldForSharedVar;
            }
        }
        StackValueWithSimpleReceiver stackValueWithSimpleReceiver = stackValue;
        if (stackValueWithSimpleReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
        }
        return stackValueWithSimpleReceiver;
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @NotNull Type type2, boolean isStaticBackingField, @Nullable String fieldName, @Nullable CallableMethod getter, @Nullable CallableMethod setter, GenerationState state, @NotNull StackValue receiver) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        Property property2 = new Property(descriptor2, backingFieldOwner, getter, setter, isStaticBackingField, fieldName, type2, state, receiver);
        if (property2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        return property2;
    }

    @NotNull
    public static StackValue expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
        Expression expression3 = new Expression(type2, expression2, generator);
        if (expression3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "expression"));
        }
        return expression3;
    }

    private static void box(Type type2, Type toType, InstructionAdapter v) {
        if (type2 == Type.BYTE_TYPE || toType.getInternalName().equals(NULLABLE_BYTE_TYPE_NAME) && type2 == Type.INT_TYPE) {
            v.cast(type2, Type.BYTE_TYPE);
            v.invokestatic(NULLABLE_BYTE_TYPE_NAME, "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (type2 == Type.SHORT_TYPE || toType.getInternalName().equals(NULLABLE_SHORT_TYPE_NAME) && type2 == Type.INT_TYPE) {
            v.cast(type2, Type.SHORT_TYPE);
            v.invokestatic(NULLABLE_SHORT_TYPE_NAME, "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (type2 == Type.LONG_TYPE || toType.getInternalName().equals(NULLABLE_LONG_TYPE_NAME) && type2 == Type.INT_TYPE) {
            v.cast(type2, Type.LONG_TYPE);
            v.invokestatic(NULLABLE_LONG_TYPE_NAME, "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (type2 == Type.INT_TYPE) {
            v.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (type2 == Type.BOOLEAN_TYPE) {
            v.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (type2 == Type.CHAR_TYPE) {
            v.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        } else if (type2 == Type.FLOAT_TYPE) {
            v.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        }
    }

    private static void unbox(Type type2, InstructionAdapter v) {
        if (type2 == Type.INT_TYPE) {
            v.invokevirtual("java/lang/Number", "intValue", "()I", false);
        } else if (type2 == Type.BOOLEAN_TYPE) {
            v.invokevirtual("java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (type2 == Type.CHAR_TYPE) {
            v.invokevirtual("java/lang/Character", "charValue", "()C", false);
        } else if (type2 == Type.SHORT_TYPE) {
            v.invokevirtual("java/lang/Number", "shortValue", "()S", false);
        } else if (type2 == Type.LONG_TYPE) {
            v.invokevirtual("java/lang/Number", "longValue", "()J", false);
        } else if (type2 == Type.BYTE_TYPE) {
            v.invokevirtual("java/lang/Number", "byteValue", "()B", false);
        } else if (type2 == Type.FLOAT_TYPE) {
            v.invokevirtual("java/lang/Number", "floatValue", "()F", false);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.invokevirtual("java/lang/Number", "doubleValue", "()D", false);
        }
    }

    protected void coerceTo(@NotNull Type toType, @NotNull InstructionAdapter v) {
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "org/jetbrains/kotlin/codegen/StackValue", "coerceTo"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "coerceTo"));
        }
        StackValue.coerce(this.type, toType, v);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue", "coerceFrom"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "coerceFrom"));
        }
        StackValue.coerce(topOfStackType, this.type, v);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "org/jetbrains/kotlin/codegen/StackValue", "coerce"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "org/jetbrains/kotlin/codegen/StackValue", "coerce"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "coerce"));
        }
        if (toType.equals((Object)fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop((MethodVisitor)v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals((Object)AsmTypes.UNIT_TYPE) || toType.equals((Object)AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else if (toType.getSort() == 10 || toType.getSort() == 9) {
                v.aconst(null);
            } else {
                AsmUtil.pushDefaultPrimitiveValueOnStack(toType, v);
            }
        } else if (toType.equals((Object)AsmTypes.UNIT_TYPE)) {
            if (fromType.equals((Object)AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals((Object)AsmTypes.getType(Void.class))) {
                AsmUtil.pop((MethodVisitor)v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            if (fromType.getSort() == 9 && fromType.getElementType().equals((Object)AsmTypes.JAVA_CLASS_TYPE) && toType.equals((Object)AsmTypes.K_CLASS_ARRAY_TYPE)) {
                AsmUtil.wrapJavaClassesIntoKClasses(v);
            } else {
                v.checkcast(toType);
            }
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals((Object)AsmTypes.OBJECT_TYPE)) {
                    if (fromType.equals((Object)AsmTypes.JAVA_CLASS_TYPE) && toType.equals((Object)AsmTypes.K_CLASS_TYPE)) {
                        AsmUtil.wrapJavaClassIntoKClass(v);
                    } else {
                        v.checkcast(toType);
                    }
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(unboxedType, v);
                StackValue.coerce(unboxedType, toType, v);
            } else {
                if (toType.getSort() == 1 || toType.getSort() == 2) {
                    StackValue.coerce(fromType, AsmUtil.boxType(toType), v);
                } else {
                    StackValue.coerce(fromType, AsmTypes.getType(Number.class), v);
                }
                StackValue.unbox(toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(@NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "putUnitInstance"));
        }
        StackValue.unit().put(AsmTypes.UNIT_TYPE, v);
    }

    public static StackValue unit() {
        return UNIT;
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static Field receiverWithRefWrapper(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
        if (localType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localType", "org/jetbrains/kotlin/codegen/StackValue", "receiverWithRefWrapper"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/kotlin/codegen/StackValue", "receiverWithRefWrapper"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/StackValue", "receiverWithRefWrapper"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "receiverWithRefWrapper"));
        }
        return StackValue.field(StackValue.sharedTypeForType(localType), classType, fieldName, false, receiver, descriptor2);
    }

    public static FieldForSharedVar fieldForSharedVar(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull Field refWrapper) {
        if (localType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localType", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (refWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refWrapper", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        return new FieldForSharedVar(localType, classType, fieldName, refWrapper);
    }

    @NotNull
    public static FieldForSharedVar fieldForSharedVar(@NotNull FieldForSharedVar field2, @NotNull StackValue newReceiver) {
        if (field2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (newReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReceiver", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        Field oldReceiver = (Field)field2.receiver;
        Field newSharedVarReceiver = StackValue.field(oldReceiver, newReceiver);
        FieldForSharedVar fieldForSharedVar = new FieldForSharedVar(field2.type, field2.owner, field2.name, newSharedVarReceiver);
        if (fieldForSharedVar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        return fieldForSharedVar;
    }

    public static StackValue coercion(@NotNull StackValue value2, @NotNull Type castType) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue", "coercion"));
        }
        if (castType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "castType", "org/jetbrains/kotlin/codegen/StackValue", "coercion"));
        }
        if (value2.type.equals((Object)castType)) {
            return value2;
        }
        return new CoercionValue(value2, castType);
    }

    @NotNull
    public static StackValue thisOrOuter(@NotNull ExpressionCodegen codegen, @NotNull ClassDescriptor descriptor2, boolean isSuper, boolean castReceiver) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue", "thisOrOuter"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue", "thisOrOuter"));
        }
        boolean coerceType = descriptor2.getKind() == ClassKind.INTERFACE || castReceiver && !isSuper;
        ThisOuter thisOuter = new ThisOuter(codegen, descriptor2, isSuper, coerceType);
        if (thisOuter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "thisOrOuter"));
        }
        return thisOuter;
    }

    public static StackValue postIncrement(int index2, int increment) {
        return new PostIncrement(index2, increment);
    }

    public static StackValue preIncrementForLocalVar(int index2, int increment) {
        return new PreIncrementForLocalVar(index2, increment);
    }

    public static StackValue preIncrement(@NotNull Type type2, @NotNull StackValue stackValue, int delta, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "preIncrement"));
        }
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/StackValue", "preIncrement"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue", "preIncrement"));
        }
        if (stackValue instanceof Local && Type.INT_TYPE == stackValue.type) {
            return StackValue.preIncrementForLocalVar(((Local)stackValue).index, delta);
        }
        return new PrefixIncrement(type2, stackValue, resolvedCall2, codegen);
    }

    public static StackValue receiver(ResolvedCall<?> resolvedCall2, StackValue receiver, ExpressionCodegen codegen, @Nullable Callable callableMethod) {
        ReceiverValue callDispatchReceiver = resolvedCall2.getDispatchReceiver();
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof SyntheticFieldDescriptor) {
            callDispatchReceiver = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverForBackend();
        }
        ReceiverValue callExtensionReceiver = resolvedCall2.getExtensionReceiver();
        if (callDispatchReceiver != null || callExtensionReceiver != null || StackValue.isLocalFunCall(callableMethod) || StackValue.isCallToMemberObjectImportedByName(resolvedCall2)) {
            ReceiverParameterDescriptor dispatchReceiverParameter = descriptor2.getDispatchReceiverParameter();
            ReceiverParameterDescriptor extensionReceiverParameter = descriptor2.getExtensionReceiverParameter();
            if (descriptor2.getOriginal() instanceof SamAdapterExtensionFunctionDescriptor) {
                callDispatchReceiver = callExtensionReceiver;
                callExtensionReceiver = null;
                dispatchReceiverParameter = extensionReceiverParameter;
                extensionReceiverParameter = null;
            } else if (descriptor2 instanceof SyntheticFieldDescriptor) {
                dispatchReceiverParameter = ((SyntheticFieldDescriptor)descriptor2).getDispatchReceiverParameterForBackend();
            }
            boolean hasExtensionReceiver = callExtensionReceiver != null;
            StackValue dispatchReceiver = StackValue.platformStaticCallIfPresent(StackValue.genReceiver(hasExtensionReceiver ? StackValue.none() : receiver, codegen, resolvedCall2, callableMethod, callDispatchReceiver, false), descriptor2);
            StackValue extensionReceiver = StackValue.genReceiver(receiver, codegen, resolvedCall2, callableMethod, callExtensionReceiver, true);
            Type type2 = CallReceiver.calcType(resolvedCall2, dispatchReceiverParameter, extensionReceiverParameter, codegen.typeMapper, callableMethod, codegen.getState());
            assert (type2 != null) : "Could not map receiver type for " + resolvedCall2;
            return new CallReceiver(dispatchReceiver, extensionReceiver, type2);
        }
        return receiver;
    }

    private static StackValue genReceiver(@NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @NotNull ResolvedCall resolvedCall2, @Nullable Callable callableMethod, @Nullable ReceiverValue receiverValue, boolean isExtension) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "genReceiver"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue", "genReceiver"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/StackValue", "genReceiver"));
        }
        if (receiver == StackValue.none()) {
            if (receiverValue != null) {
                return codegen.generateReceiverValue(receiverValue, false);
            }
            if (StackValue.isLocalFunCall(callableMethod) && !isExtension) {
                StackValue value2 = codegen.findLocalOrCapturedValue(resolvedCall2.getResultingDescriptor().getOriginal());
                assert (value2 != null) : "Local fun should be found in locals or in captured params: " + resolvedCall2;
                return value2;
            }
            if (StackValue.isCallToMemberObjectImportedByName(resolvedCall2)) {
                return StackValue.singleton(((ImportedFromObjectCallableDescriptor)resolvedCall2.getResultingDescriptor()).getContainingObject(), codegen.typeMapper);
            }
        } else if (receiverValue != null) {
            return receiver;
        }
        return StackValue.none();
    }

    private static boolean isCallToMemberObjectImportedByName(@NotNull ResolvedCall resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/StackValue", "isCallToMemberObjectImportedByName"));
        }
        return resolvedCall2.getResultingDescriptor() instanceof ImportedFromObjectCallableDescriptor;
    }

    private static StackValue platformStaticCallIfPresent(@NotNull StackValue resultReceiver, @NotNull CallableDescriptor descriptor2) {
        if (resultReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultReceiver", "org/jetbrains/kotlin/codegen/StackValue", "platformStaticCallIfPresent"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue", "platformStaticCallIfPresent"));
        }
        if (AnnotationUtilKt.isPlatformStaticInObjectOrClass(descriptor2)) {
            if (resultReceiver.canHaveSideEffects()) {
                return StackValue.coercion(resultReceiver, Type.VOID_TYPE);
            }
            return StackValue.none();
        }
        return resultReceiver;
    }

    @Contract(value="null -> false")
    private static boolean isLocalFunCall(@Nullable Callable callableMethod) {
        return callableMethod != null && callableMethod.getGenerateCalleeType() != null;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            CallReceiver callReceiver = (CallReceiver)receiverWithParameter;
            return new CallReceiver(callReceiver.dispatchReceiver, StackValue.none(), callReceiver.type);
        }
        return receiverWithParameter;
    }

    @NotNull
    public static Field enumEntry(@NotNull ClassDescriptor descriptor2, @NotNull KotlinTypeMapper typeMapper) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue", "enumEntry"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/StackValue", "enumEntry"));
        }
        DeclarationDescriptor enumClass = descriptor2.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(enumClass)) : "Enum entry should be declared in enum class: " + descriptor2;
        Type type2 = typeMapper.mapType((ClassDescriptor)enumClass);
        Field field2 = StackValue.field(type2, type2, descriptor2.getName().asString(), true, StackValue.none(), descriptor2);
        if (field2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "enumEntry"));
        }
        return field2;
    }

    @NotNull
    public static Field singleton(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/StackValue", "singleton"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/StackValue", "singleton"));
        }
        Field field2 = StackValue.field(FieldInfo.createForSingleton(classDescriptor, typeMapper), StackValue.none());
        if (field2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "singleton"));
        }
        return field2;
    }

    public static Field singletonViaInstance(ClassDescriptor classDescriptor, KotlinTypeMapper typeMapper) {
        return StackValue.field(FieldInfo.createSingletonViaInstance(classDescriptor, typeMapper), StackValue.none());
    }

    public static StackValue operation(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new OperationStackValue(type2, lambda2);
    }

    public static StackValue functionCall(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new FunctionCallStackValue(type2, lambda2);
    }

    public static boolean couldSkipReceiverOnStaticCall(StackValue value2) {
        return value2 instanceof Local || value2 instanceof Constant;
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "sharedTypeForType"));
        }
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                Type type3 = AsmTypes.OBJECT_REF_TYPE;
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "sharedTypeForType"));
                }
                return type3;
            }
        }
        PrimitiveType primitiveType = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(type2);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        String typeName = primitiveType.getTypeName().getIdentifier();
        Type type4 = Type.getObjectType((String)("kotlin/jvm/internal/Ref$" + typeName + "Ref"));
        if (type4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "sharedTypeForType"));
        }
        return type4;
    }

    public static Type refType(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return AsmTypes.OBJECT_TYPE;
        }
        return type2;
    }

    public static StackValue complexWriteReadReceiver(StackValue stackValue) {
        return StackValue.complexReceiver(stackValue, false, true);
    }

    private static StackValue complexReceiver(StackValue stackValue, boolean ... isReadOperations) {
        if (stackValue instanceof StackValueWithSimpleReceiver) {
            return new DelegatedForComplexReceiver(stackValue.type, (StackValueWithSimpleReceiver)stackValue, new ComplexReceiver((StackValueWithSimpleReceiver)stackValue, isReadOperations));
        }
        return stackValue;
    }

    static class SafeFallback
    extends StackValueWithSimpleReceiver {
        @Nullable
        private final Label ifNull;

        public SafeFallback(@NotNull Type type2, @Nullable Label ifNull, StackValue receiver) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "<init>"));
            }
            super(type2, false, false, receiver, true);
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "putSelector"));
            }
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            if (!this.type.equals((Object)Type.VOID_TYPE)) {
                v.aconst(null);
            }
            v.mark(end);
            this.coerceTo(type2, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightSide", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "store"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "store"));
            }
            this.receiver.store(rightSide, v, skipReceiver);
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            v.mark(end);
        }
    }

    static class SafeCall
    extends StackValue {
        @NotNull
        private final Type type;
        private final StackValue receiver;
        @Nullable
        private final Label ifNull;

        public SafeCall(@NotNull Type type2, @NotNull StackValue value2, @Nullable Label ifNull) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "<init>"));
            }
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "<init>"));
            }
            super(type2);
            this.type = type2;
            this.receiver = value2;
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "putSelector"));
            }
            this.receiver.put(this.type, v);
            if (this.ifNull != null) {
                v.dup();
                v.ifnull(this.ifNull);
            }
            this.coerceTo(type2, v);
        }
    }

    public static class DelegatedForComplexReceiver
    extends StackValueWithSimpleReceiver {
        public final StackValueWithSimpleReceiver originalValue;

        public DelegatedForComplexReceiver(@NotNull Type type2, @NotNull StackValueWithSimpleReceiver originalValue, @NotNull ComplexReceiver receiver) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "<init>"));
            }
            if (originalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalValue", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "<init>"));
            }
            super(type2, DelegatedForComplexReceiver.bothReceiverStatic(originalValue), DelegatedForComplexReceiver.bothReceiverStatic(originalValue), receiver, originalValue.canHaveSideEffects());
            this.originalValue = originalValue;
        }

        private static boolean bothReceiverStatic(StackValueWithSimpleReceiver originalValue) {
            return !originalValue.isNonStaticAccess(true) && !originalValue.isNonStaticAccess(false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "putSelector"));
            }
            this.originalValue.putSelector(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "storeSelector"));
            }
            this.originalValue.storeSelector(topOfStackType, v);
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "dup"));
            }
            this.originalValue.dup(v, withWriteReceiver);
        }
    }

    public static class Receiver
    extends StackValue {
        private final StackValue[] instructions;

        protected Receiver(@NotNull Type type2, StackValue ... receiverInstructions) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Receiver", "<init>"));
            }
            super(type2);
            this.instructions = receiverInstructions;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Receiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Receiver", "putSelector"));
            }
            for (StackValue instruction : this.instructions) {
                instruction.put(instruction.type, v);
            }
        }
    }

    private static class ComplexReceiver
    extends StackValue {
        private final StackValueWithSimpleReceiver originalValueWithReceiver;
        private final boolean[] isReadOperations;

        public ComplexReceiver(StackValueWithSimpleReceiver value2, boolean[] isReadOperations) {
            super(value2.type, value2.receiver.canHaveSideEffects());
            this.originalValueWithReceiver = value2;
            this.isReadOperations = isReadOperations;
            if (value2 instanceof CollectionElement && value2.receiver instanceof CollectionElementReceiver) {
                ((CollectionElementReceiver)value2.receiver).isComplexOperationWithDup = true;
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$ComplexReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ComplexReceiver", "putSelector"));
            }
            boolean wasPut = false;
            StackValue receiver = this.originalValueWithReceiver.receiver;
            for (boolean operation : this.isReadOperations) {
                if (!this.originalValueWithReceiver.isNonStaticAccess(operation)) continue;
                if (!wasPut) {
                    receiver.put(receiver.type, v);
                    wasPut = true;
                    continue;
                }
                receiver.dup(v, false);
            }
            if (!wasPut && receiver.canHaveSideEffects()) {
                receiver.put(Type.VOID_TYPE, v);
            }
        }
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStaticPut;
        public final boolean isStaticStore;
        @NotNull
        public final StackValue receiver;

        public StackValueWithSimpleReceiver(@NotNull Type type2, boolean isStaticPut, boolean isStaticStore, @NotNull StackValue receiver, boolean canHaveSideEffects) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "<init>"));
            }
            super(type2, canHaveSideEffects);
            this.receiver = receiver;
            this.isStaticPut = isStaticPut;
            this.isStaticStore = isStaticStore;
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "putReceiver"));
            }
            boolean hasReceiver = this.isNonStaticAccess(isRead);
            if (hasReceiver || this.receiver.canHaveSideEffects()) {
                this.receiver.put(hasReceiver ? this.receiver.type : Type.VOID_TYPE, v);
            }
        }

        @Override
        public boolean isNonStaticAccess(boolean isRead) {
            return isRead ? !this.isStaticPut : !this.isStaticStore;
        }

        public int receiverSize() {
            return this.receiver.type.getSize();
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "dup"));
            }
            if (!withWriteReceiver) {
                super.dup(v, false);
            } else {
                int receiverSize = this.isNonStaticAccess(false) ? this.receiverSize() : 0;
                switch (receiverSize) {
                    case 0: {
                        AsmUtil.dup(v, this.type);
                        break;
                    }
                    case 1: {
                        if (this.type.getSize() == 2) {
                            v.dup2X1();
                            break;
                        }
                        v.dupX1();
                        break;
                    }
                    case 2: {
                        if (this.type.getSize() == 2) {
                            v.dup2X2();
                            break;
                        }
                        v.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightSide", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "store"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "store"));
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            rightSide.put(rightSide.type, v);
            this.storeSelector(rightSide.type, v);
        }
    }

    public static class CallReceiver
    extends StackValue {
        private final StackValue dispatchReceiver;
        private final StackValue extensionReceiver;

        public CallReceiver(@NotNull StackValue dispatchReceiver, @NotNull StackValue extensionReceiver, @NotNull Type type2) {
            if (dispatchReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "<init>"));
            }
            if (extensionReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "<init>"));
            }
            super(type2, dispatchReceiver.canHaveSideEffects() || extensionReceiver.canHaveSideEffects());
            this.dispatchReceiver = dispatchReceiver;
            this.extensionReceiver = extensionReceiver;
        }

        @Nullable
        public static Type calcType(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ReceiverParameterDescriptor dispatchReceiver, @Nullable ReceiverParameterDescriptor extensionReceiver, @NotNull KotlinTypeMapper typeMapper, @Nullable Callable callableMethod, @NotNull GenerationState state) {
            if (resolvedCall2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "calcType"));
            }
            if (typeMapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "calcType"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "calcType"));
            }
            if (extensionReceiver != null) {
                Object descriptor2 = resolvedCall2.getCandidateDescriptor();
                if (descriptor2 instanceof PropertyDescriptor && !(state.getIntrinsics().getIntrinsic((PropertyDescriptor)descriptor2) instanceof JavaClassProperty)) {
                    ReceiverParameterDescriptor receiverCandidate = descriptor2.getExtensionReceiverParameter();
                    assert (receiverCandidate != null);
                    return typeMapper.mapType(receiverCandidate.getType());
                }
                return callableMethod != null ? callableMethod.getExtensionReceiverType() : typeMapper.mapType(extensionReceiver.getType());
            }
            if (dispatchReceiver != null) {
                Object descriptor3 = resolvedCall2.getResultingDescriptor();
                if (AnnotationUtilKt.isPlatformStaticInObjectOrClass(descriptor3)) {
                    return Type.VOID_TYPE;
                }
                if (callableMethod != null) {
                    return callableMethod.getDispatchReceiverType();
                }
                DeclarationDescriptor container2 = descriptor3.getContainingDeclaration();
                if (container2 instanceof ClassDescriptor) {
                    return typeMapper.mapClass((ClassDescriptor)container2);
                }
                return typeMapper.mapType(dispatchReceiver);
            }
            if (StackValue.isLocalFunCall(callableMethod)) {
                return callableMethod.getGenerateCalleeType();
            }
            return Type.VOID_TYPE;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            boolean hasExtensionReceiver;
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "putSelector"));
            }
            StackValue currentExtensionReceiver = this.extensionReceiver;
            boolean bl = hasExtensionReceiver = this.extensionReceiver != CallReceiver.none();
            if (this.extensionReceiver instanceof SafeCall) {
                currentExtensionReceiver.put(currentExtensionReceiver.type, v);
                currentExtensionReceiver = StackValue.onStack(currentExtensionReceiver.type);
            }
            this.dispatchReceiver.put(hasExtensionReceiver ? this.dispatchReceiver.type : type2, v);
            currentExtensionReceiver.moveToTopOfStack(hasExtensionReceiver ? type2 : currentExtensionReceiver.type, v, this.dispatchReceiver.type.getSize());
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withReceiver2) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "dup"));
            }
            AsmUtil.dup(v, this.extensionReceiver.type, this.dispatchReceiver.type);
        }
    }

    private static class PrefixIncrement
    extends StackValue {
        private final ResolvedCall resolvedCall;
        private final ExpressionCodegen codegen;
        private StackValue value;

        public PrefixIncrement(@NotNull Type type2, @NotNull StackValue value2, ResolvedCall resolvedCall2, @NotNull ExpressionCodegen codegen) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "<init>"));
            }
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "<init>"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "<init>"));
            }
            super(type2);
            this.value = value2;
            this.resolvedCall = resolvedCall2;
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "putSelector"));
            }
            this.value = StackValue.complexReceiver(this.value, new boolean[]{true, false, true});
            this.value.put(this.type, v);
            this.value.store(this.codegen.invokeFunction(this.resolvedCall, StackValue.onStack(this.type)), v, true);
            this.value.put(this.type, v, true);
            this.coerceTo(type2, v);
        }
    }

    private static class PreIncrementForLocalVar
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrementForLocalVar(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PreIncrementForLocalVar", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$PreIncrementForLocalVar", "putSelector"));
            }
            v.iinc(this.index, this.increment);
            if (!type2.equals((Object)Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PostIncrement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$PostIncrement", "putSelector"));
            }
            if (!type2.equals((Object)Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
            v.iinc(this.index, this.increment);
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor2, boolean isSuper, boolean coerceType) {
            super(AsmTypes.OBJECT_TYPE, false);
            this.codegen = codegen;
            this.descriptor = descriptor2;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$ThisOuter", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ThisOuter", "putSelector"));
            }
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type2 : stackValue.type, v);
        }
    }

    public static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final Type owner;
        final String name;

        public FieldForSharedVar(Type type2, Type owner, String name2, Field receiver) {
            super(type2, false, false, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "putSelector"));
            }
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "element", FieldForSharedVar.refType(this.type).getDescriptor());
        }
    }

    public static class Shared
    extends StackValueWithSimpleReceiver {
        private final int index;

        public Shared(int index2, Type type2) {
            super(type2, false, false, Shared.local(index2, AsmTypes.OBJECT_TYPE), false);
            this.index = index2;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Shared", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Shared", "putSelector"));
            }
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Shared", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Shared", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }
    }

    private static class Expression
    extends StackValue {
        private final KtExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type2, KtExpression expression2, ExpressionCodegen generator) {
            super(type2);
            this.expression = expression2;
            this.generator = generator;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Expression", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Expression", "putSelector"));
            }
            this.generator.gen(this.expression, type2);
        }
    }

    static class Property
    extends StackValueWithSimpleReceiver {
        private final CallableMethod getter;
        private final CallableMethod setter;
        private final Type backingFieldOwner;
        private final PropertyDescriptor descriptor;
        private final GenerationState state;
        private final String fieldName;

        public Property(@NotNull PropertyDescriptor descriptor2, @Nullable Type backingFieldOwner, @Nullable CallableMethod getter, @Nullable CallableMethod setter, boolean isStaticBackingField, @Nullable String fieldName, @NotNull Type type2, @NotNull GenerationState state, @NotNull StackValue receiver) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            super(type2, Property.isStatic(isStaticBackingField, getter), Property.isStatic(isStaticBackingField, setter), receiver, true);
            this.backingFieldOwner = backingFieldOwner;
            this.getter = getter;
            this.setter = setter;
            this.descriptor = descriptor2;
            this.state = state;
            this.fieldName = fieldName;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Property", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Property", "putSelector"));
            }
            if (this.getter == null) {
                assert (this.fieldName != null) : "Property should have either a getter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a getter or a backingFieldOwner: " + this.descriptor;
                if (this.inlineJavaConstantIfNeeded(type2, v)) {
                    return;
                }
                v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
                this.genNotNullAssertionForLateInitIfNeeded(v);
                this.coerceTo(type2, v);
            } else {
                this.getter.genInvokeInstruction(v);
                Property.coerce(this.getter.getReturnType(), type2, v);
                KotlinType returnType2 = this.descriptor.getReturnType();
                if (returnType2 != null && KotlinBuiltIns.isNothing(returnType2)) {
                    v.aconst(null);
                    v.athrow();
                }
            }
        }

        private boolean inlineJavaConstantIfNeeded(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Property", "inlineJavaConstantIfNeeded"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Property", "inlineJavaConstantIfNeeded"));
            }
            if (!JvmCodegenUtil.isInlinedJavaConstProperty(this.descriptor)) {
                return false;
            }
            assert (AsmUtil.isPrimitive(this.type) || AsmTypes.JAVA_STRING_TYPE.equals((Object)this.type)) : "Java const property should have primitive or string type: " + this.descriptor;
            assert (this.isStaticPut) : "Java const property should be static" + this.descriptor;
            JavaPropertyDescriptor javaPropertyDescriptor = (JavaPropertyDescriptor)this.descriptor;
            ConstantValue<?> constantValue = javaPropertyDescriptor.getCompileTimeInitializer();
            if (constantValue == null) {
                return false;
            }
            Object value2 = constantValue.getValue();
            if (this.type == Type.FLOAT_TYPE && value2 instanceof Double) {
                value2 = Float.valueOf(((Double)value2).floatValue());
            }
            StackValue.constant(value2, this.type).putSelector(type2, v);
            return true;
        }

        private void genNotNullAssertionForLateInitIfNeeded(@NotNull InstructionAdapter v) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Property", "genNotNullAssertionForLateInitIfNeeded"));
            }
            if (!this.descriptor.isLateInit()) {
                return;
            }
            v.dup();
            Label ok = new Label();
            v.ifnonnull(ok);
            v.visitLdcInsn((Object)this.descriptor.getName().asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwUninitializedPropertyAccessException", "(Ljava/lang/String;)V", false);
            v.mark(ok);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Property", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Property", "storeSelector"));
            }
            if (this.setter == null) {
                this.coerceFrom(topOfStackType, v);
                assert (this.fieldName != null) : "Property should have either a setter or a field name: " + this.descriptor;
                assert (this.backingFieldOwner != null) : "Property should have either a setter or a backingFieldOwner: " + this.descriptor;
                v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
            } else {
                Property.coerce(topOfStackType, (Type)ArraysKt.last((Object[])this.setter.getParameterTypes()), v);
                this.setter.genInvokeInstruction(v);
                Type returnType2 = this.setter.getReturnType();
                if (returnType2 != Type.VOID_TYPE) {
                    AsmUtil.pop((MethodVisitor)v, returnType2);
                }
            }
        }

        private static boolean isStatic(boolean isStaticBackingField, @Nullable CallableMethod callable) {
            if (isStaticBackingField && callable == null) {
                return true;
            }
            if (callable != null && callable.isStaticCall()) {
                JvmMethodParameterSignature parameter;
                JvmMethodParameterKind kind2;
                List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
                Iterator<JvmMethodParameterSignature> iterator2 = parameters2.iterator();
                while (iterator2.hasNext() && (kind2 = (parameter = iterator2.next()).getKind()) != JvmMethodParameterKind.VALUE) {
                    if (kind2 != JvmMethodParameterKind.RECEIVER && kind2 != JvmMethodParameterKind.THIS) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;
        public final DeclarationDescriptor descriptor;

        public Field(@NotNull Type type2, @NotNull Type owner, @NotNull String name2, boolean isStatic, @NotNull StackValue receiver, @Nullable DeclarationDescriptor descriptor2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Field", "<init>"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/StackValue$Field", "<init>"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/StackValue$Field", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$Field", "<init>"));
            }
            super(type2, isStatic, isStatic, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name2;
            this.descriptor = descriptor2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Field", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Field", "putSelector"));
            }
            v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Field", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Field", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }
    }

    public static class CollectionElement
    extends StackValueWithSimpleReceiver {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;

        public CollectionElement(@NotNull CollectionElementReceiver collectionElementReceiver, @NotNull Type type2, @Nullable ResolvedCall<FunctionDescriptor> resolvedGetCall, @Nullable ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull ExpressionCodegen codegen) {
            if (collectionElementReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectionElementReceiver", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "<init>"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "<init>"));
            }
            super(type2, false, false, collectionElementReceiver, true);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedSetCall), false, resolvedSetCall);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(codegen.accessibleFunctionDescriptor(resolvedGetCall), false, resolvedGetCall);
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "putSelector"));
            }
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            CallGenerator callGenerator = this.getCallGenerator();
            callGenerator.genCall(this.getter, this.resolvedGetCall, this.genDefaultMaskIfPresent(callGenerator), this.codegen);
            this.coerceTo(type2, v);
        }

        private boolean genDefaultMaskIfPresent(CallGenerator callGenerator) {
            DefaultCallArgs defaultArgs = ((CollectionElementReceiver)this.receiver).defaultArgs;
            return defaultArgs.generateOnStackIfNeeded(callGenerator, true);
        }

        private CallGenerator getCallGenerator() {
            CallGenerator generator = ((CollectionElementReceiver)this.receiver).callGenerator;
            assert (generator != null) : "CollectionElementReceiver should be putted on stack before CollectionElement: getCall = " + this.resolvedGetCall + ",  setCall = " + this.resolvedSetCall;
            return generator;
        }

        @Override
        public int receiverSize() {
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        public static boolean isStandardStack(@NotNull KotlinTypeMapper typeMapper, @Nullable ResolvedCall<?> call, int valueParamsSize) {
            if (typeMapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "isStandardStack"));
            }
            if (call == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters = call.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call.getDispatchReceiver() != null ? call.getExtensionReceiver() != null : typeMapper.mapType(call.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "storeSelector"));
            }
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            Type lastParameterType = (Type)ArraysKt.last((Object[])this.setter.getParameterTypes());
            CollectionElement.coerce(topOfStackType, lastParameterType, v);
            this.getCallGenerator().afterParameterPut(lastParameterType, StackValue.onStack(lastParameterType), CollectionsKt.getLastIndex(this.setter.getValueParameterTypes()));
            CollectionElementReceiver collectionElementReceiver = (CollectionElementReceiver)this.receiver;
            if (collectionElementReceiver.isGetter) {
                List arguments2 = collectionElementReceiver.valueArguments;
                List<Type> types2 = this.getter.getValueParameterTypes();
                for (int i = arguments2.size() - 1; i >= 0; --i) {
                    ResolvedValueArgument argument2 = (ResolvedValueArgument)arguments2.get(i);
                    if (!(argument2 instanceof DefaultValueArgument)) continue;
                    Type defaultType2 = types2.get(i);
                    AsmUtil.swap(v, lastParameterType, defaultType2);
                    AsmUtil.pop((MethodVisitor)v, defaultType2);
                }
            }
            this.getCallGenerator().genCall(this.setter, this.resolvedSetCall, false, this.codegen);
            Type returnType2 = this.setter.getReturnType();
            if (returnType2 != Type.VOID_TYPE) {
                AsmUtil.pop((MethodVisitor)v, returnType2);
            }
        }
    }

    public static class CollectionElementReceiver
    extends StackValue {
        private final Callable callable;
        private final boolean isGetter;
        private final ExpressionCodegen codegen;
        private final List<ResolvedValueArgument> valueArguments;
        private final FrameMap frame;
        private final StackValue receiver;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private DefaultCallArgs defaultArgs;
        private CallGenerator callGenerator;
        boolean isComplexOperationWithDup;

        public CollectionElementReceiver(@NotNull Callable callable, @NotNull StackValue receiver, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, boolean isGetter, @NotNull ExpressionCodegen codegen, List<ResolvedValueArgument> valueArguments2) {
            if (callable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "<init>"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "<init>"));
            }
            super(AsmTypes.OBJECT_TYPE);
            this.callable = callable;
            this.isGetter = isGetter;
            this.receiver = receiver;
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.valueArguments = valueArguments2;
            this.codegen = codegen;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "putSelector"));
            }
            ResolvedCall<FunctionDescriptor> call = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            StackValue newReceiver = StackValue.receiver(call, this.receiver, this.codegen, this.callable);
            ArgumentGenerator generator = this.createArgumentGenerator();
            newReceiver.put(newReceiver.type, v);
            this.callGenerator.putHiddenParams();
            this.defaultArgs = generator.generate(this.valueArguments, this.valueArguments);
        }

        private ArgumentGenerator createArgumentGenerator() {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            assert (this.callGenerator == null) : "'putSelector' and 'createArgumentGenerator' methods should be called once for CollectionElementReceiver: " + this.callable;
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            assert (resolvedCall2 != null) : "Resolved call should be non-null: " + this.callable;
            this.callGenerator = !this.isComplexOperationWithDup ? this.codegen.getOrCreateCallGenerator(resolvedCall2) : this.codegen.defaultCallGenerator;
            return new CallBasedArgumentGenerator(this.codegen, this.callGenerator, resolvedCall2.getResultingDescriptor().getValueParameters(), this.callable.getValueParameterTypes());
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withReceiver2) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "dup"));
            }
            this.dupReceiver(v);
        }

        public void dupReceiver(@NotNull InstructionAdapter v) {
            Type type2;
            int realReceiverIndex;
            Type realReceiverType;
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "dupReceiver"));
            }
            if (CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedGetCall, 1) && CollectionElement.isStandardStack(this.codegen.typeMapper, this.resolvedSetCall, 2)) {
                v.dup2();
                return;
            }
            FrameMap.Mark mark = this.frame.mark();
            List<ValueParameterDescriptor> valueParameters = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
            int firstParamIndex = -1;
            for (int i = valueParameters.size() - 1; i >= 0; --i) {
                Type type3 = this.codegen.typeMapper.mapType(valueParameters.get(i).getType());
                firstParamIndex = this.frame.enterTemp(type3);
                v.store(firstParamIndex, type3);
            }
            ReceiverValue receiverParameter = this.resolvedGetCall.getExtensionReceiver();
            int receiverIndex = -1;
            if (receiverParameter != null) {
                Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                receiverIndex = this.frame.enterTemp(type4);
                v.store(receiverIndex, type4);
            }
            ReceiverValue dispatchReceiver = this.resolvedGetCall.getDispatchReceiver();
            int thisIndex = -1;
            if (dispatchReceiver != null) {
                thisIndex = this.frame.enterTemp(AsmTypes.OBJECT_TYPE);
                v.store(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                realReceiverIndex = receiverIndex;
            } else if (thisIndex != -1) {
                realReceiverType = AsmTypes.OBJECT_TYPE;
                realReceiverIndex = thisIndex;
            } else {
                throw new UnsupportedOperationException();
            }
            if (this.resolvedSetCall.getDispatchReceiver() != null) {
                if (this.resolvedSetCall.getExtensionReceiver() != null) {
                    this.codegen.generateReceiverValue(this.resolvedSetCall.getDispatchReceiver(), false).put(AsmTypes.OBJECT_TYPE, v);
                }
                v.load(realReceiverIndex, realReceiverType);
            } else if (this.resolvedSetCall.getExtensionReceiver() != null) {
                v.load(realReceiverIndex, realReceiverType);
            } else {
                throw new UnsupportedOperationException();
            }
            int index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            if (thisIndex != -1) {
                v.load(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                v.load(receiverIndex, realReceiverType);
            }
            index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            mark.dropTo();
        }
    }

    private static class ArrayElement
    extends StackValueWithSimpleReceiver {
        private final Type type;

        public ArrayElement(Type type2, StackValue array, StackValue index2) {
            super(type2, false, false, new Receiver(Type.LONG_TYPE, array, index2), true);
            this.type = type2;
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.astore(this.type);
        }

        @Override
        public int receiverSize() {
            return 2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "putSelector"));
            }
            v.aload(this.type);
            this.coerceTo(type2, v);
        }
    }

    private static class Constant
    extends StackValue {
        @Nullable
        private final Object value;

        public Constant(@Nullable Object value2, Type type2) {
            super(type2, false);
            assert (!Type.BOOLEAN_TYPE.equals((Object)type2)) : "Boolean constants should be created via 'StackValue.constant'";
            this.value = value2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Constant", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Constant", "putSelector"));
            }
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v.iconst((int)((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v.lconst(((Long)this.value).longValue());
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst(((Double)this.value).doubleValue());
            } else {
                v.aconst(this.value);
            }
            this.coerceTo(type2, v);
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2) {
            super(type2);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "putSelector"));
            }
            this.coerceTo(type2, v);
        }

        @Override
        public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "moveToTopOfStack"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "moveToTopOfStack"));
            }
            if (depth2 == 0) {
                this.put(type2, v);
            } else if (depth2 == 1) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.swap();
                } else if (size == 2) {
                    v.dupX2();
                    v.pop();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, v);
            } else if (depth2 == 2) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.dup2X1();
                    v.pop2();
                } else if (size == 2) {
                    v.dup2X2();
                    v.pop2();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, v);
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth2);
            }
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index2, Type type2) {
            super(type2, false);
            this.index = index2;
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Local", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Local", "putSelector"));
            }
            v.load(this.index, this.type);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Local", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Local", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.store(this.index, this.type);
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$None", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$None", "putSelector"));
            }
            this.coerceTo(type2, v);
        }
    }
}

