/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.util.NotNullFunction;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;

public class MainFunctionDetector {
    private final NotNullFunction<KtNamedFunction, FunctionDescriptor> getFunctionDescriptor;

    public MainFunctionDetector(final @NotNull BindingContext bindingContext2) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/MainFunctionDetector", "<init>"));
        }
        this.getFunctionDescriptor = new NotNullFunction<KtNamedFunction, FunctionDescriptor>(){

            @NotNull
            public FunctionDescriptor fun(KtNamedFunction function2) {
                SimpleFunctionDescriptor functionDescriptor = bindingContext2.get(BindingContext.FUNCTION, function2);
                if (functionDescriptor == null) {
                    throw new IllegalStateException("No descriptor resolved for " + function2 + " " + function2.getText());
                }
                SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
                if (simpleFunctionDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/MainFunctionDetector$1", "fun"));
                }
                return simpleFunctionDescriptor;
            }
        };
    }

    public MainFunctionDetector(@NotNull NotNullFunction<KtNamedFunction, FunctionDescriptor> functionResolver) {
        if (functionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionResolver", "org/jetbrains/kotlin/idea/MainFunctionDetector", "<init>"));
        }
        this.getFunctionDescriptor = functionResolver;
    }

    public boolean hasMain(@NotNull List<KtDeclaration> declarations2) {
        if (declarations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/idea/MainFunctionDetector", "hasMain"));
        }
        return this.findMainFunction(declarations2) != null;
    }

    public boolean isMain(@NotNull KtNamedFunction function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/MainFunctionDetector", "isMain"));
        }
        if (function2.isLocal()) {
            return false;
        }
        if (function2.getValueParameters().size() != 1 || !function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (!"main".equals(function2.getName()) && !MainFunctionDetector.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (!function2.isTopLevel() && !MainFunctionDetector.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        return MainFunctionDetector.isMain((DeclarationDescriptor)this.getFunctionDescriptor.fun((Object)function2));
    }

    public static boolean isMain(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/MainFunctionDetector", "isMain"));
        }
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor2;
        if (!MainFunctionDetector.getJVMFunctionName(functionDescriptor).equals("main")) {
            return false;
        }
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        if (parameters2.size() != 1 || !functionDescriptor.getTypeParameters().isEmpty()) {
            return false;
        }
        ValueParameterDescriptor parameter = parameters2.get(0);
        KotlinType parameterType = parameter.getType();
        if (!KotlinBuiltIns.isArray(parameterType)) {
            return false;
        }
        List<TypeProjection> typeArguments = parameterType.getArguments();
        if (typeArguments.size() != 1) {
            return false;
        }
        KotlinType typeArgument = typeArguments.get(0).getType();
        if (!KotlinBuiltIns.isString(typeArgument)) {
            return false;
        }
        if (typeArguments.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
            return false;
        }
        if (DescriptorUtils.isTopLevelDeclaration(functionDescriptor)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
        return containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind().isSingleton() && AnnotationUtilKt.hasJvmStaticAnnotation(functionDescriptor);
    }

    @Nullable
    public KtNamedFunction getMainFunction(@NotNull Collection<KtFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/MainFunctionDetector", "getMainFunction"));
        }
        for (KtFile file2 : files) {
            KtNamedFunction mainFunction = this.findMainFunction(file2.getDeclarations());
            if (mainFunction == null) continue;
            return mainFunction;
        }
        return null;
    }

    @Nullable
    private KtNamedFunction findMainFunction(@NotNull List<KtDeclaration> declarations2) {
        if (declarations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/idea/MainFunctionDetector", "findMainFunction"));
        }
        for (KtDeclaration declaration : declarations2) {
            KtNamedFunction candidateFunction;
            if (!(declaration instanceof KtNamedFunction) || !this.isMain(candidateFunction = (KtNamedFunction)declaration)) continue;
            return candidateFunction;
        }
        return null;
    }

    @NotNull
    private static String getJVMFunctionName(FunctionDescriptor functionDescriptor) {
        String platformName = DescriptorUtils.getJvmName(functionDescriptor);
        if (platformName != null) {
            String string = platformName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/MainFunctionDetector", "getJVMFunctionName"));
            }
            return string;
        }
        String string = functionDescriptor.getName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/MainFunctionDetector", "getJVMFunctionName"));
        }
        return string;
    }

    private static boolean hasAnnotationWithExactNumberOfArguments(@NotNull KtNamedFunction function2, int number) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/MainFunctionDetector", "hasAnnotationWithExactNumberOfArguments"));
        }
        for (KtAnnotationEntry entry : function2.getAnnotationEntries()) {
            if (entry.getValueArguments().size() != number) continue;
            return true;
        }
        return false;
    }
}

