/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "handleBracketTyped", "", "overwriteClosingBracket", "idea"})
public final class KDocTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FileType fileType) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        if (this.overwriteClosingBracket(c, editor, file2)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.handleBracketTyped(c, project, editor, file2) ? TypedHandlerDelegate.Result.STOP : TypedHandlerDelegate.Result.CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean overwriteClosingBracket(char c, Editor editor, PsiFile file2) {
        if (c != ']' && c != ')') {
            return false;
        }
        if (!(file2 instanceof KtFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset2 = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset2 < document.getTextLength() && chars.charAt(offset2) == c) {
            boolean bl;
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
            PsiElement psiElement = file2.findElementAt(offset2);
            if (psiElement == null) {
                return false;
            }
            PsiElement element2 = psiElement;
            IElementType elementType = element2.getNode().getElementType();
            switch (c) {
                case ']': {
                    void strict$iv;
                    void $receiver$iv;
                    PsiElement psiElement2 = element2;
                    boolean bl2 = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KDoc.class, (boolean)strict$iv) != null && (Intrinsics.areEqual((Object)elementType, (Object)((Object)KtTokens.RBRACKET)) || offset2 > 0 && chars.charAt(offset2 - 1) == '[')) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case ')': {
                    bl = Intrinsics.areEqual((Object)elementType, (Object)((Object)KDocTokens.MARKDOWN_INLINE_LINK));
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean handleBracketTyped(char c, Project project, Editor editor, PsiFile file2) {
        if (c != '[' && c != '(') {
            return false;
        }
        if (!(file2 instanceof KtFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset2 = editor.getCaretModel().getOffset();
        if (offset2 == 0) {
            return false;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement psiElement = file2.findElementAt(offset2 - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement element2 = psiElement;
        if (Intrinsics.areEqual((Object)element2.getNode().getElementType(), (Object)((Object)KDocTokens.TEXT)) ^ true) {
            return false;
        }
        switch (c) {
            case '[': {
                document.insertString(offset2, (CharSequence)"]");
                return true;
            }
            case '(': {
                if (offset2 <= 1 || document.getCharsSequence().charAt(offset2 - 2) != ']') break;
                document.insertString(offset2, (CharSequence)")");
                return true;
            }
        }
        return false;
    }
}

