/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileTreeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTreeVisitor {
    private ConcurrentMap<String, Collection<FileTreeElement>> cachedTrees = new MapMaker().weakValues().makeMap();

    public Collection<FileTreeElement> visitTreeForSnapshotting(FileTreeInternal fileTree, boolean allowReuse) {
        DirectoryFileTree directoryFileTree;
        if (this.isDirectoryFileTree(fileTree) && this.isEligibleForCaching(directoryFileTree = (DirectoryFileTree)DirectoryFileTree.class.cast(((FileTreeAdapter)fileTree).getTree()))) {
            Collection<FileTreeElement> cachedTree;
            String absolutePath = directoryFileTree.getDir().getAbsolutePath();
            Collection<FileTreeElement> collection = cachedTree = allowReuse ? (Collection<FileTreeElement>)this.cachedTrees.get(absolutePath) : null;
            if (cachedTree != null) {
                return cachedTree;
            }
            cachedTree = this.doVisitTree(fileTree);
            this.cachedTrees.put(absolutePath, cachedTree);
            return cachedTree;
        }
        return this.doVisitTree(fileTree);
    }

    private boolean isEligibleForCaching(DirectoryFileTree directoryFileTree) {
        return directoryFileTree.getPatterns().isEmpty();
    }

    private boolean isDirectoryFileTree(FileTreeInternal fileTree) {
        return fileTree instanceof FileTreeAdapter && ((FileTreeAdapter)fileTree).getTree() instanceof DirectoryFileTree;
    }

    private Collection<FileTreeElement> doVisitTree(FileTreeInternal fileTree) {
        final ImmutableList.Builder fileTreeElements = ImmutableList.builder();
        fileTree.visitTreeOrBackingFile(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                fileTreeElements.add((Object)dirDetails);
            }

            public void visitFile(FileVisitDetails fileDetails) {
                fileTreeElements.add((Object)fileDetails);
            }
        });
        return fileTreeElements.build();
    }

    public void clearCache() {
        this.cachedTrees.clear();
    }
}

