/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.ComponentItemDialog;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import java.awt.Window;

public class EditComponentAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.palette.EditComponentAction");

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ComponentItem selectedItem = (ComponentItem)e.getData(ComponentItem.DATA_KEY);
        if (project == null || selectedItem == null || selectedItem.isAnyComponent() || selectedItem.isSpacer()) {
            return;
        }
        ComponentItem itemToBeEdited = selectedItem.clone();
        Window parentWindow = WindowManager.getInstance().suggestParentWindow(project);
        ComponentItemDialog dialog = new ComponentItemDialog(project, parentWindow, itemToBeEdited, false);
        dialog.setTitle(UIDesignerBundle.message("title.edit.component", new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        GroupItem groupItem = null;
        Palette palette = Palette.getInstance(project);
        for (GroupItem group : palette.getGroups()) {
            if (group.containsItemCopy(selectedItem, itemToBeEdited.getClassName())) {
                return;
            }
            if (!group.containsItemClass(selectedItem.getClassName())) continue;
            groupItem = group;
        }
        LOG.assertTrue(groupItem != null);
        palette.replaceItem(groupItem, selectedItem, itemToBeEdited);
        palette.fireGroupsChanged();
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ComponentItem selectedItem = (ComponentItem)e.getData(ComponentItem.DATA_KEY);
        GroupItem groupItem = (GroupItem)e.getData(GroupItem.DATA_KEY);
        e.getPresentation().setEnabled(project != null && selectedItem != null && groupItem != null && !selectedItem.isAnyComponent() && !selectedItem.isSpacer());
    }
}

