/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;

public class ChangeFieldTypeFix
extends QuickFix {
    private final PsiField myField;
    private final PsiType myNewType;

    public ChangeFieldTypeFix(GuiEditor uiEditor, PsiField field, PsiType uiComponentType) {
        super(uiEditor, ChangeFieldTypeFix.gettext(field, uiComponentType), null);
        this.myField = field;
        this.myNewType = uiComponentType;
    }

    private static String gettext(PsiField field, PsiType uiComponentType) {
        return UIDesignerBundle.message("action.change.field.type", field.getName(), field.getType().getCanonicalText(), uiComponentType.getCanonicalText());
    }

    @Override
    public void run() {
        PsiFile psiFile = this.myField.getContainingFile();
        if (psiFile == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)psiFile)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myField.getProject(), () -> {
            try {
                PsiManager manager = this.myField.getManager();
                this.myField.getTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeElement(this.myNewType));
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myEditor, (String)UIDesignerBundle.message("error.cannot.change.field.type", this.myField.getName(), e.getMessage()), (String)CommonBundle.getErrorTitle()));
            }
        }, this.getName(), null));
    }
}

