/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferTypeAction;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferWireframeAction;
import com.android.tools.idea.editors.gfxtrace.controllers.ImagePanelController;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.WireframeMode;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import icons.AndroidIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FrameBufferController
extends ImagePanelController {
    private static final int MAX_SIZE = 65535;
    @NotNull
    private final PathStore<DevicePath> myRenderDevice;
    @NotNull
    private final PathStore<AtomPath> myAtomPath;
    @NotNull
    private final RenderSettings mySettings;
    @NotNull
    private BufferType myBufferType;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new FrameBufferController((GfxTraceEditor)editor).myPanel;
    }

    private FrameBufferController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "<init>"));
        }
        super(editor, "Select a frame or command");
        this.myRenderDevice = new PathStore();
        this.myAtomPath = new PathStore();
        this.mySettings = new RenderSettings();
        this.myBufferType = BufferType.Color;
        this.mySettings.setMaxHeight(65535);
        this.mySettings.setMaxWidth(65535);
        this.mySettings.setWireframeMode(WireframeMode.NoWireframe);
        this.initToolbar(this.getToolbarActions(), false);
    }

    private DefaultActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Color, "Color Buffer", "Display the color framebuffer", AndroidIcons.GfxTrace.ColorBuffer));
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Depth, "Depth Buffer", "Display the depth framebuffer", AndroidIcons.GfxTrace.DepthBuffer));
        group.add((AnAction)new Separator());
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.NoWireframe, "Shaded", "Display the framebuffer with shaded polygons", AndroidIcons.GfxTrace.WireframeNone));
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.WireframeOverlay, "Shaded + Wireframe", "Display the framebuffer with shaded polygons and overlay the wireframe of the last draw call", AndroidIcons.GfxTrace.WireframeOverlay));
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.AllWireframe, "Wireframe", "Display the framebuffer with wireframes", AndroidIcons.GfxTrace.WireframeAll));
        group.add((AnAction)new Separator());
        return group;
    }

    @NotNull
    public BufferType getBufferType() {
        BufferType bufferType = this.myBufferType;
        if (bufferType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "getBufferType"));
        }
        return bufferType;
    }

    public void setBufferType(@NotNull BufferType bufferType) {
        if (bufferType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bufferType", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "setBufferType"));
        }
        if (!this.myBufferType.equals((Object)bufferType)) {
            this.myBufferType = bufferType;
            this.updateBuffer();
        }
    }

    @NotNull
    public WireframeMode getWireframeMode() {
        WireframeMode wireframeMode = this.mySettings.getWireframeMode();
        if (wireframeMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "getWireframeMode"));
        }
        return wireframeMode;
    }

    public void setWireframeMode(@NotNull WireframeMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "setWireframeMode"));
        }
        if (!this.mySettings.getWireframeMode().equals(mode)) {
            this.mySettings.setWireframeMode(mode);
            this.updateBuffer();
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        boolean updateBuffer = this.myRenderDevice.updateIfNotNull(event.findDevicePath());
        updateBuffer = this.myAtomPath.updateIfNotNull(event.findAtomPath()) | updateBuffer;
        if (updateBuffer && this.myRenderDevice.getPath() != null && this.myAtomPath.getPath() != null) {
            this.updateBuffer();
        }
    }

    private void updateBuffer() {
        this.setImage(FetchedImage.load(this.myEditor.getClient(), this.getImageInfoPath()));
    }

    private ListenableFuture<ImageInfoPath> getImageInfoPath() {
        switch (this.myBufferType) {
            case Color: {
                return this.myEditor.getClient().getFramebufferColor(this.myRenderDevice.getPath(), this.myAtomPath.getPath(), this.mySettings);
            }
            case Depth: {
                return this.myEditor.getClient().getFramebufferDepth(this.myRenderDevice.getPath(), this.myAtomPath.getPath());
            }
        }
        return null;
    }

    public static enum BufferType {
        Color,
        Depth;

    }
}

