/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDependencySpec {
    @NotNull
    public String name;
    @Nullable
    public String group;
    @Nullable
    public String version;
    @Nullable
    public String classifier;
    @Nullable
    public String extension;

    @Nullable
    public static ArtifactDependencySpec create(@NotNull String notation) {
        if (notation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notation", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencySpec", "create"));
        }
        List segments = Splitter.on((String)":").trimResults().omitEmptyStrings().splitToList((CharSequence)notation);
        int segmentCount = segments.size();
        if (segmentCount > 0) {
            segments = Lists.newArrayList((Iterable)segments);
            String lastSegment = (String)segments.remove(segmentCount - 1);
            String extension = null;
            int indexOfAt = lastSegment.indexOf(64);
            if (indexOfAt != -1) {
                extension = lastSegment.substring(indexOfAt + 1, lastSegment.length());
                lastSegment = lastSegment.substring(0, indexOfAt);
            }
            segments.add(lastSegment);
            segmentCount = segments.size();
            String group = null;
            String name = null;
            String version = null;
            String classifier = null;
            if (segmentCount == 1) {
                name = (String)segments.get(0);
            } else if (segmentCount == 2) {
                if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                    name = (String)segments.get(0);
                    version = lastSegment;
                } else {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                }
            } else if (segmentCount == 3 || segmentCount == 4) {
                group = (String)segments.get(0);
                name = (String)segments.get(1);
                version = (String)segments.get(2);
                if (segmentCount == 4) {
                    classifier = (String)segments.get(3);
                }
            }
            if (StringUtil.isNotEmpty((String)name)) {
                return new ArtifactDependencySpec(name, group, version, classifier, extension);
            }
        }
        return null;
    }

    public ArtifactDependencySpec(@NotNull String name, @Nullable String group, @Nullable String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencySpec", "<init>"));
        }
        this(name, group, version, null, null);
    }

    public ArtifactDependencySpec(@NotNull String name, @Nullable String group, @Nullable String version, @Nullable String classifier, @Nullable String extension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencySpec", "<init>"));
        }
        this.name = name;
        this.group = Strings.emptyToNull((String)group);
        this.version = Strings.emptyToNull((String)version);
        this.classifier = Strings.emptyToNull((String)classifier);
        this.extension = Strings.emptyToNull((String)extension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactDependencySpec that = (ArtifactDependencySpec)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.classifier, (Object)that.classifier) && Objects.equal((Object)this.extension, (Object)that.extension);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version, this.classifier, this.extension});
    }

    public String toString() {
        return this.compactNotation();
    }

    @NotNull
    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version, this.classifier});
        String s = Joiner.on((char)':').skipNulls().join((Iterable)segments);
        if (this.extension != null) {
            s = s + "@" + this.extension;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencySpec", "compactNotation"));
        }
        return string;
    }
}

