/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntityGroup;
import com.android.tools.idea.gradle.editor.entity.VersionGradleEditorEntity;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParser;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParserV1;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelUtil;
import com.android.tools.idea.gradle.editor.parser.GradleEditorValueExtractor;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleEditorModelParserFacade {
    private static final List<GradleEditorModelParser> ourParsers = Lists.newArrayList((Object[])new GradleEditorModelParser[]{new GradleEditorModelParserV1()});
    private static final Logger LOG = Logger.getInstance(GradleEditorModelParserFacade.class);

    @NotNull
    public List<GradleEditorEntityGroup> parse(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "parse"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "parse"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            LOG.warn(String.format("Can't build PSI for the gradle config file '%s'", virtualFile.getCanonicalPath()));
            List<GradleEditorEntityGroup> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "parse"));
            }
            return list;
        }
        GradleEditorModelParseContext context = new GradleEditorModelParseContext(virtualFile, project);
        GradleEditorModelParserFacade.fillContext(context, psiFile);
        for (VirtualFile dir = virtualFile.getParent(); dir != null; dir = dir.getParent()) {
            File settingsIoFile = new File(dir.getCanonicalPath(), "settings.gradle");
            if (!settingsIoFile.isFile()) continue;
            if (!GradleEditorModelParserFacade.isParentProject(settingsIoFile, virtualFile)) break;
            File parentIoFile = new File(dir.getCanonicalPath(), "build.gradle");
            VirtualFile parentVFile = LocalFileSystem.getInstance().findFileByIoFile(parentIoFile);
            if (parentVFile == null) break;
            parentVFile.refresh(false, false);
            PsiFile parentPsiFile = psiManager.findFile(parentVFile);
            if (parentPsiFile == null) break;
            context.onChangeFile(parentVFile);
            GradleEditorModelParserFacade.fillContext(context, parentPsiFile);
            break;
        }
        List<GradleEditorEntityGroup> list = GradleEditorModelParserFacade.buildEntities(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "parse"));
        }
        return list;
    }

    private static boolean isParentProject(@NotNull File settingsFile, @NotNull VirtualFile targetConfigFile) {
        if (settingsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsFile", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "isParentProject"));
        }
        if (targetConfigFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetConfigFile", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "isParentProject"));
        }
        try {
            ImmutableList lines = Files.asCharSource((File)settingsFile, (Charset)Charset.forName("UTF-8")).readLines();
            String startLineMarker = "include ";
            for (String line : lines) {
                if (!line.startsWith(startLineMarker)) continue;
                ArrayList subProjects = Lists.newArrayList();
                for (String s : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)line.substring(startLineMarker.length()))) {
                    if ((s = GradleEditorModelUtil.unquote(s)).startsWith(":")) {
                        s = s.substring(1);
                    }
                    subProjects.add(s);
                }
                ArrayList dirs = Lists.newArrayList();
                LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                VirtualFile rootDir = fileSystem.refreshAndFindFileByIoFile(settingsFile.getParentFile());
                if (rootDir == null) {
                    return false;
                }
                for (VirtualFile dir = targetConfigFile.getParent(); dir != null && !rootDir.equals(dir); dir = dir.getParent()) {
                    dirs.add(dir.getName());
                }
                Collections.reverse(dirs);
                int i = 0;
                for (String subProject : subProjects) {
                    if (i < dirs.size() && subProject.equals(dirs.get(i++))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception occurred on attempt to read contents of file " + settingsFile.getAbsolutePath());
        }
        return false;
    }

    private static void fillContext(final @NotNull GradleEditorModelParseContext context, @NotNull PsiFile psiFile) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "fillContext"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "fillContext"));
        }
        psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
                Pair<String, TextRange> pair = GradleEditorValueExtractor.extractMethodName((PsiElement)methodCallExpression);
                GrClosableBlock[] closureArguments = methodCallExpression.getClosureArguments();
                if (pair == null || closureArguments.length > 1) {
                    super.visitMethodCallExpression(methodCallExpression);
                    return;
                }
                if (closureArguments.length == 0) {
                    if (methodCallExpression.getArgumentList().getAllArguments().length == 0) {
                        context.addCachedValue("()", TextRange.create((int)((TextRange)pair.second).getEndOffset(), (int)methodCallExpression.getTextRange().getEndOffset()));
                        context.registerAssignmentFromCachedData((String)pair.first, (TextRange)pair.second, (PsiElement)methodCallExpression);
                    }
                    return;
                }
                context.onMethodEnter((String)pair.getFirst());
                try {
                    super.visitClosure(closureArguments[0]);
                }
                finally {
                    context.onMethodExit();
                }
            }

            public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
                Pair<String, TextRange> methodName = GradleEditorValueExtractor.extractMethodName((PsiElement)applicationStatement);
                if (methodName == null) {
                    return;
                }
                GroovyPsiElement[] allArguments = applicationStatement.getArgumentList().getAllArguments();
                if (allArguments.length == 1) {
                    context.resetCaches();
                    GradleEditorModelParserFacade.extractValueOrVariable((PsiElement)allArguments[0], context);
                    context.registerAssignmentFromCachedData((String)methodName.getFirst(), (TextRange)methodName.getSecond(), (PsiElement)applicationStatement.getArgumentList());
                }
            }

            public void visitAssignmentExpression(GrAssignmentExpression expression) {
                context.resetCaches();
                GradleEditorModelParserFacade.extractValueOrVariable((PsiElement)expression.getLValue(), context);
                Multimap<GradleEditorModelParseContext.Variable, GradleEditorModelParseContext.Location> vars = context.getCachedVariables();
                if (vars.size() != 1) {
                    context.resetCaches();
                    return;
                }
                Map.Entry entry = (Map.Entry)vars.entries().iterator().next();
                GradleEditorModelParseContext.Variable lVariable = (GradleEditorModelParseContext.Variable)entry.getKey();
                GradleEditorModelParseContext.Location lVariableLocation = (GradleEditorModelParseContext.Location)entry.getValue();
                context.resetCaches();
                GrExpression rValue = expression.getRValue();
                if (rValue == null) {
                    return;
                }
                GradleEditorModelParserFacade.extractValueOrVariable((PsiElement)rValue, context);
                if (context.getCachedValues().size() > 1) {
                    GradleEditorModelParseContext.Value value = new GradleEditorModelParseContext.Value("", new GradleEditorModelParseContext.Location(context.getCurrentFile(), GradleEditorModelUtil.interestedRange((PsiElement)rValue)));
                    context.setCachedValues(Collections.singletonList(value));
                }
                context.registerAssignmentFromCachedData(lVariable, lVariableLocation, (PsiElement)rValue);
                context.resetCaches();
            }

            public void visitVariable(GrVariable variable) {
                TextRange nameRange = null;
                boolean lookForInitializer = false;
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)GroovyLanguage.INSTANCE);
                for (PsiElement e = variable.getFirstChild(); e != null; e = e.getNextSibling()) {
                    ASTNode node = e.getNode();
                    if (node == null) continue;
                    if (!lookForInitializer) {
                        if (node.getElementType() == GroovyTokenTypes.mIDENT) {
                            nameRange = e.getTextRange();
                            continue;
                        }
                        if (node.getElementType() != GroovyTokenTypes.mASSIGN) continue;
                        if (nameRange == null) {
                            return;
                        }
                        lookForInitializer = true;
                        continue;
                    }
                    if (node.getElementType() == GroovyTokenTypes.mNLS || node.getElementType() == GroovyTokenTypes.mSEMI) break;
                    if (parserDefinition.getWhitespaceTokens().contains(node.getElementType())) continue;
                    GradleEditorModelParserFacade.extractValueOrVariable(e, context);
                    if (context.getCachedValues().size() > 1) {
                        GradleEditorModelParseContext.Value value = new GradleEditorModelParseContext.Value("", new GradleEditorModelParseContext.Location(context.getCurrentFile(), GradleEditorModelUtil.interestedRange(e)));
                        context.setCachedValues(Collections.singletonList(value));
                    }
                    if (!context.registerAssignmentFromCachedData(variable.getName(), nameRange, e)) continue;
                    return;
                }
            }
        }));
    }

    private static void extractValueOrVariable(@NotNull PsiElement element, @NotNull GradleEditorModelParseContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "extractValueOrVariable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "extractValueOrVariable"));
        }
        new GradleEditorValueExtractor(context).extractValueOrVariable(element);
    }

    @NotNull
    private static List<GradleEditorEntityGroup> buildEntities(@NotNull GradleEditorModelParseContext context) {
        String currentVersion;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "buildEntities"));
        }
        VersionGradleEditorEntity entity = GradleEditorModelParserV1.buildGradlePluginVersion(context);
        GradleCoordinate androidGradlePluginVersion = null;
        if (entity != null && !(currentVersion = entity.getCurrentValue()).isEmpty()) {
            androidGradlePluginVersion = GradleCoordinate.parseVersionOnly((String)currentVersion);
        }
        if (androidGradlePluginVersion == null) {
            androidGradlePluginVersion = GradleCoordinate.parseVersionOnly((String)"0");
        }
        Comparator c = GradleCoordinate.COMPARE_PLUS_HIGHER;
        for (GradleEditorModelParser parser : ourParsers) {
            if (c.compare(androidGradlePluginVersion, parser.getMinSupportedAndroidGradlePluginVersion()) < 0 || c.compare(androidGradlePluginVersion, parser.getMaxSupportedAndroidGradlePluginVersion()) >= 0) continue;
            List<GradleEditorEntityGroup> list = parser.buildEntities(context);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "buildEntities"));
            }
            return list;
        }
        List<GradleEditorEntityGroup> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserFacade", "buildEntities"));
        }
        return list;
    }
}

