/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.fd.FileChangeListener;
import com.android.tools.idea.fd.InstantRunGradleUtils;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.run.RunAsValidator;
import com.android.tools.idea.gradle.run.RunAsValidityService;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInvokerOptions {
    @NotNull
    public final List<String> tasks;
    @Nullable
    public final BuildMode buildMode;
    @NotNull
    public final List<String> commandLineArguments;
    private static final String PROPERTY_BUILD_ABI = "android.injected.build.abi";

    private GradleInvokerOptions(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "<init>"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "<init>"));
        }
        this.tasks = tasks;
        this.buildMode = buildMode;
        this.commandLineArguments = commandLineArguments;
    }

    public static GradleInvokerOptions create(@NotNull Project project, @Nullable DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @Nullable String userGoal) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        Module[] modules = GradleInvokerOptions.getModules(project, context, configuration);
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        GradleInvoker.TestCompileType testCompileType = GradleInvokerOptions.getTestCompileType(configuration);
        InstantRunBuildOptions instantRunBuildOptions = null;
        if (configuration instanceof AndroidRunConfigurationBase && ((AndroidRunConfigurationBase)configuration).supportsInstantRun()) {
            instantRunBuildOptions = InstantRunBuildOptions.createAndReset(modules[0], env);
        }
        if (instantRunBuildOptions != null) {
            InstantRunManager.LOG.info(instantRunBuildOptions.toString());
        }
        return GradleInvokerOptions.create(testCompileType, instantRunBuildOptions, new GradleModuleTasksProvider(modules), RunAsValidityService.getInstance(), userGoal);
    }

    static GradleInvokerOptions create(@NotNull GradleInvoker.TestCompileType testCompileType, @Nullable InstantRunBuildOptions instantRunBuildOptions, @NotNull GradleTasksProvider gradleTasksProvider, @NotNull RunAsValidator runAsValidator, @Nullable String userGoal) {
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        if (gradleTasksProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasksProvider", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        if (runAsValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runAsValidator", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "create"));
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            return new GradleInvokerOptions(Collections.singletonList(userGoal), null, Collections.emptyList());
        }
        if (testCompileType == GradleInvoker.TestCompileType.JAVA_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            return new GradleInvokerOptions(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode, Collections.emptyList());
        }
        ArrayList cmdLineArgs = Lists.newArrayList();
        ArrayList tasks = Lists.newArrayList();
        if (testCompileType == GradleInvoker.TestCompileType.NONE && instantRunBuildOptions != null) {
            boolean incrementalBuild = GradleInvokerOptions.canBuildIncrementally(instantRunBuildOptions, runAsValidator);
            cmdLineArgs.add(GradleInvokerOptions.getInstantDevProperty(instantRunBuildOptions, incrementalBuild));
            cmdLineArgs.addAll(GradleInvokerOptions.getDeviceSpecificArguments(instantRunBuildOptions.devices));
            if (instantRunBuildOptions.coldSwapEnabled) {
                cmdLineArgs.add("-Pandroid.injected.coldswap.mode=" + instantRunBuildOptions.coldSwapMode.value);
            }
            if (instantRunBuildOptions.cleanBuild) {
                tasks.addAll(gradleTasksProvider.getCleanAndGenerateSourcesTasks());
            } else if (incrementalBuild) {
                return new GradleInvokerOptions(gradleTasksProvider.getIncrementalDexTasks(), null, cmdLineArgs);
            }
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        tasks.addAll(gradleTasksProvider.getTasksFor(buildMode, testCompileType));
        return new GradleInvokerOptions(tasks, buildMode, cmdLineArgs);
    }

    private static boolean canBuildIncrementally(@NotNull InstantRunBuildOptions options, @NotNull RunAsValidator runAsValidator) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "canBuildIncrementally"));
        }
        if (runAsValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runAsValidator", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "canBuildIncrementally"));
        }
        if (options.cleanBuild || options.needsFullBuild) {
            return false;
        }
        if (!options.isAppRunning) {
            if (!options.coldSwapEnabled) {
                return false;
            }
            AndroidDevice device = options.devices.get(0);
            AndroidVersion version = device.getVersion();
            if (!version.isGreaterOrEqualThan(21)) {
                return false;
            }
            if (!runAsValidator.hasWorkingRunAs(device)) {
                return false;
            }
        }
        return !options.usesMultipleProcesses || options.coldSwapEnabled;
    }

    @NotNull
    private static String getInstantDevProperty(@NotNull InstantRunBuildOptions buildOptions, boolean incrementalBuild) {
        if (buildOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildOptions", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getInstantDevProperty"));
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append("-Pandroid.optional.compilation=INSTANT_DEV");
        if (GradleInvokerOptions.needsRestartOnly(incrementalBuild, buildOptions)) {
            sb.append(",RESTART_ONLY");
        }
        FileChangeListener.Changes changes = buildOptions.fileChanges;
        if (incrementalBuild && !changes.nonSourceChanges) {
            if (changes.localResourceChanges) {
                sb.append(",LOCAL_RES_ONLY");
            }
            if (changes.localJavaChanges) {
                sb.append(",LOCAL_JAVA_ONLY");
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getInstantDevProperty"));
        }
        return string;
    }

    private static boolean needsRestartOnly(boolean incrementalBuild, InstantRunBuildOptions buildOptions) {
        if (!incrementalBuild) {
            return true;
        }
        if (buildOptions.usesMultipleProcesses || !buildOptions.isAppRunning) {
            return buildOptions.coldSwapEnabled;
        }
        return false;
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project, @Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getModules"));
        }
        if (configuration instanceof ModuleRunProfile) {
            Module[] moduleArray = ((ModuleRunProfile)configuration).getModules();
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getModules"));
            }
            return moduleArray;
        }
        Module[] moduleArray = Projects.getModulesToBuildFromSelection(project, context);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    private static Module[] getAffectedModules(@NotNull Project project, @NotNull Module[] modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getAffectedModules"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getAffectedModules"));
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = compilerManager.createModulesCompileScope(modules, true, true);
        Module[] moduleArray = scope.getAffectedModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getAffectedModules"));
        }
        return moduleArray;
    }

    @NotNull
    private static GradleInvoker.TestCompileType getTestCompileType(@Nullable RunConfiguration runConfiguration) {
        String id = runConfiguration != null ? runConfiguration.getType().getId() : null;
        GradleInvoker.TestCompileType testCompileType = GradleInvoker.getTestCompileType(id);
        if (testCompileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getTestCompileType"));
        }
        return testCompileType;
    }

    @NotNull
    private static List<String> getDeviceSpecificArguments(@NotNull List<AndroidDevice> devices) {
        String abis;
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getDeviceSpecificArguments"));
        }
        if (devices.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getDeviceSpecificArguments"));
            }
            return list;
        }
        ArrayList<String> properties = new ArrayList<String>(2);
        AndroidDevice device = devices.get(0);
        AndroidVersion version = device.getVersion();
        properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(version.getFeatureLevel())));
        Density density = Density.getEnum((int)device.getDensity());
        if (density != null) {
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)density.getResourceValue()));
        }
        if (!(abis = GradleInvokerOptions.join(device.getAbis())).isEmpty()) {
            properties.add(AndroidGradleSettings.createProjectProperty((String)PROPERTY_BUILD_ABI, (String)abis));
        }
        ArrayList<String> arrayList = properties;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getDeviceSpecificArguments"));
        }
        return arrayList;
    }

    @NotNull
    private static String join(@NotNull List<Abi> abis) {
        if (abis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abis", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "join"));
        }
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (Abi abi : abis) {
            sb.append(separator);
            sb.append(abi.toString());
            separator = ",";
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "join"));
        }
        return string;
    }

    @NotNull
    private static List<AndroidDevice> getTargetDevices(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getTargetDevices"));
        }
        DeviceFutures deviceFutures = (DeviceFutures)env.getCopyableUserData(AndroidRunConfigurationBase.DEVICE_FUTURES_KEY);
        List<Object> list = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions", "getTargetDevices"));
        }
        return list;
    }

    static class GradleModuleTasksProvider
    implements GradleTasksProvider {
        private final Module[] myModules;

        GradleModuleTasksProvider(@NotNull Module[] modules) {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "<init>"));
            }
            this.myModules = modules;
            if (this.myModules.length == 0) {
                throw new IllegalArgumentException("No modules provided");
            }
        }

        @Override
        @NotNull
        public List<String> getCleanAndGenerateSourcesTasks() {
            ArrayList tasks = Lists.newArrayList();
            tasks.addAll(GradleInvoker.findCleanTasksForModules(this.myModules));
            tasks.addAll(GradleInvoker.findTasksToExecute(this.myModules, BuildMode.SOURCE_GEN, GradleInvoker.TestCompileType.NONE));
            ArrayList arrayList = tasks;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "getCleanAndGenerateSourcesTasks"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public List<String> getUnitTestTasks(@NotNull BuildMode buildMode) {
            if (buildMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "getUnitTestTasks"));
            }
            Module[] affectedModules = GradleInvokerOptions.getAffectedModules(this.myModules[0].getProject(), this.myModules);
            List<String> list = GradleInvoker.findTasksToExecute(affectedModules, buildMode, GradleInvoker.TestCompileType.JAVA_TESTS);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "getUnitTestTasks"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getIncrementalDexTasks() {
            Module module = this.myModules[0];
            AndroidGradleModel model = AndroidGradleModel.get(module);
            if (model == null) {
                throw new IllegalStateException("Attempted to obtain incremental dex task for module that does not have a Gradle facet");
            }
            List<String> list = Collections.singletonList(InstantRunGradleUtils.getIncrementalDexTask(model, module));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "getIncrementalDexTasks"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getTasksFor(@NotNull BuildMode buildMode, @NotNull GradleInvoker.TestCompileType testCompileType) {
            if (buildMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "getTasksFor"));
            }
            if (testCompileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "getTasksFor"));
            }
            List<String> list = GradleInvoker.findTasksToExecute(this.myModules, buildMode, testCompileType);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/run/GradleInvokerOptions$GradleModuleTasksProvider", "getTasksFor"));
            }
            return list;
        }
    }

    static interface GradleTasksProvider {
        @NotNull
        public List<String> getCleanAndGenerateSourcesTasks();

        @NotNull
        public List<String> getUnitTestTasks(@NotNull BuildMode var1);

        @NotNull
        public List<String> getIncrementalDexTasks();

        @NotNull
        public List<String> getTasksFor(@NotNull BuildMode var1, @NotNull GradleInvoker.TestCompileType var2);
    }

    static class InstantRunBuildOptions {
        public final boolean cleanBuild;
        public final boolean needsFullBuild;
        public final boolean isAppRunning;
        public final boolean usesMultipleProcesses;
        public final boolean coldSwapEnabled;
        public final InstantRunSettings.ColdSwapMode coldSwapMode;
        @NotNull
        private final FileChangeListener.Changes fileChanges;
        @NotNull
        public final List<AndroidDevice> devices;

        InstantRunBuildOptions(boolean cleanBuild, boolean needsFullBuild, boolean isAppRunning, boolean usesMultipleProcesses, boolean coldSwapEnabled, @NotNull InstantRunSettings.ColdSwapMode coldSwapMode, @NotNull FileChangeListener.Changes changes, @NotNull List<AndroidDevice> devices) {
            if (coldSwapMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coldSwapMode", "com/android/tools/idea/gradle/run/GradleInvokerOptions$InstantRunBuildOptions", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/run/GradleInvokerOptions$InstantRunBuildOptions", "<init>"));
            }
            if (devices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/gradle/run/GradleInvokerOptions$InstantRunBuildOptions", "<init>"));
            }
            this.cleanBuild = cleanBuild;
            this.needsFullBuild = needsFullBuild;
            this.isAppRunning = isAppRunning;
            this.usesMultipleProcesses = usesMultipleProcesses;
            this.coldSwapEnabled = coldSwapEnabled;
            this.coldSwapMode = coldSwapMode;
            this.fileChanges = changes;
            this.devices = devices;
        }

        @Nullable
        static InstantRunBuildOptions createAndReset(@NotNull Module module, @NotNull ExecutionEnvironment env) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/run/GradleInvokerOptions$InstantRunBuildOptions", "createAndReset"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/gradle/run/GradleInvokerOptions$InstantRunBuildOptions", "createAndReset"));
            }
            if (!InstantRunUtils.isInstantRunEnabled(env) || !InstantRunSettings.isInstantRunEnabled()) {
                return null;
            }
            List targetDevices = GradleInvokerOptions.getTargetDevices(env);
            if (targetDevices.size() != 1 || !InstantRunGradleUtils.getIrSupportStatus((Module)module, (AndroidVersion)((AndroidDevice)targetDevices.get((int)0)).getVersion()).success) {
                return null;
            }
            Project project = module.getProject();
            FileChangeListener.Changes changes = InstantRunManager.get(project).getChangesAndReset();
            return new InstantRunBuildOptions(InstantRunUtils.needsCleanBuild(env), InstantRunUtils.needsFullBuild(env), InstantRunUtils.isAppRunning(env), InstantRunManager.usesMultipleProcesses(module), InstantRunSettings.isColdSwapEnabled(), InstantRunSettings.getColdSwapMode(), changes, targetDevices);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("cleanBuild", this.cleanBuild).add("needsFullBuild", this.needsFullBuild).add("isAppRunning", this.isAppRunning).add("multiProcess", this.usesMultipleProcesses).add("coldSwapEnabled", this.coldSwapEnabled).add("coldSwapMode", (Object)this.coldSwapMode.display).add("javaFileChange", this.fileChanges.localJavaChanges).add("resFileChange", this.fileChanges.localResourceChanges).add("nonSrcFileChange", this.fileChanges.nonSourceChanges).toString();
        }
    }
}

