/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.ide.common.util.AssetUtil;
import com.android.tools.idea.npw.assetstudio.AssetStudioAssetGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.google.common.collect.ImmutableList;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ClipartAsset
extends BaseAsset {
    private static final String PREFERRED_CLIPART = "android.png";
    private final StringProperty myClipartName = new StringValueProperty();

    public ClipartAsset() {
        List<String> clipartNames = ClipartAsset.getAllClipartNames();
        assert (clipartNames.size() > 0);
        if (clipartNames.contains(PREFERRED_CLIPART)) {
            this.myClipartName.set(PREFERRED_CLIPART);
        } else {
            this.myClipartName.set(clipartNames.get(0));
        }
    }

    @NotNull
    public static List<String> getAllClipartNames() {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        listBuilder.addAll(GraphicGenerator.getResourcesNames((String)"images/clipart/big/", (String)".png"));
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "getAllClipartNames"));
        }
        return immutableList;
    }

    @NotNull
    public static Icon createIcon(@NotNull String clipartName) throws IOException {
        if (clipartName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clipartName", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createIcon"));
        }
        JBImageIcon jBImageIcon = IconUtil.createImageIcon((BufferedImage)GraphicGenerator.getClipartIcon((String)clipartName));
        if (jBImageIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createIcon"));
        }
        return jBImageIcon;
    }

    @NotNull
    public static BufferedImage createImage(@NotNull String clipartName) throws IOException {
        if (clipartName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clipartName", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createImage"));
        }
        BufferedImage bufferedImage = GraphicGenerator.getClipartImage((String)clipartName);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createImage"));
        }
        return bufferedImage;
    }

    @NotNull
    public StringProperty clipartName() {
        StringProperty stringProperty = this.myClipartName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "clipartName"));
        }
        return stringProperty;
    }

    @NotNull
    public Icon createIcon() throws IOException {
        Icon icon = ClipartAsset.createIcon((String)this.myClipartName.get());
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createIcon"));
        }
        return icon;
    }

    @NotNull
    public BufferedImage createImage() throws IOException {
        BufferedImage bufferedImage = ClipartAsset.createImage((String)this.myClipartName.get());
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createImage"));
        }
        return bufferedImage;
    }

    @Override
    @NotNull
    protected BufferedImage createAsImage(@NotNull Color color) {
        BufferedImage bufferedImage;
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createAsImage"));
        }
        try {
            BufferedImage image = this.createImage();
            bufferedImage = AssetUtil.filledImage((BufferedImage)image, (Paint)color);
        }
        catch (IOException e) {
            BufferedImage bufferedImage2 = AssetStudioAssetGenerator.createDummyImage();
            if (bufferedImage2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createAsImage"));
            }
            return bufferedImage2;
        }
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ClipartAsset", "createAsImage"));
        }
        return bufferedImage;
    }
}

