/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import org.jetbrains.annotations.NotNull;

public final class Actions {
    private Actions() {
    }

    public static void hideAction(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/android/tools/idea/startup/Actions", "hideAction"));
        }
        AnAction oldAction = ActionManager.getInstance().getAction(actionId);
        if (oldAction != null) {
            Actions.replaceAction(actionId, (AnAction)new EmptyAction());
        }
    }

    public static void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/android/tools/idea/startup/Actions", "replaceAction"));
        }
        if (newAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAction", "com/android/tools/idea/startup/Actions", "replaceAction"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction oldAction = actionManager.getAction(actionId);
        if (oldAction != null) {
            newAction.getTemplatePresentation().setIcon(oldAction.getTemplatePresentation().getIcon());
            actionManager.unregisterAction(actionId);
        }
        actionManager.registerAction(actionId, newAction);
    }

    public static void moveAction(@NotNull String actionId, @NotNull String oldGroupId, @NotNull String groupId, @NotNull Constraints constraints) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/android/tools/idea/startup/Actions", "moveAction"));
        }
        if (oldGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldGroupId", "com/android/tools/idea/startup/Actions", "moveAction"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/startup/Actions", "moveAction"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/android/tools/idea/startup/Actions", "moveAction"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId);
        AnAction group = actionManager.getAction(groupId);
        AnAction oldGroup = actionManager.getAction(oldGroupId);
        if (action != null && oldGroup != null && group != null && oldGroup instanceof DefaultActionGroup && group instanceof DefaultActionGroup) {
            ((DefaultActionGroup)oldGroup).getChildren(null);
            ((DefaultActionGroup)oldGroup).remove(action);
            ((DefaultActionGroup)group).add(action, constraints);
        }
    }
}

