/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.refactoring.UnusedResourcesHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedResourcesQuickFix
implements AndroidLintQuickFix {
    private final String myResource;

    public UnusedResourcesQuickFix(@Nullable String resource) {
        this.myResource = resource;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/refactoring/UnusedResourcesQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/refactoring/UnusedResourcesQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/refactoring/UnusedResourcesQuickFix", "apply"));
        }
        Project project = startElement.getProject();
        UnusedResourcesHandler.invoke(project, null, this.myResource, true, true);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/refactoring/UnusedResourcesQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/refactoring/UnusedResourcesQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/refactoring/UnusedResourcesQuickFix", "isApplicable"));
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myResource != null ? "Remove Declarations for " + this.myResource : "Remove All Unused Resources";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/UnusedResourcesQuickFix", "getName"));
        }
        return string;
    }
}

