/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.archetype.source.ArchetypeDataSink;
import org.apache.maven.archetype.source.ArchetypeDataSinkException;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

public class CatalogArchetypeDataSink
extends AbstractLogEnabled
implements ArchetypeDataSink {
    private ArchetypeCatalogXpp3Writer catalogWriter = new ArchetypeCatalogXpp3Writer();

    public void putArchetypes(List archetypes, Writer writer) throws ArchetypeDataSinkException {
        ArchetypeCatalog catalog = new ArchetypeCatalog();
        Iterator i = archetypes.iterator();
        while (i.hasNext()) {
            Archetype archetype = (Archetype)i.next();
            catalog.addArchetype(archetype);
        }
        try {
            this.catalogWriter.write(writer, catalog);
        }
        catch (IOException e) {
            throw new ArchetypeDataSinkException("Error writing archetype catalog.", e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    public void putArchetypes(ArchetypeDataSource source, Properties properties, Writer writer) throws ArchetypeDataSourceException, ArchetypeDataSinkException {
        List archetypes = source.getArchetypeCatalog(properties).getArchetypes();
        this.putArchetypes(archetypes, writer);
    }
}

