/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.T3i;
import javajs.util.V3;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class VolumeData {
    public SurfaceReader sr;
    public boolean doIterate = true;
    public final P3 volumetricOrigin = new P3();
    public final float[] origin = new float[3];
    public final V3[] volumetricVectors = new V3[3];
    public final int[] voxelCounts = new int[3];
    public int nPoints;
    private float[][][] voxelData;
    private Map<Integer, Float> voxelMap;
    public final float[] volumetricVectorLengths = new float[3];
    private float maxVectorLength;
    private float minToPlaneDistance;
    private int yzCount;
    public final V3[] unitVolumetricVectors = new V3[3];
    private final M3 volumetricMatrix = new M3();
    private final M3 inverseMatrix = new M3();
    private P4 thePlane;
    private float thePlaneNormalMag;
    private final P3 ptXyzTemp = new P3();
    public String xmlData;
    public P4 mappingPlane;
    float mappingPlaneNormalMag;
    public float minGrid;
    public float maxGrid;
    public float voxelVolume;
    public V3[] spanningVectors;
    public boolean isPeriodic;
    private boolean isSquared;
    private final V3 edgeVector = new V3();
    private P3 ptTemp = new P3();

    public float[][][] getVoxelData() {
        return this.voxelData;
    }

    public void setVoxelDataAsArray(float[][][] voxelData) {
        this.voxelData = voxelData;
        if (voxelData != null) {
            this.sr = null;
        }
    }

    public boolean hasPlane() {
        return this.thePlane != null;
    }

    public VolumeData() {
        this.volumetricVectors[0] = new V3();
        this.volumetricVectors[1] = new V3();
        this.volumetricVectors[2] = new V3();
        this.unitVolumetricVectors[0] = new V3();
        this.unitVolumetricVectors[1] = new V3();
        this.unitVolumetricVectors[2] = new V3();
    }

    public void setMappingPlane(P4 plane) {
        this.mappingPlane = plane;
        if (plane == null) {
            return;
        }
        this.mappingPlaneNormalMag = (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
    }

    public float distanceToMappingPlane(T3 pt) {
        return (this.mappingPlane.x * pt.x + this.mappingPlane.y * pt.y + this.mappingPlane.z * pt.z + this.mappingPlane.w) / this.mappingPlaneNormalMag;
    }

    public void setVolumetricOrigin(float x, float y, float z) {
        this.volumetricOrigin.set(x, y, z);
    }

    public float[] getOriginFloat() {
        return this.origin;
    }

    public int getYzCount() {
        this.minGrid = this.volumetricVectors[0].length();
        this.minGrid = Math.min(this.minGrid, this.volumetricVectors[1].length());
        this.minGrid = Math.min(this.minGrid, this.volumetricVectors[2].length());
        this.maxGrid = this.volumetricVectors[0].length();
        this.maxGrid = Math.max(this.maxGrid, this.volumetricVectors[1].length());
        this.maxGrid = Math.max(this.maxGrid, this.volumetricVectors[2].length());
        this.nPoints = this.voxelCounts[0] * this.voxelCounts[1] * this.voxelCounts[2];
        this.yzCount = this.voxelCounts[1] * this.voxelCounts[2];
        return this.yzCount;
    }

    public float[] getVolumetricVectorLengths() {
        return this.volumetricVectorLengths;
    }

    public void setVolumetricVector(int i, float x, float y, float z) {
        this.volumetricVectors[i].x = x;
        this.volumetricVectors[i].y = y;
        this.volumetricVectors[i].z = z;
        this.setUnitVectors();
    }

    public int[] getVoxelCounts() {
        return this.voxelCounts;
    }

    public int setVoxelCounts(int nPointsX, int nPointsY, int nPointsZ) {
        this.voxelCounts[0] = nPointsX;
        this.voxelCounts[1] = nPointsY;
        this.voxelCounts[2] = nPointsZ;
        return nPointsX * nPointsY * nPointsZ;
    }

    public float getVoxelDataAt(int pt) {
        int ix = pt / this.yzCount;
        int iy = (pt -= ix * this.yzCount) / this.voxelCounts[2];
        int iz = pt - iy * this.voxelCounts[2];
        return this.voxelData[ix][iy][iz];
    }

    public int getPointIndex(int x, int y, int z) {
        return x * this.yzCount + y * this.voxelCounts[2] + z;
    }

    public void getPoint(int ipt, P3 pt) {
        int ix = ipt / this.yzCount;
        int iy = (ipt -= ix * this.yzCount) / this.voxelCounts[2];
        int iz = ipt - iy * this.voxelCounts[2];
        this.voxelPtToXYZ(ix, iy, iz, pt);
    }

    public void setVoxelData(int pt, float value) {
        int ix = pt / this.yzCount;
        int iy = (pt -= ix * this.yzCount) / this.voxelCounts[2];
        int iz = pt - iy * this.voxelCounts[2];
        this.voxelData[ix][iy][iz] = value;
    }

    public void setVoxelMap() {
        this.voxelMap = new Hashtable<Integer, Float>();
        this.getYzCount();
    }

    private boolean setMatrix() {
        for (int i = 0; i < 3; ++i) {
            this.volumetricMatrix.setColumnV(i, this.volumetricVectors[i]);
        }
        try {
            this.inverseMatrix.invertM(this.volumetricMatrix);
        }
        catch (Exception e) {
            Logger.error("VolumeData error setting matrix -- bad unit vectors? ");
            return false;
        }
        return true;
    }

    public void transform(V3 v1, V3 v2) {
        this.volumetricMatrix.rotate2(v1, v2);
    }

    public void setPlaneParameters(P4 plane) {
        this.thePlane = plane;
        this.thePlaneNormalMag = (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
    }

    public float calcVoxelPlaneDistance(int x, int y, int z) {
        this.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
        return this.distancePointToPlane(this.ptXyzTemp);
    }

    public float getToPlaneParameter() {
        return (float)(Math.sqrt(this.thePlane.x * this.thePlane.x + this.thePlane.y * this.thePlane.y + this.thePlane.z * this.thePlane.z) * (double)this.minToPlaneDistance);
    }

    public boolean isNearPlane(int x, int y, int z, float toPlaneParameter) {
        this.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
        return this.thePlane.x * this.ptXyzTemp.x + this.thePlane.y * this.ptXyzTemp.y + this.thePlane.z * this.ptXyzTemp.z + this.thePlane.w < toPlaneParameter;
    }

    public float distancePointToPlane(T3 pt) {
        return (this.thePlane.x * pt.x + this.thePlane.y * pt.y + this.thePlane.z * pt.z + this.thePlane.w) / this.thePlaneNormalMag;
    }

    public void voxelPtToXYZ(int x, int y, int z, T3 pt) {
        pt.scaleAdd2(x, this.volumetricVectors[0], this.volumetricOrigin);
        pt.scaleAdd2(y, this.volumetricVectors[1], pt);
        pt.scaleAdd2(z, this.volumetricVectors[2], pt);
    }

    public boolean setUnitVectors() {
        int i;
        this.maxVectorLength = 0.0f;
        this.voxelVolume = 1.0f;
        for (i = 0; i < 3; ++i) {
            this.volumetricVectorLengths[i] = this.volumetricVectors[i].length();
            float d = this.volumetricVectorLengths[i];
            if (d == 0.0f) {
                return false;
            }
            if (d > this.maxVectorLength) {
                this.maxVectorLength = d;
            }
            this.voxelVolume *= d;
            this.unitVolumetricVectors[i].setT(this.volumetricVectors[i]);
            this.unitVolumetricVectors[i].normalize();
        }
        this.minToPlaneDistance = this.maxVectorLength * 2.0f;
        this.origin[0] = this.volumetricOrigin.x;
        this.origin[1] = this.volumetricOrigin.y;
        this.origin[2] = this.volumetricOrigin.z;
        this.spanningVectors = new V3[4];
        this.spanningVectors[0] = V3.newV(this.volumetricOrigin);
        for (i = 0; i < 3; ++i) {
            V3 v3 = new V3();
            this.spanningVectors[i + 1] = v3;
            V3 v = v3;
            v.scaleAdd2(this.voxelCounts[i] - 1, this.volumetricVectors[i], v);
        }
        return this.setMatrix();
    }

    public void xyzToVoxelPt(float x, float y, float z, T3i pt3i) {
        this.ptXyzTemp.set(x, y, z);
        this.ptXyzTemp.sub(this.volumetricOrigin);
        this.inverseMatrix.rotate(this.ptXyzTemp);
        pt3i.set(Math.round(this.ptXyzTemp.x), Math.round(this.ptXyzTemp.y), Math.round(this.ptXyzTemp.z));
    }

    public float lookupInterpolatedVoxelValue(T3 point, boolean getSource) {
        if (this.mappingPlane != null) {
            return this.distanceToMappingPlane(point);
        }
        if (this.sr != null) {
            float v = this.sr.getValueAtPoint(point, getSource);
            return this.isSquared ? v * v : v;
        }
        this.ptXyzTemp.sub2(point, this.volumetricOrigin);
        this.inverseMatrix.rotate(this.ptXyzTemp);
        int iMax = this.voxelCounts[0] - 1;
        int xLower = this.indexLower(this.ptXyzTemp.x, iMax);
        int xUpper = this.indexUpper(this.ptXyzTemp.x, xLower, iMax);
        iMax = this.voxelCounts[1] - 1;
        int yLower = this.indexLower(this.ptXyzTemp.y, iMax);
        int yUpper = this.indexUpper(this.ptXyzTemp.y, yLower, iMax);
        iMax = this.voxelCounts[2] - 1;
        int zLower = this.indexLower(this.ptXyzTemp.z, iMax);
        int zUpper = this.indexUpper(this.ptXyzTemp.z, zLower, iMax);
        float v1 = VolumeData.getFractional2DValue(this.mantissa(this.ptXyzTemp.x - (float)xLower), this.mantissa(this.ptXyzTemp.y - (float)yLower), this.getVoxelValue(xLower, yLower, zLower), this.getVoxelValue(xUpper, yLower, zLower), this.getVoxelValue(xLower, yUpper, zLower), this.getVoxelValue(xUpper, yUpper, zLower));
        float v2 = VolumeData.getFractional2DValue(this.mantissa(this.ptXyzTemp.x - (float)xLower), this.mantissa(this.ptXyzTemp.y - (float)yLower), this.getVoxelValue(xLower, yLower, zUpper), this.getVoxelValue(xUpper, yLower, zUpper), this.getVoxelValue(xLower, yUpper, zUpper), this.getVoxelValue(xUpper, yUpper, zUpper));
        return v1 + this.mantissa(this.ptXyzTemp.z - (float)zLower) * (v2 - v1);
    }

    private float mantissa(float f) {
        return this.isPeriodic ? f - (float)Math.floor(f) : f;
    }

    public float getVoxelValue(int x, int y, int z) {
        if (this.voxelMap == null) {
            return this.voxelData[x][y][z];
        }
        Float f = this.voxelMap.get(this.getPointIndex(x, y, z));
        return f == null ? Float.NaN : f.floatValue();
    }

    public static float getFractional2DValue(float fx, float fy, float x11, float x12, float x21, float x22) {
        float v1 = x11 + fx * (x12 - x11);
        float v2 = x21 + fx * (x22 - x21);
        return v1 + fy * (v2 - v1);
    }

    private int indexLower(float x, int xMax) {
        if (this.isPeriodic && xMax > 0) {
            while (x < 0.0f) {
                x += (float)xMax;
            }
            while (x >= (float)xMax) {
                x -= (float)xMax;
            }
            return (int)Math.floor(x);
        }
        if (x < 0.0f) {
            return 0;
        }
        int floor = (int)Math.floor(x);
        return floor > xMax ? xMax : floor;
    }

    private int indexUpper(float x, int xLower, int xMax) {
        return !this.isPeriodic && x < 0.0f || xLower == xMax ? xLower : xLower + 1;
    }

    void offsetCenter(P3 center) {
        P3 pt = new P3();
        pt.scaleAdd2((float)(this.voxelCounts[0] - 1) / 2.0f, this.volumetricVectors[0], pt);
        pt.scaleAdd2((float)(this.voxelCounts[1] - 1) / 2.0f, this.volumetricVectors[1], pt);
        pt.scaleAdd2((float)(this.voxelCounts[2] - 1) / 2.0f, this.volumetricVectors[2], pt);
        this.volumetricOrigin.sub2(center, pt);
    }

    public void setDataDistanceToPlane(P4 plane) {
        this.setPlaneParameters(plane);
        int nx = this.voxelCounts[0];
        int ny = this.voxelCounts[1];
        int nz = this.voxelCounts[2];
        this.voxelData = new float[nx][ny][nz];
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                for (int z = 0; z < nz; ++z) {
                    this.voxelData[x][y][z] = this.calcVoxelPlaneDistance(x, y, z);
                }
            }
        }
    }

    public void filterData(boolean isSquared, float invertCutoff) {
        int z;
        int y;
        int x;
        boolean doInvert;
        boolean bl = doInvert = !Float.isNaN(invertCutoff);
        if (this.sr != null) {
            this.isSquared = isSquared;
            return;
        }
        int nx = this.voxelCounts[0];
        int ny = this.voxelCounts[1];
        int nz = this.voxelCounts[2];
        if (isSquared) {
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    for (z = 0; z < nz; ++z) {
                        float[] fArray = this.voxelData[x][y];
                        int n = z;
                        fArray[n] = fArray[n] * this.voxelData[x][y][z];
                    }
                }
            }
        }
        if (doInvert) {
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    for (z = 0; z < nz; ++z) {
                        this.voxelData[x][y][z] = invertCutoff - this.voxelData[x][y][z];
                    }
                }
            }
        }
    }

    public void capData(P4 plane, float cutoff) {
        if (this.voxelData == null) {
            return;
        }
        int nx = this.voxelCounts[0];
        int ny = this.voxelCounts[1];
        int nz = this.voxelCounts[2];
        V3 normal = V3.new3(plane.x, plane.y, plane.z);
        normal.normalize();
        float f = 1.0f;
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                for (int z = 0; z < nz; ++z) {
                    float value = this.voxelData[x][y][z] - cutoff;
                    this.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
                    float d = (this.ptXyzTemp.x * normal.x + this.ptXyzTemp.y * normal.y + this.ptXyzTemp.z * normal.z + plane.w - cutoff) / f;
                    if (!(d >= 0.0f) && !(d > value)) continue;
                    this.voxelData[x][y][z] = d;
                }
            }
        }
    }

    public String setVolumetricXml() {
        SB sb = new SB();
        if (this.voxelCounts[0] == 0) {
            sb.append("<jvxlVolumeData>\n");
        } else {
            sb.append("<jvxlVolumeData origin=\"" + Escape.eP(this.volumetricOrigin) + "\">\n");
            for (int i = 0; i < 3; ++i) {
                sb.append("<jvxlVolumeVector type=\"" + i + "\" count=\"" + this.voxelCounts[i] + "\" vector=\"" + Escape.eP(this.volumetricVectors[i]) + "\"></jvxlVolumeVector>\n");
            }
        }
        sb.append("</jvxlVolumeData>\n");
        this.xmlData = sb.toString();
        return this.xmlData;
    }

    public void setVoxelMapValue(int x, int y, int z, float v) {
        if (this.voxelMap == null) {
            return;
        }
        this.voxelMap.put(this.getPointIndex(x, y, z), Float.valueOf(v));
    }

    public float calculateFractionalPoint(float cutoff, P3 pointA, P3 pointB, float valueA, float valueB, P3 pt) {
        float diff;
        float fnew;
        float d = valueB - valueA;
        float fraction = (cutoff - valueA) / d;
        this.edgeVector.sub2(pointB, pointA);
        pt.scaleAdd2(fraction, this.edgeVector, pointA);
        if (this.sr == null || !this.doIterate || valueB == valueA || fraction < 0.01f || fraction > 0.99f || this.edgeVector.length() < 0.01f) {
            return cutoff;
        }
        int n = 0;
        this.ptTemp.setT(pt);
        float v = this.lookupInterpolatedVoxelValue(this.ptTemp, false);
        float v0 = Float.NaN;
        while (!(++n >= 10 || (fnew = (v - valueA) / d) < 0.0f || fnew > 1.0f || (fraction += (diff = (cutoff - v) / d / 2.0f)) < 0.0f || fraction > 1.0f)) {
            pt.setT(this.ptTemp);
            v0 = v;
            if (Math.abs(diff) < 0.005f) break;
            this.ptTemp.scaleAdd2(diff, this.edgeVector, pt);
            v = this.lookupInterpolatedVoxelValue(this.ptTemp, false);
        }
        return v0;
    }
}

