/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.security.policyeditor.PermissionActions;
import net.sourceforge.jnlp.security.policyeditor.PermissionTarget;
import net.sourceforge.jnlp.security.policyeditor.PermissionType;

public class CustomPermission
implements Comparable<CustomPermission> {
    public static final Pattern ACTIONS_PERMISSION = Pattern.compile("\\s*permission\\s+([\\w\\.]+)\\s+\"([^\"]+)\",\\s*\"([^\"]*)\";.*");
    public static final Pattern TARGET_PERMISSION = Pattern.compile("\\s*permission\\s+([\\w\\.]+)\\s+\"([^\"]+)\";.*");
    public final String type;
    public final String target;
    public final String actions;

    public CustomPermission(String type, String target) {
        this(type, target, "");
    }

    public CustomPermission(String type, String target, String actions) {
        this.type = type;
        this.target = target;
        this.actions = actions;
    }

    public CustomPermission(PermissionType type, PermissionTarget target) {
        this(type, target, PermissionActions.NONE);
    }

    public CustomPermission(PermissionType type, PermissionTarget target, PermissionActions actions) {
        this(type.type, target.target, actions.rawString());
    }

    public static CustomPermission fromString(String string) {
        String actionsStr;
        String targetStr;
        String typeStr;
        Matcher actionMatcher = ACTIONS_PERMISSION.matcher(string);
        if (actionMatcher.matches()) {
            typeStr = actionMatcher.group(1);
            targetStr = actionMatcher.group(2);
            actionsStr = actionMatcher.group(3);
        } else {
            Matcher targetMatcher = TARGET_PERMISSION.matcher(string);
            if (!targetMatcher.matches()) {
                return null;
            }
            typeStr = targetMatcher.group(1);
            targetStr = targetMatcher.group(2);
            actionsStr = "";
        }
        return new CustomPermission(typeStr, targetStr, actionsStr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("permission ");
        sb.append(this.type);
        sb.append(" \"");
        sb.append(this.target);
        sb.append("\"");
        if (!this.actions.equals(PermissionActions.NONE.rawString())) {
            sb.append(", \"");
            sb.append(this.actions);
            sb.append("\"");
        }
        sb.append(";");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomPermission)) {
            return false;
        }
        CustomPermission that = (CustomPermission)o;
        if (!this.actions.equals(that.actions)) {
            return false;
        }
        if (!this.target.equals(that.target)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.actions.hashCode();
        return result;
    }

    @Override
    public int compareTo(CustomPermission o) {
        if (this == o) {
            return 0;
        }
        int typeComparison = this.type.compareTo(o.type);
        if (typeComparison != 0) {
            return typeComparison;
        }
        int targetComparison = this.target.compareTo(o.target);
        if (targetComparison != 0) {
            return targetComparison;
        }
        int actionsComparison = this.actions.compareTo(o.actions);
        if (actionsComparison != 0) {
            return actionsComparison;
        }
        return 0;
    }
}

