/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.io.IOException;
import org.apache.commons.jcs.access.behavior.ICacheAccessManagement;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;

public abstract class AbstractCacheAccess<K, V>
implements ICacheAccessManagement {
    private final CompositeCache<K, V> cacheControl;

    protected AbstractCacheAccess(CompositeCache<K, V> compositeCache) {
        this.cacheControl = compositeCache;
    }

    @Override
    public void clear() throws CacheException {
        try {
            this.getCacheControl().removeAll();
        }
        catch (IOException iOException) {
            throw new CacheException(iOException);
        }
    }

    @Override
    public void setDefaultElementAttributes(IElementAttributes iElementAttributes) throws CacheException {
        this.getCacheControl().setElementAttributes(iElementAttributes);
    }

    @Override
    public IElementAttributes getDefaultElementAttributes() throws CacheException {
        return this.getCacheControl().getElementAttributes();
    }

    @Override
    public ICacheStats getStatistics() {
        return this.getCacheControl().getStatistics();
    }

    @Override
    public String getStats() {
        return this.getCacheControl().getStats();
    }

    @Override
    public void dispose() {
        this.getCacheControl().dispose();
    }

    @Override
    public ICompositeCacheAttributes getCacheAttributes() {
        return this.getCacheControl().getCacheAttributes();
    }

    @Override
    public void setCacheAttributes(ICompositeCacheAttributes iCompositeCacheAttributes) {
        this.getCacheControl().setCacheAttributes(iCompositeCacheAttributes);
    }

    @Override
    public int freeMemoryElements(int n) throws CacheException {
        int n2 = -1;
        try {
            n2 = this.getCacheControl().getMemoryCache().freeElements(n);
        }
        catch (IOException iOException) {
            String string = "Failure freeing memory elements.";
            throw new CacheException(string, iOException);
        }
        return n2;
    }

    public CompositeCache<K, V> getCacheControl() {
        return this.cacheControl;
    }
}

