/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.util.Objects;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.SignpostAdapters;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class OAuthParameters {
    public static final String DEFAULT_JOSM_CONSUMER_KEY = "F7zPYlVCqE2BUH9Hr4SsWZSOnrKjpug1EgqkbsSb";
    public static final String DEFAULT_JOSM_CONSUMER_SECRET = "rIkjpPcBNkMQxrqzcOvOC4RRuYupYr7k8mfP13H5";
    private final String consumerKey;
    private final String consumerSecret;
    private final String requestTokenUrl;
    private final String accessTokenUrl;
    private final String authoriseUrl;
    private final String osmLoginUrl;
    private final String osmLogoutUrl;

    public static OAuthParameters createDefault() {
        return OAuthParameters.createDefault(null);
    }

    public static OAuthParameters createDefault(String string) {
        String string2;
        String string3;
        String string4;
        if (!Utils.isValidUrl(string)) {
            string = null;
        }
        if (string != null && !"https://api.openstreetmap.org/api".equals(string)) {
            string4 = "";
            string3 = "";
            string2 = string.replaceAll("/api$", "");
        } else {
            string4 = DEFAULT_JOSM_CONSUMER_KEY;
            string3 = DEFAULT_JOSM_CONSUMER_SECRET;
            string2 = Main.getOSMWebsite();
        }
        return new OAuthParameters(string4, string3, string2 + "/oauth/request_token", string2 + "/oauth/access_token", string2 + "/oauth/authorize", string2 + "/login", string2 + "/logout");
    }

    public static OAuthParameters createFromPreferences(Preferences preferences) {
        OAuthParameters oAuthParameters = OAuthParameters.createDefault(preferences.get("osm-server.url"));
        return new OAuthParameters(preferences.get("oauth.settings.consumer-key", oAuthParameters.getConsumerKey()), preferences.get("oauth.settings.consumer-secret", oAuthParameters.getConsumerSecret()), preferences.get("oauth.settings.request-token-url", oAuthParameters.getRequestTokenUrl()), preferences.get("oauth.settings.access-token-url", oAuthParameters.getAccessTokenUrl()), preferences.get("oauth.settings.authorise-url", oAuthParameters.getAuthoriseUrl()), preferences.get("oauth.settings.osm-login-url", oAuthParameters.getOsmLoginUrl()), preferences.get("oauth.settings.osm-logout-url", oAuthParameters.getOsmLogoutUrl()));
    }

    public void rememberPreferences(Preferences preferences) {
        CheckParameterUtil.ensureParameterNotNull(preferences, "pref");
        preferences.put("oauth.settings.consumer-key", this.getConsumerKey());
        preferences.put("oauth.settings.consumer-secret", this.getConsumerSecret());
        preferences.put("oauth.settings.request-token-url", this.getRequestTokenUrl());
        preferences.put("oauth.settings.access-token-url", this.getAccessTokenUrl());
        preferences.put("oauth.settings.authorise-url", this.getAuthoriseUrl());
        preferences.put("oauth.settings.osm-login-url", this.getOsmLoginUrl());
        preferences.put("oauth.settings.osm-logout-url", this.getOsmLogoutUrl());
    }

    public OAuthParameters(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.consumerKey = string;
        this.consumerSecret = string2;
        this.requestTokenUrl = string3;
        this.accessTokenUrl = string4;
        this.authoriseUrl = string5;
        this.osmLoginUrl = string6;
        this.osmLogoutUrl = string7;
    }

    public OAuthParameters(OAuthParameters oAuthParameters) {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "other");
        this.consumerKey = oAuthParameters.consumerKey;
        this.consumerSecret = oAuthParameters.consumerSecret;
        this.accessTokenUrl = oAuthParameters.accessTokenUrl;
        this.requestTokenUrl = oAuthParameters.requestTokenUrl;
        this.authoriseUrl = oAuthParameters.authoriseUrl;
        this.osmLoginUrl = oAuthParameters.osmLoginUrl;
        this.osmLogoutUrl = oAuthParameters.osmLogoutUrl;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getAuthoriseUrl() {
        return this.authoriseUrl;
    }

    public String getOsmLoginUrl() {
        return this.osmLoginUrl;
    }

    public String getOsmLogoutUrl() {
        return this.osmLogoutUrl;
    }

    public OAuthConsumer buildConsumer() {
        return new SignpostAdapters.OAuthConsumer(this.consumerKey, this.consumerSecret);
    }

    public OAuthProvider buildProvider(OAuthConsumer oAuthConsumer) {
        CheckParameterUtil.ensureParameterNotNull(oAuthConsumer, "consumer");
        return new SignpostAdapters.OAuthProvider(this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OAuthParameters oAuthParameters = (OAuthParameters)object;
        return Objects.equals(this.consumerKey, oAuthParameters.consumerKey) && Objects.equals(this.consumerSecret, oAuthParameters.consumerSecret) && Objects.equals(this.requestTokenUrl, oAuthParameters.requestTokenUrl) && Objects.equals(this.accessTokenUrl, oAuthParameters.accessTokenUrl) && Objects.equals(this.authoriseUrl, oAuthParameters.authoriseUrl) && Objects.equals(this.osmLoginUrl, oAuthParameters.osmLoginUrl) && Objects.equals(this.osmLogoutUrl, oAuthParameters.osmLogoutUrl);
    }

    public int hashCode() {
        return Objects.hash(this.consumerKey, this.consumerSecret, this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl, this.osmLoginUrl, this.osmLogoutUrl);
    }
}

