/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GeoJSONWriter;
import org.openstreetmap.josm.tools.I18n;

public class GeoJSONExporter
extends FileExporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("geojson,json", "geojson", I18n.tr("GeoJSON Files", new Object[0]) + " (*.geojson *.json)");

    public GeoJSONExporter() {
        super(FILE_FILTER);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        if (layer instanceof OsmDataLayer) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write(new GeoJSONWriter((OsmDataLayer)layer).write());
            }
        } else {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' not supported", layer.getClass().toString()));
        }
    }
}

