/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;

public final class OpenBrowser {
    private OpenBrowser() {
    }

    private static void displayUrlFallback(URI uRI) throws IOException {
        if (Main.platform == null) {
            throw new IllegalStateException(I18n.tr("Failed to open URL. There is currently no platform set. Please set a platform first.", new Object[0]));
        }
        Main.platform.openUrl(uRI.toString());
    }

    public static String displayUrl(URI uRI) {
        CheckParameterUtil.ensureParameterNotNull(uRI, "uri");
        Main.info(I18n.tr("Opening URL: {0}", uRI));
        if (Desktop.isDesktopSupported()) {
            try {
                if (Main.isPlatformWindows()) {
                    Desktop.getDesktop().browse(uRI);
                }
                if (Main.platform instanceof PlatformHookUnixoid) {
                    Main.platform.openUrl(uRI.toString());
                }
                try {
                    Desktop.getDesktop().browse(uRI);
                }
                catch (IOException iOException) {
                    Main.warn((Throwable)iOException, "Desktop class failed. Platform dependent fall back for open url in browser.");
                    OpenBrowser.displayUrlFallback(uRI);
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
                return iOException.getMessage();
            }
        } else {
            try {
                Main.warn("Desktop class is not supported. Platform dependent fall back for open url in browser.");
                OpenBrowser.displayUrlFallback(uRI);
            }
            catch (IOException iOException) {
                Main.debug(iOException);
                return iOException.getMessage();
            }
        }
        return null;
    }

    public static String displayUrl(String string) {
        try {
            return OpenBrowser.displayUrl(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            Main.debug(uRISyntaxException);
            return uRISyntaxException.getMessage();
        }
    }
}

