/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportDialog;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public class BugReportQueue {
    private static final BugReportQueue INSTANCE = new BugReportQueue();
    private final LinkedList<ReportedException> reportsToDisplay = new LinkedList();
    private boolean suppressAllMessages;
    private final ArrayList<ReportedException> suppressFor = new ArrayList();
    private Thread displayThread;
    private final BiFunction<ReportedException, Integer, SuppressionMode> bugReportHandler = BugReportQueue.getBestHandler();
    private final CopyOnWriteArrayList<Predicate<ReportedException>> handlers = new CopyOnWriteArrayList();
    private int displayedErrors;
    private boolean inReportDialog;

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void submit(ReportedException reportedException) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        if (this.suppressAllMessages) break block7;
                        if (!this.suppressFor.stream().anyMatch(reportedException::isSame)) break block8;
                    }
                    Main.info("User requested to skip error " + reportedException);
                    return;
                }
                if (this.reportsToDisplay.size() > 100) break block9;
                if (this.reportsToDisplay.stream().filter(reportedException::isSame).count() < 10L) break block10;
            }
            Main.warn("Too many errors. Dropping " + reportedException);
            return;
        }
        this.reportsToDisplay.add(reportedException);
        if (this.displayThread == null) {
            this.displayThread = new Thread(this::displayAll, "bug-report-display");
            this.displayThread.start();
        }
        this.notifyAll();
    }

    private void displayAll() {
        try {
            while (true) {
                ReportedException reportedException = this.getNext();
                SuppressionMode suppressionMode = this.displayFor(reportedException);
                this.handleDialogResult(reportedException, suppressionMode);
            }
        }
        catch (InterruptedException interruptedException) {
            this.displayFor(BugReport.intercept(interruptedException));
            return;
        }
    }

    private synchronized void handleDialogResult(ReportedException reportedException, SuppressionMode suppressionMode) {
        if (suppressionMode == SuppressionMode.ALL) {
            this.suppressAllMessages = true;
            this.reportsToDisplay.clear();
        } else if (suppressionMode == SuppressionMode.SAME) {
            this.suppressFor.add(reportedException);
            this.reportsToDisplay.removeIf(reportedException::isSame);
        }
        ++this.displayedErrors;
        this.inReportDialog = false;
    }

    private synchronized ReportedException getNext() throws InterruptedException {
        while (this.reportsToDisplay.isEmpty()) {
            this.wait();
        }
        this.inReportDialog = true;
        return this.reportsToDisplay.removeFirst();
    }

    private SuppressionMode displayFor(ReportedException reportedException) {
        if (this.handlers.stream().anyMatch(predicate -> predicate.test(reportedException))) {
            Main.trace("Intercepted by handler.");
            return SuppressionMode.NONE;
        }
        return this.bugReportHandler.apply(reportedException, this.getDisplayedErrors());
    }

    private synchronized int getDisplayedErrors() {
        return this.displayedErrors;
    }

    public synchronized boolean exceptionHandlingInProgress() {
        return !this.reportsToDisplay.isEmpty() || this.inReportDialog;
    }

    private static BiFunction<ReportedException, Integer, SuppressionMode> getBestHandler() {
        if (GraphicsEnvironment.isHeadless()) {
            return (reportedException, n) -> {
                reportedException.printStackTrace();
                return SuppressionMode.NONE;
            };
        }
        return BugReportDialog::showFor;
    }

    public void addBugReportHandler(Predicate<ReportedException> predicate) {
        this.handlers.add(predicate);
    }

    public static BugReportQueue getInstance() {
        return INSTANCE;
    }

    public static enum SuppressionMode {
        NONE,
        SAME,
        ALL;

    }
}

