/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.printf.PrintfSimpleTreeBuilder;
import org.jruby.truffle.util.StringUtils;

@NodeChildren(value={@NodeChild(value="width", type=FormatNode.class), @NodeChild(value="precision", type=FormatNode.class), @NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatFloatNode
extends FormatNode {
    private final char format;
    private final boolean hasSpaceFlag;
    private final boolean hasZeroFlag;
    private final boolean hasPlusFlag;
    private final boolean hasMinusFlag;

    public FormatFloatNode(RubyContext context, char format, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag) {
        super(context);
        this.format = format;
        this.hasSpaceFlag = hasSpaceFlag;
        this.hasZeroFlag = hasZeroFlag;
        this.hasPlusFlag = hasPlusFlag;
        this.hasMinusFlag = hasMinusFlag;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isInfinite(value)"})
    public byte[] formatInfinite(int width, int precision, double value) {
        String infinityString = StringUtils.format(this.getInfiniteFormatString(width), value);
        return FormatFloatNode.mapInfiniteResult(infinityString).getBytes(StandardCharsets.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isInfinite(value)"})
    public byte[] formatFinite(int width, int precision, double value) {
        return FormatFloatNode.mapFiniteResult(StringUtils.format(this.getFiniteFormatString(width, precision), value)).getBytes(StandardCharsets.US_ASCII);
    }

    protected boolean isInfinite(double value) {
        return Double.isInfinite(value);
    }

    private static String mapFiniteResult(String input) {
        if (input.contains("NAN")) {
            return input.replaceFirst("NAN", "NaN");
        }
        return input;
    }

    private static String mapInfiniteResult(String input) {
        if (input.contains("-Infinity")) {
            return input.replaceFirst("-Infinity", "-Inf");
        }
        if (input.contains("-INFINITY")) {
            return input.replaceFirst("-INFINITY", "-Inf");
        }
        if (input.contains("INFINITY")) {
            return input.replaceFirst("INFINITY", "Inf");
        }
        if (input.contains("Infinity")) {
            return input.replaceFirst("Infinity", "Inf");
        }
        return input;
    }

    private String getFiniteFormatString(int width, int precision) {
        StringBuilder finiteFormatBuilder = new StringBuilder();
        finiteFormatBuilder.append("%");
        if (this.hasMinusFlag) {
            finiteFormatBuilder.append("-");
        }
        if (this.hasPlusFlag) {
            finiteFormatBuilder.append("+");
        }
        if (this.hasSpaceFlag) {
            finiteFormatBuilder.append(" ");
            finiteFormatBuilder.append(width);
            if (this.hasZeroFlag) {
                finiteFormatBuilder.append(".");
                finiteFormatBuilder.append(width);
            }
        } else if (this.hasZeroFlag) {
            finiteFormatBuilder.append("0");
            if (width > 0) {
                finiteFormatBuilder.append(width);
            } else {
                finiteFormatBuilder.append(1);
            }
        } else if (!this.hasSpaceFlag && !this.hasSpaceFlag && width > 0) {
            finiteFormatBuilder.append(width);
        }
        if (precision != PrintfSimpleTreeBuilder.DEFAULT) {
            finiteFormatBuilder.append(".");
            finiteFormatBuilder.append(precision);
        }
        finiteFormatBuilder.append(this.format);
        return finiteFormatBuilder.toString();
    }

    private String getInfiniteFormatString(int width) {
        StringBuilder infiniteFormatBuilder = new StringBuilder();
        infiniteFormatBuilder.append("%");
        if (this.hasMinusFlag) {
            infiniteFormatBuilder.append("-");
        }
        if (this.hasPlusFlag) {
            infiniteFormatBuilder.append("+");
        }
        if (this.hasSpaceFlag) {
            infiniteFormatBuilder.append(" ");
            infiniteFormatBuilder.append(width + 5);
        }
        if (this.hasZeroFlag && width != 0) {
            infiniteFormatBuilder.append("0");
            infiniteFormatBuilder.append(width + 5);
        }
        if (!this.hasSpaceFlag && !this.hasZeroFlag) {
            infiniteFormatBuilder.append(width + 5);
        }
        infiniteFormatBuilder.append(this.format);
        return infiniteFormatBuilder.toString();
    }
}

