/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.AU;
import javajs.util.P3;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.LineRenderer;
import org.jmol.g3d.Pixelator;
import org.jmol.util.Shader;

class CylinderRenderer {
    private final Graphics3D g3d;
    private final LineRenderer line3d;
    private final Shader shader;
    private short colixA;
    private short colixB;
    private int[] shadesA;
    private int[] shadesB;
    private int xA;
    private int yA;
    private int zA;
    private int dxB;
    private int dyB;
    private int dzB;
    private float xAf;
    private float yAf;
    private float zAf;
    private float dxBf;
    private float dyBf;
    private float dzBf;
    private boolean tEvenDiameter;
    private int diameter;
    private byte endcaps;
    private boolean endCapHidden;
    private int xEndcap;
    private int yEndcap;
    private int zEndcap;
    private int argbEndcap;
    private short colixEndcap;
    private int endcapShadeIndex;
    private float radius;
    private float radius2;
    private float cosTheta;
    private float cosPhi;
    private float sinPhi;
    private boolean clipped;
    private int rasterCount;
    private float[][] xyztRaster = new float[][]{new float[32], new float[32], new float[32], new float[32]};
    private int[][] xyzfRaster = new int[][]{new int[32], new int[32], new int[32], new int[32]};
    private P3 ptA0;
    private P3 ptB0;
    private float xTip;
    private float yTip;
    private float zTip;

    CylinderRenderer(Graphics3D g3d) {
        this.g3d = g3d;
        this.line3d = g3d.line3d;
        this.shader = g3d.shader;
    }

    void renderOld(short colixA, short colixB, int screen, byte endcaps, int diameter, int xa, int ya, int za, int xb, int yb, int zb) {
        int codeMaxB;
        int codeMinB;
        int codeMaxA;
        Graphics3D g = this.g3d;
        int r = diameter / 2 + 1;
        int codeMinA = g.clipCode3(xa - r, ya - r, za - r);
        int c = codeMinA | (codeMaxA = g.clipCode3(xa + r, ya + r, za + r)) | (codeMinB = g.clipCode3(xb - r, yb - r, zb - r)) | (codeMaxB = g.clipCode3(xb + r, yb + r, zb + r));
        boolean bl = this.clipped = c != 0;
        if (c == -1 || (codeMinA & codeMaxB & codeMaxA & codeMinB) != 0) {
            return;
        }
        this.dxB = xb - xa;
        this.dyB = yb - ya;
        this.dzB = zb - za;
        if (diameter <= 1) {
            this.line3d.plotLineDeltaOld(g.getColorArgbOrGray(colixA), g.getColorArgbOrGray(colixB), xa, ya, za, this.dxB, this.dyB, this.dzB, this.clipped);
            return;
        }
        boolean drawBackside = screen == 0 && (this.clipped || endcaps == 2 || endcaps == 0);
        this.diameter = diameter;
        this.xA = xa;
        this.yA = ya;
        this.zA = za;
        this.endcaps = endcaps;
        this.colixA = colixA;
        this.shadesA = g.getShades(this.colixA);
        this.colixB = colixB;
        this.shadesB = g.getShades(this.colixB);
        this.calcArgbEndcap(true, false);
        this.calcCosSin(this.dxB, this.dyB, this.dzB);
        this.calcPoints(3, false);
        this.interpolate(0, 1, this.xyzfRaster, this.xyztRaster);
        this.interpolate(1, 2, this.xyzfRaster, this.xyztRaster);
        int[][] xyzf = this.xyzfRaster;
        if (endcaps == 2) {
            this.renderFlatEndcap(true, false, xyzf);
        }
        g.setZMargin(5);
        int width = g.width;
        int[] zbuf = g.zbuf;
        int[] xr = xyzf[0];
        int[] yr = xyzf[1];
        int[] zr = xyzf[2];
        int[] fr = xyzf[3];
        Pixelator p = g.pixel;
        int i = this.rasterCount;
        while (--i >= 0) {
            int fpz = fr[i] >> 8;
            int fpzBack = fpz >> 1;
            int x = xr[i];
            int y = yr[i];
            int z = zr[i];
            if (this.endCapHidden && this.argbEndcap != 0) {
                if (this.clipped) {
                    g.plotPixelClippedArgb(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1, width, zbuf, p);
                    g.plotPixelClippedArgb(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1, width, zbuf, p);
                } else {
                    g.plotPixelUnclipped(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1, width, zbuf, p);
                    g.plotPixelUnclipped(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1, width, zbuf, p);
                }
            }
            this.line3d.plotLineDeltaAOld(this.shadesA, this.shadesB, screen, fpz, this.xA + x, this.yA + y, this.zA - z, this.dxB, this.dyB, this.dzB, this.clipped);
            if (!drawBackside) continue;
            this.line3d.plotLineDeltaOld(this.shadesA[fpzBack], this.shadesB[fpzBack], this.xA - x, this.yA - y, this.zA + z, this.dxB, this.dyB, this.dzB, this.clipped);
        }
        g.setZMargin(0);
        if (endcaps == 3) {
            this.renderSphericalEndcaps();
        }
    }

    void renderBits(short colixA, short colixB, int screen, byte endcaps, int diameter, P3 ptA, P3 ptB) {
        Graphics3D g = this.g3d;
        if (diameter == 0 || diameter == 1) {
            this.line3d.plotLineBits(g.getColorArgbOrGray(colixA), g.getColorArgbOrGray(colixB), ptA, ptB);
            return;
        }
        if (this.ptA0 == null) {
            this.ptA0 = new P3();
            this.ptB0 = new P3();
        }
        this.ptA0.setT(ptA);
        int r = diameter / 2 + 1;
        int ixA = Math.round(ptA.x);
        int iyA = Math.round(ptA.y);
        int izA = Math.round(ptA.z);
        int ixB = Math.round(ptB.x);
        int iyB = Math.round(ptB.y);
        int izB = Math.round(ptB.z);
        int codeMinA = g.clipCode3(ixA - r, iyA - r, izA - r);
        int codeMaxA = g.clipCode3(ixA + r, iyA + r, izA + r);
        int codeMinB = g.clipCode3(ixB - r, iyB - r, izB - r);
        int codeMaxB = g.clipCode3(ixB + r, iyB + r, izB + r);
        int c = codeMinA | codeMaxA | codeMinB | codeMaxB;
        boolean bl = this.clipped = c != 0;
        if (c == -1 || (codeMinA & codeMaxB & codeMaxA & codeMinB) != 0) {
            return;
        }
        this.dxBf = ptB.x - ptA.x;
        this.dyBf = ptB.y - ptA.y;
        this.dzBf = ptB.z - ptA.z;
        if (diameter > 0) {
            this.diameter = diameter;
            this.xAf = ptA.x;
            this.yAf = ptA.y;
            this.zAf = ptA.z;
        }
        boolean drawBackside = screen == 0 && (this.clipped || endcaps == 2 || endcaps == 0);
        this.xA = (int)this.xAf;
        this.yA = (int)this.yAf;
        this.zA = (int)this.zAf;
        this.dxB = (int)this.dxBf;
        this.dyB = (int)this.dyBf;
        this.dzB = (int)this.dzBf;
        this.colixA = colixA;
        this.shadesA = g.getShades(this.colixA);
        this.colixB = colixB;
        this.shadesB = g.getShades(this.colixB);
        this.endcaps = endcaps;
        this.calcArgbEndcap(true, true);
        int[][] xyzf = this.xyzfRaster;
        if (diameter > 0) {
            this.generateBaseEllipsePrecisely(false);
        }
        if (endcaps == 2) {
            this.renderFlatEndcap(true, true, xyzf);
        }
        this.line3d.setLineBits(this.dxBf, this.dyBf);
        g.setZMargin(5);
        Pixelator p = g.pixel;
        int width = g.width;
        int[] zbuf = g.zbuf;
        int[] xr = xyzf[0];
        int[] yr = xyzf[1];
        int[] zr = xyzf[2];
        int[] fr = xyzf[3];
        int i = this.rasterCount;
        while (--i >= 0) {
            int fpz = fr[i] >> 8;
            int fpzBack = fpz >> 1;
            int x = xr[i];
            int y = yr[i];
            int z = zr[i];
            if (this.endCapHidden && this.argbEndcap != 0) {
                if (this.clipped) {
                    g.plotPixelClippedArgb(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1, width, zbuf, p);
                    g.plotPixelClippedArgb(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1, width, zbuf, p);
                } else {
                    g.plotPixelUnclipped(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1, width, zbuf, p);
                    g.plotPixelUnclipped(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1, width, zbuf, p);
                }
            }
            this.ptA0.set(this.xA + x, this.yA + y, this.zA - z);
            this.ptB0.setT(this.ptA0);
            this.ptB0.x += (float)this.dxB;
            this.ptB0.y += (float)this.dyB;
            this.ptB0.z += (float)this.dzB;
            this.line3d.plotLineDeltaABits(this.shadesA, this.shadesB, fpz, this.ptA0, this.ptB0, screen, this.clipped);
            if (!drawBackside) continue;
            this.ptA0.set(this.xA - x, this.yA - y, this.zA + z);
            this.ptB0.setT(this.ptA0);
            this.ptB0.x += (float)this.dxB;
            this.ptB0.y += (float)this.dyB;
            this.ptB0.z += (float)this.dzB;
            this.line3d.plotLineDeltaABits(this.shadesA, this.shadesB, fpzBack, this.ptA0, this.ptB0, screen, this.clipped);
        }
        g.setZMargin(0);
        if (endcaps == 3) {
            this.renderSphericalEndcaps();
        }
        this.xAf += this.dxBf;
        this.yAf += this.dyBf;
        this.zAf += this.dzBf;
    }

    void renderConeOld(short colix, byte endcap, int diameter, float xa, float ya, float za, float xtip, float ytip, float ztip, boolean doFill, boolean isBarb) {
        this.xAf = xa;
        this.dxBf = xtip - this.xAf;
        this.yAf = ya;
        this.dyBf = ytip - this.yAf;
        this.zAf = za;
        this.dzBf = ztip - this.zAf;
        this.xA = (int)Math.floor(this.xAf);
        this.yA = (int)Math.floor(this.yAf);
        this.zA = (int)Math.floor(this.zAf);
        this.dxB = (int)Math.floor(this.dxBf);
        this.dyB = (int)Math.floor(this.dyBf);
        this.dzB = (int)Math.floor(this.dzBf);
        this.xTip = xtip;
        this.yTip = ytip;
        this.zTip = ztip;
        this.colixA = colix;
        this.shadesA = this.g3d.getShades(this.colixA);
        int shadeIndexTip = this.shader.getShadeIndex(this.dxB, this.dyB, -this.dzB);
        Graphics3D g3d = this.g3d;
        Pixelator p = g3d.pixel;
        int width = g3d.width;
        int[] zbuf = g3d.zbuf;
        g3d.plotPixelClippedArgb(this.shadesA[shadeIndexTip], (int)xtip, (int)ytip, (int)ztip, width, zbuf, p);
        this.diameter = diameter;
        if (diameter <= 1) {
            if (diameter == 1) {
                this.line3d.plotLineDeltaOld(this.colixA, this.colixA, this.xA, this.yA, this.zA, this.dxB, this.dyB, this.dzB, this.clipped);
            }
            return;
        }
        this.endcaps = endcap;
        this.calcArgbEndcap(false, true);
        this.generateBaseEllipsePrecisely(isBarb);
        if (!isBarb && this.endcaps == 2) {
            this.renderFlatEndcap(false, true, this.xyzfRaster);
        }
        g3d.setZMargin(5);
        float[] xr = this.xyztRaster[0];
        float[] yr = this.xyztRaster[1];
        float[] zr = this.xyztRaster[2];
        int[] fr = this.xyzfRaster[3];
        int[] sA = this.shadesA;
        boolean doOpen = this.endCapHidden && this.argbEndcap != 0;
        int i = this.rasterCount;
        while (--i >= 0) {
            float x = xr[i];
            float y = yr[i];
            float z = zr[i];
            int fpz = fr[i] >> 8;
            float xUp = this.xAf + x;
            float yUp = this.yAf + y;
            float zUp = this.zAf - z;
            float xDn = this.xAf - x;
            float yDn = this.yAf - y;
            float zDn = this.zAf + z;
            int argb = sA[0];
            if (doOpen) {
                g3d.plotPixelClippedArgb(this.argbEndcap, (int)xUp, (int)yUp, (int)zUp, width, zbuf, p);
                g3d.plotPixelClippedArgb(this.argbEndcap, (int)xDn, (int)yDn, (int)zDn, width, zbuf, p);
            }
            if (argb == 0) continue;
            this.line3d.plotLineDeltaAOld(sA, sA, 0, fpz, (int)xUp, (int)yUp, (int)zUp, (int)Math.ceil(this.xTip - xUp), (int)Math.ceil(this.yTip - yUp), (int)Math.ceil(this.zTip - zUp), true);
            if (doFill) {
                this.line3d.plotLineDeltaAOld(sA, sA, 0, fpz, (int)xUp, (int)yUp + 1, (int)zUp, (int)Math.ceil(this.xTip - xUp), (int)Math.ceil(this.yTip - yUp) + 1, (int)Math.ceil(this.zTip - zUp), true);
                this.line3d.plotLineDeltaAOld(sA, sA, 0, fpz, (int)xUp + 1, (int)yUp, (int)zUp, (int)Math.ceil(this.xTip - xUp) + 1, (int)Math.ceil(this.yTip - yUp), (int)Math.ceil(this.zTip - zUp), true);
            }
            if (isBarb || this.endcaps != 2 && this.dzB > 0) continue;
            this.line3d.plotLineDeltaOld(argb, argb, (int)xDn, (int)yDn, (int)zDn, (int)Math.ceil(this.xTip - xDn), (int)Math.ceil(this.yTip - yDn), (int)Math.ceil(this.zTip - zDn), true);
        }
        g3d.setZMargin(0);
    }

    private void generateBaseEllipsePrecisely(boolean isBarb) {
        this.calcCosSin(this.dxBf, this.dyBf, this.dzBf);
        this.calcPoints(isBarb ? 2 : 3, true);
        this.interpolatePrecisely(0, 1, this.xyzfRaster, this.xyztRaster);
        if (!isBarb) {
            this.interpolatePrecisely(1, 2, this.xyzfRaster, this.xyztRaster);
        }
        int i = 3;
        while (--i >= 0) {
            int j = this.rasterCount;
            while (--j >= 0) {
                this.xyzfRaster[i][j] = (int)Math.floor(this.xyztRaster[i][j]);
            }
        }
    }

    private void calcPoints(int count, boolean isPrecise) {
        this.calcRotatedPoint(0.0f, 0, isPrecise, this.xyzfRaster, this.xyztRaster);
        this.calcRotatedPoint(0.5f, 1, isPrecise, this.xyzfRaster, this.xyztRaster);
        this.rasterCount = count;
        if (this.rasterCount == 3) {
            this.calcRotatedPoint(1.0f, 2, isPrecise, this.xyzfRaster, this.xyztRaster);
        }
    }

    private void calcCosSin(float dx, float dy, float dz) {
        float mag2d2 = dx * dx + dy * dy;
        if (mag2d2 == 0.0f) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float mag2d = (float)Math.sqrt(mag2d2);
            float mag3d = (float)Math.sqrt(mag2d2 + dz * dz);
            this.cosTheta = dz / mag3d;
            this.cosPhi = dx / mag2d;
            this.sinPhi = dy / mag2d;
        }
    }

    private void calcRotatedPoint(float t, int i, boolean isPrecision, int[][] xyzf, float[][] xyzt) {
        double zR;
        double yR;
        double yT;
        xyzt[3][i] = t;
        double tPI = (double)t * Math.PI;
        double xT = Math.sin(tPI) * (double)this.cosTheta;
        double xR = (double)this.radius * (xT * (double)this.cosPhi - (yT = Math.cos(tPI)) * (double)this.sinPhi);
        double z2 = (double)this.radius2 - (xR * xR + (yR = (double)this.radius * (xT * (double)this.sinPhi + yT * (double)this.cosPhi)) * yR);
        double d = zR = z2 > 0.0 ? Math.sqrt(z2) : 0.0;
        if (isPrecision) {
            xyzt[0][i] = (float)xR;
            xyzt[1][i] = (float)yR;
            xyzt[2][i] = (float)zR;
        } else if (this.tEvenDiameter) {
            xyzf[0][i] = (int)(xR - 0.5);
            xyzf[1][i] = (int)(yR - 0.5);
            xyzf[2][i] = (int)(zR + 0.5);
        } else {
            xyzf[0][i] = (int)xR;
            xyzf[1][i] = (int)yR;
            xyzf[2][i] = (int)(zR + 0.5);
        }
        xyzf[3][i] = this.shader.getShadeFp8((float)xR, (float)yR, (float)zR);
    }

    private int allocRaster(boolean isPrecision, int[][] xyzf, float[][] xyzt) {
        int i;
        if (this.rasterCount >= xyzf[0].length) {
            while (this.rasterCount >= xyzf[0].length) {
                i = 4;
                while (--i >= 0) {
                    xyzf[i] = AU.doubleLengthI(xyzf[i]);
                }
                xyzt[3] = AU.doubleLengthF(xyzt[3]);
            }
        }
        if (isPrecision) {
            while (this.rasterCount >= xyzt[0].length) {
                i = 3;
                while (--i >= 0) {
                    xyzt[i] = AU.doubleLengthF(xyzt[i]);
                }
            }
        }
        return this.rasterCount++;
    }

    private void interpolate(int iLower, int iUpper, int[][] xyzf, float[][] xyzt) {
        int dy;
        int[] x = xyzf[0];
        int[] y = xyzf[1];
        int dx = x[iUpper] - x[iLower];
        if (dx < 0) {
            dx = -dx;
        }
        if ((dy = y[iUpper] - y[iLower]) < 0) {
            dy = -dy;
        }
        if (dx + dy <= 1) {
            return;
        }
        int iMid = this.allocRaster(false, xyzf, xyzt);
        x = xyzf[0];
        y = xyzf[1];
        int[] f = xyzf[3];
        float tLower = xyzt[3][iLower];
        float tUpper = xyzt[3][iUpper];
        int j = 4;
        while (--j >= 0) {
            float tMid = (tLower + tUpper) / 2.0f;
            this.calcRotatedPoint(tMid, iMid, false, xyzf, xyzt);
            if (x[iMid] == x[iLower] && y[iMid] == y[iLower]) {
                f[iLower] = f[iLower] + f[iMid] >>> 1;
                tLower = tMid;
                continue;
            }
            if (x[iMid] == x[iUpper] && y[iMid] == y[iUpper]) {
                f[iUpper] = f[iUpper] + f[iMid] >>> 1;
                tUpper = tMid;
                continue;
            }
            this.interpolate(iLower, iMid, xyzf, xyzt);
            this.interpolate(iMid, iUpper, xyzf, xyzt);
            return;
        }
        x[iMid] = x[iLower];
        y[iMid] = y[iUpper];
    }

    private void interpolatePrecisely(int iLower, int iUpper, int[][] xyzf, float[][] xyzt) {
        float dy;
        float[] x = xyzt[0];
        float[] y = xyzt[1];
        int dx = (int)Math.floor(x[iUpper]) - (int)Math.floor(x[iLower]);
        if (dx < 0) {
            dx = -dx;
        }
        if ((dy = (float)((int)Math.floor(y[iUpper]) - (int)Math.floor(y[iLower]))) < 0.0f) {
            dy = -dy;
        }
        if ((float)dx + dy <= 1.0f) {
            return;
        }
        float[] t = xyzt[3];
        float tLower = t[iLower];
        float tUpper = t[iUpper];
        int iMid = this.allocRaster(true, xyzf, xyzt);
        x = xyzt[0];
        y = xyzt[1];
        t = xyzt[3];
        int[] f = xyzf[3];
        int j = 4;
        while (--j >= 0) {
            float tMid = (tLower + tUpper) / 2.0f;
            this.calcRotatedPoint(tMid, iMid, true, xyzf, xyzt);
            if ((int)Math.floor(x[iMid]) == (int)Math.floor(x[iLower]) && (int)Math.floor(y[iMid]) == (int)Math.floor(y[iLower])) {
                f[iLower] = f[iLower] + f[iMid] >>> 1;
                tLower = tMid;
                continue;
            }
            if ((int)Math.floor(x[iMid]) == (int)Math.floor(x[iUpper]) && (int)Math.floor(y[iMid]) == (int)Math.floor(y[iUpper])) {
                f[iUpper] = f[iUpper] + f[iMid] >>> 1;
                tUpper = tMid;
                continue;
            }
            this.interpolatePrecisely(iLower, iMid, xyzf, xyzt);
            this.interpolatePrecisely(iMid, iUpper, xyzf, xyzt);
            return;
        }
        x[iMid] = x[iLower];
        y[iMid] = y[iUpper];
    }

    private void renderFlatEndcap(boolean isCylinder, boolean isPrecise, int[][] xyzf) {
        int zT;
        int yT;
        int xT;
        if (isPrecise) {
            if (this.dzBf == 0.0f || !this.g3d.setC(this.colixEndcap)) {
                return;
            }
            float xTf = this.xAf;
            float yTf = this.yAf;
            float zTf = this.zAf;
            if (isCylinder && this.dzBf < 0.0f) {
                xTf += this.dxBf;
                yTf += this.dyBf;
                zTf += this.dzBf;
            }
            xT = (int)xTf;
            yT = (int)yTf;
            zT = (int)zTf;
        } else {
            if (this.dzB == 0 || !this.g3d.setC(this.colixEndcap)) {
                return;
            }
            xT = this.xA;
            yT = this.yA;
            zT = this.zA;
            if (isCylinder && this.dzB < 0) {
                xT += this.dxB;
                yT += this.dyB;
                zT += this.dzB;
            }
        }
        int yMin = xyzf[1][0];
        int yMax = xyzf[1][0];
        int zXMin = 0;
        int zXMax = 0;
        int[] xr = xyzf[0];
        int[] yr = xyzf[1];
        int[] zr = xyzf[2];
        int i = this.rasterCount;
        while (--i > 0) {
            int y = yr[i];
            if (y < yMin) {
                yMin = y;
                continue;
            }
            if (y > yMax) {
                yMax = y;
                continue;
            }
            if ((y = -y) < yMin) {
                yMin = y;
                continue;
            }
            if (y <= yMax) continue;
            yMax = y;
        }
        for (int y = yMin; y <= yMax; ++y) {
            int xMin = Integer.MAX_VALUE;
            int xMax = Integer.MIN_VALUE;
            int i2 = this.rasterCount;
            while (--i2 >= 0) {
                int x;
                if (yr[i2] == y) {
                    x = xr[i2];
                    if (x < xMin) {
                        xMin = x;
                        zXMin = zr[i2];
                    }
                    if (x > xMax) {
                        xMax = x;
                        zXMax = zr[i2];
                    }
                }
                if (yr[i2] != -y) continue;
                x = -xr[i2];
                if (x < xMin) {
                    xMin = x;
                    zXMin = -zr[i2];
                }
                if (x <= xMax) continue;
                xMax = x;
                zXMax = -zr[i2];
            }
            int count = xMax - xMin + 1;
            this.g3d.setColorNoisy(this.endcapShadeIndex);
            this.g3d.plotPixelsClippedRaster(count, xT + xMin, yT + y, zT - zXMin - 1, zT - zXMax - 1, null, null);
        }
    }

    private void renderSphericalEndcaps() {
        if (this.colixA != 0 && this.g3d.setC(this.colixA)) {
            this.g3d.fillSphereXYZ(this.diameter, this.xA, this.yA, this.zA + 1);
        }
        if (this.colixB != 0 && this.g3d.setC(this.colixB)) {
            this.g3d.fillSphereXYZ(this.diameter, this.xA + this.dxB, this.yA + this.dyB, this.zA + this.dzB + 1);
        }
    }

    private void calcArgbEndcap(boolean tCylinder, boolean isFloat) {
        int[] shadesEndcap;
        float dyf;
        float dzf;
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        this.endCapHidden = false;
        float f = dzf = isFloat ? this.dzBf : (float)this.dzB;
        if (this.endcaps == 3 || dzf == 0.0f) {
            return;
        }
        this.xEndcap = this.xA;
        this.yEndcap = this.yA;
        this.zEndcap = this.zA;
        float dxf = isFloat ? this.dxBf : (float)this.dxB;
        float f2 = dyf = isFloat ? this.dyBf : (float)this.dyB;
        if (dzf >= 0.0f || !tCylinder) {
            this.endcapShadeIndex = this.shader.getShadeIndex(-dxf, -dyf, dzf);
            this.colixEndcap = this.colixA;
            shadesEndcap = this.shadesA;
        } else {
            this.endcapShadeIndex = this.shader.getShadeIndex(dxf, dyf, -dzf);
            this.colixEndcap = this.colixB;
            shadesEndcap = this.shadesB;
            this.xEndcap += this.dxB;
            this.yEndcap += this.dyB;
            this.zEndcap += this.dzB;
        }
        if (this.endcapShadeIndex > 56) {
            this.endcapShadeIndex = 56;
        }
        this.argbEndcap = shadesEndcap[this.endcapShadeIndex];
        this.endCapHidden = this.endcaps == 1;
    }
}

