/*
 * Decompiled with CFR 0.152.
 */
package jspecview.dialog;

import java.util.Map;
import javajs.util.DF;
import javajs.util.PT;
import jspecview.api.AnnotationData;
import jspecview.api.JSVPanel;
import jspecview.api.PlatformDialog;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.IntegralData;
import jspecview.common.JSViewer;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PeakData;
import jspecview.common.Spectrum;
import jspecview.dialog.DialogManager;

public abstract class JSVDialog
extends Annotation
implements AnnotationData {
    public String optionKey;
    public Map<String, Object> options;
    protected Annotation.AType type;
    protected String title;
    protected JSViewer vwr;
    protected Spectrum spec;
    protected DialogManager manager;
    protected PlatformDialog dialog;
    protected JSVPanel jsvp;
    protected Object txt1;
    protected Object txt2;
    protected Object txt3;
    protected Object combo1;
    protected MeasurementData xyData;
    protected Parameters myParams;
    protected int precision = 1;
    private int[] loc;
    private Object showHideButton;
    private boolean addClearBtn;
    private boolean addCombo1;
    protected boolean addApplyBtn;
    private boolean isNumeric;
    private boolean defaultVisible;
    private String subType;
    private String graphSetKey;
    private Object[][] tableData;
    private boolean addUnits;
    private String[] unitOptions;
    private int[] formatOptions;
    private Integer unitPtr;
    private boolean isON = true;
    protected double lastNorm = 1.0;
    protected int iRowColSelected = -1;
    protected int iSelected = -1;
    private boolean skipCreate;
    private int iRowSelected = -1;
    private int iColSelected = -1;

    public abstract int[] getPosXY();

    protected abstract void addUniqueControls();

    public abstract boolean callback(String var1, String var2);

    public JSVDialog setParams(String string, JSViewer jSViewer, Spectrum spectrum) {
        this.title = string;
        this.vwr = jSViewer;
        this.spec = spectrum;
        this.manager = jSViewer.getDialogManager();
        this.jsvp = jSViewer.selectedPanel;
        this.myParams = ((Parameters)jSViewer.getPlatformInterface("Parameters")).setName("dialogParams");
        this.subType = spectrum == null ? "!" : spectrum.getTypeLabel();
        this.optionKey = (Object)((Object)this.type) + "_" + this.subType;
        this.options = this.manager.getDialogOptions();
        if (spectrum != null) {
            Object[] objectArray = spectrum.getDefaultAnnotationInfo(this.type);
            this.options.put(this.optionKey, objectArray);
            this.unitOptions = (String[])objectArray[0];
            this.formatOptions = (int[])objectArray[1];
            this.unitPtr = (Integer)this.options.get(this.optionKey + "_unitPtr");
            if (this.unitPtr == null) {
                this.unitPtr = (Integer)objectArray[2];
            }
        }
        switch (this.type) {
            case Integration: {
                this.isNumeric = true;
                this.addClearBtn = true;
                this.defaultVisible = true;
                this.addApplyBtn = true;
                break;
            }
            case Measurements: {
                this.isNumeric = true;
                this.addClearBtn = true;
                this.addCombo1 = true;
                this.defaultVisible = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
            case PeakList: {
                this.isNumeric = true;
                this.addApplyBtn = true;
                this.defaultVisible = true;
                break;
            }
            case Views: {
                this.defaultVisible = true;
                break;
            }
        }
        this.initDialog();
        return this;
    }

    private void initDialog() {
        this.dialog = this.manager.getDialog(this);
        this.restoreDialogPosition(this.jsvp, this.getPosXY());
        this.dialog.setTitle(this.title);
        this.layoutDialog();
    }

    protected void layoutDialog() {
        this.dialog.startLayout();
        this.addUniqueControls();
        if (this.isNumeric) {
            this.getUnitOptions();
            if (this.addCombo1) {
                this.combo1 = this.dialog.addSelectOption("cmbUnits", "Units", this.unitOptions, this.unitPtr, this.addUnits);
            }
            if (this.addApplyBtn) {
                this.dialog.addButton("btnApply", "Apply");
            }
            this.showHideButton = this.dialog.addButton("btnShow", "Show");
            if (this.addClearBtn) {
                this.dialog.addButton("btnClear", "Clear");
            }
        }
        this.dialog.endLayout();
        this.checkEnables();
        this.dialog.setVisible(this.defaultVisible);
    }

    protected boolean callbackAD(String string, String string2) {
        if (string.equals("FOCUS")) {
            this.eventFocus();
        } else if (string.equals("tableSelect")) {
            this.tableSelect(string2);
        } else if (string.equals("btnClear")) {
            this.clear();
        } else if (string.equals("btnApply")) {
            this.eventApply();
        } else if (string.equals("btnShow")) {
            String string3 = this.dialog.getText(this.showHideButton);
            this.eventShowHide(string3.equals("Show"));
        } else if (string.equals("cmbUnits")) {
            this.setPrecision(this.dialog.getSelectedIndex(this.combo1));
        } else if (string.startsWith("txt")) {
            this.eventApply();
        } else if (string.equals("windowClosing")) {
            this.done();
            return true;
        }
        if (this.jsvp != null) {
            this.jsvp.doRepaint(true);
        }
        return true;
    }

    protected void addUniqueControls(DialogManager dialogManager) {
    }

    @Override
    public Annotation.AType getAType() {
        return this.type;
    }

    @Override
    public String getGraphSetKey() {
        return this.graphSetKey;
    }

    @Override
    public void setGraphSetKey(String string) {
        this.graphSetKey = string;
    }

    @Override
    public Spectrum getSpectrum() {
        return this.spec;
    }

    @Override
    public boolean getState() {
        return this.isON;
    }

    @Override
    public void setState(boolean bl) {
        this.isON = bl;
    }

    public void checkEnables() {
        boolean bl = this.checkVisible();
        this.dialog.setText(this.showHideButton, bl ? "Hide" : "Show");
    }

    public void createTable(Object[][] objectArray, String[] stringArray, int[] nArray) {
        this.tableData = objectArray;
        this.dialog.createTable(objectArray, stringArray, nArray);
    }

    public void setTableSelectionEnabled(boolean bl) {
        this.dialog.setCellSelectionEnabled(bl);
    }

    @Override
    public Parameters getParameters() {
        return this.myParams;
    }

    public void showMessage(String string, String string2, int n) {
        this.manager.showMessageDialog(this.dialog, string, string2, n);
    }

    protected void setThreshold(double d) {
        this.dialog.setText(this.txt1, this.getThreasholdText(d));
    }

    public void setComboSelected(int n) {
        this.dialog.setSelectedIndex(this.combo1, n);
    }

    public void applyFromFields() {
        this.apply(null);
    }

    public JSVDialog reEnable() {
        this.paramsReEnable();
        return this;
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public void setVisible(boolean bl) {
        this.dialog.setVisible(bl);
    }

    @Override
    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    public void selectTableRow(int n) {
        this.dialog.selectTableRow(n);
    }

    public void repaint() {
        this.dialog.repaint();
    }

    public void setFields() {
        switch (this.type) {
            case Integration: {
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.myParams = this.xyData.getParameters();
                this.setThreshold(this.myParams.peakListThreshold);
                this.setComboSelected(this.myParams.peakListInterpolation.equals("none") ? 1 : 0);
                this.createData();
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    public void setFocus(boolean bl) {
        this.dialog.setFocus(bl);
    }

    public void update(Coordinate coordinate, double d, int n) {
        this.selectTableRow(-1);
        switch (this.type) {
            case Integration: {
                this.loadData();
                this.checkEnables();
                break;
            }
            case Measurements: {
                this.loadData();
                this.checkEnables();
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                if (n > 20) {
                    this.applyFromFields();
                }
                if (this.xyData == null || coordinate == null || n > 20) {
                    return;
                }
                int n2 = 0;
                double d2 = 1.0E100;
                double d3 = coordinate.getXVal();
                PeakData peakData = (PeakData)this.xyData;
                double d4 = Math.abs(d / 20.0);
                int n3 = peakData.size();
                while (--n3 >= 0) {
                    double d5 = Math.abs(d3 - ((Measurement)peakData.get(n3)).getXVal());
                    if (!(d5 < d2)) continue;
                    d2 = d5;
                    n2 = n3;
                }
                if (!(d2 < d4)) break;
                this.selectTableRow(peakData.size() - 2 - n2);
                this.repaint();
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    public MeasurementData getPeakData() {
        PeakData peakData = new PeakData(Annotation.AType.PeakList, this.spec);
        peakData.setPeakList(this.myParams, this.precision, this.jsvp.getPanelData().getView());
        this.xyData = peakData;
        return null;
    }

    @Override
    public MeasurementData getData() {
        if (this.xyData == null) {
            this.createData();
        }
        return this.xyData;
    }

    public void setData(AnnotationData annotationData) {
        this.myParams = annotationData.getParameters();
        this.xyData = (MeasurementData)annotationData;
    }

    @Override
    public void setSpecShift(double d) {
        if (this.xyData != null) {
            this.xyData.setSpecShift(d);
        }
    }

    public void setType(Annotation.AType aType) {
        this.type = aType;
        switch (aType) {
            case Measurements: {
                this.addUnits = true;
                break;
            }
            case Integration: {
                break;
            }
            case PeakList: {
                break;
            }
            case OverlayLegend: {
                break;
            }
            case Views: {
                break;
            }
        }
    }

    protected void apply(Object[] objectArray) {
        try {
            switch (this.type) {
                case Integration: {
                    double d = Double.parseDouble((String)objectArray[0]);
                    double d2 = Double.parseDouble((String)objectArray[1]);
                    this.myParams.integralOffset = d;
                    this.myParams.integralRange = d2;
                    this.myParams.integralDrawAll = false;
                    ((IntegralData)this.getData()).update(this.myParams);
                    break;
                }
                case Measurements: {
                    break;
                }
                case NONE: {
                    return;
                }
                case PeakList: {
                    if (!this.skipCreate) {
                        this.setThreshold(Double.NaN);
                        this.createData();
                    }
                    this.skipCreate = false;
                    break;
                }
                case OverlayLegend: {
                    break;
                }
                case Views: {
                    this.vwr.parameters.viewOffset = Double.parseDouble((String)objectArray[0]);
                }
            }
            this.loadData();
            this.checkEnables();
            this.jsvp.doRepaint(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void done() {
        if (this.jsvp != null && this.spec != null) {
            this.jsvp.getPanelData().removeDialog(this);
        }
        if (this.xyData != null) {
            this.xyData.setState(this.isON);
        }
        this.saveDialogPosition(this.getPosXY());
        this.dispose();
        this.jsvp.doRepaint(true);
    }

    private void restoreDialogPosition(JSVPanel jSVPanel, int[] nArray) {
        if (jSVPanel != null) {
            if (nArray[0] == Integer.MIN_VALUE) {
                nArray[0] = 0;
                nArray[1] = -20;
            }
            int[] nArray2 = this.manager.getLocationOnScreen(jSVPanel);
            int n = jSVPanel.getHeight();
            this.loc = new int[]{Math.max(0, nArray2[0] + nArray[0]), Math.max(0, nArray2[1] + n + nArray[1])};
            this.dialog.setIntLocation(this.loc);
        }
    }

    private void saveDialogPosition(int[] nArray) {
        try {
            int[] nArray2 = this.manager.getLocationOnScreen(this.dialog);
            nArray[0] = nArray[0] + (nArray2[0] - this.loc[0]);
            nArray[1] = nArray[1] + (nArray2[1] - this.loc[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getThreasholdText(double d) {
        Object object;
        if (Double.isNaN(d)) {
            object = this.jsvp.getPanelData();
            double d2 = ((PanelData)object).getSpectrum().isInverted() ? 0.1 : 0.9;
            Coordinate coordinate = ((PanelData)object).getClickedCoordinate();
            d = coordinate == null ? (((PanelData)object).getView().minYOnScale * d2 + ((PanelData)object).getView().maxYOnScale) * (1.0 - d2) : coordinate.getYVal();
        }
        object = DF.formatDecimalDbl(d, d < 1000.0 ? 2 : -2);
        return " " + (String)object;
    }

    private boolean checkVisible() {
        return this.vwr.pd().getShowAnnotation(this.type);
    }

    private void getUnitOptions() {
        String string = this.optionKey + "_format";
        Integer n = (Integer)this.options.get(string);
        if (n == null) {
            n = this.formatOptions[this.unitPtr == null ? 0 : this.unitPtr];
            this.options.put(string, n);
        }
    }

    protected void eventFocus() {
        if (this.spec != null) {
            this.jsvp.getPanelData().jumpToSpectrum(this.spec);
        }
        switch (this.type) {
            case Integration: {
                if (this.iRowSelected < 0) break;
                ++this.iRowSelected;
                this.tableCellSelect(-1, -1);
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.createData();
                this.skipCreate = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    protected void eventApply() {
        switch (this.type) {
            case Integration: {
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.createData();
                this.skipCreate = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
        this.applyFromFields();
    }

    private void eventShowHide(boolean bl) {
        this.isON = bl;
        if (bl) {
            this.eventApply();
        }
        this.jsvp.doRepaint(true);
        this.checkEnables();
    }

    private void clear() {
        this.setState(true);
        if (this.xyData != null) {
            this.xyData.clear();
            this.applyFromFields();
        }
    }

    private void paramsReEnable() {
        switch (this.type) {
            case Integration: {
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.skipCreate = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
        this.setVisible(true);
        this.isON = true;
        this.applyFromFields();
    }

    private void tableCellSelect(int n, int n2) {
        System.out.println(n + " jSVDial " + n2);
        if (n < 0) {
            n = this.iRowColSelected / 1000;
            n2 = this.iRowColSelected % 1000;
            this.iRowColSelected = -1;
        }
        Object object = this.tableData[n][1];
        int n3 = n * 1000 + n2;
        if (n3 == this.iRowColSelected) {
            return;
        }
        this.iRowColSelected = n3;
        System.out.println("Setting rc = " + this.iRowColSelected + " " + this.spec);
        this.selectTableRow(this.iRowSelected);
        try {
            switch (this.type) {
                case Integration: {
                    this.callback("SHOWSELECTION", object.toString());
                    this.checkEnables();
                    break;
                }
                case Measurements: {
                    break;
                }
                case NONE: {
                    break;
                }
                case PeakList: {
                    try {
                        switch (n2) {
                            case 4: 
                            case 5: 
                            case 6: {
                                double d = Double.parseDouble((String)object);
                                double d2 = Double.parseDouble((String)this.tableData[n + 3 - n2][1]);
                                this.jsvp.getPanelData().setXPointers(this.spec, d, this.spec, d2);
                                break;
                            }
                            default: {
                                this.jsvp.getPanelData().findX(this.spec, Double.parseDouble((String)object));
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.jsvp.getPanelData().findX(this.spec, 1.0E100);
                    }
                    this.jsvp.doRepaint(false);
                    break;
                }
                case OverlayLegend: {
                    this.jsvp.getPanelData().setSpectrum(n, false);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadData() {
        switch (this.type) {
            case Integration: {
                if (this.xyData == null) {
                    this.createData();
                }
                this.iSelected = -1;
                Object[][] objectArray = ((IntegralData)this.xyData).getMeasurementListArray(null);
                String[] stringArray = this.xyData.getDataHeader();
                int[] nArray = new int[]{40, 65, 65, 50};
                this.createTable(objectArray, stringArray, nArray);
                break;
            }
            case Measurements: {
                if (this.xyData == null) {
                    return;
                }
                Object[][] objectArray = this.xyData.getMeasurementListArray(this.dialog.getSelectedItem(this.combo1).toString());
                String[] stringArray = this.xyData.getDataHeader();
                int[] nArray = new int[]{40, 65, 65, 50};
                this.createTable(objectArray, stringArray, nArray);
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                if (this.xyData == null) {
                    this.createData();
                }
                Object[][] objectArray = ((PeakData)this.xyData).getMeasurementListArray(null);
                String[] stringArray = ((PeakData)this.xyData).getDataHeader();
                int[] nArray = new int[]{40, 65, 50, 50, 50, 50, 50};
                this.createTable(objectArray, stringArray, nArray);
                this.setTableSelectionEnabled(true);
                break;
            }
            case OverlayLegend: {
                String[] stringArray = new String[]{"No.", "Plot Color", "Title"};
                Object[][] objectArray = this.vwr.selectedPanel.getPanelData().getOverlayLegendData();
                int[] nArray = new int[]{30, 60, 250};
                this.createTable(objectArray, stringArray, nArray);
                this.setTableSelectionEnabled(true);
                break;
            }
        }
    }

    private void createData() {
        switch (this.type) {
            case Integration: {
                this.xyData = new IntegralData(this.spec, this.myParams);
                this.iSelected = -1;
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                try {
                    double d;
                    this.myParams.peakListThreshold = d = Double.parseDouble(this.dialog.getText(this.txt1));
                    this.myParams.peakListInterpolation = this.dialog.getSelectedItem(this.combo1).toString();
                    this.myParams.precision = this.precision;
                    PeakData peakData = new PeakData(Annotation.AType.PeakList, this.spec);
                    peakData.setPeakList(this.myParams, this.precision, this.jsvp.getPanelData().getView());
                    this.xyData = peakData;
                    this.loadData();
                }
                catch (Exception exception) {}
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    private void setPrecision(int n) {
        this.precision = this.formatOptions[n];
    }

    private void tableSelect(String string) {
        boolean bl = "true".equals(this.getField(string, "adjusting"));
        if (bl) {
            this.iRowSelected = -1;
            this.iColSelected = -1;
            System.out.println("adjusting" + string);
            return;
        }
        int n = PT.parseInt(this.getField(string, "index"));
        switch ("ROW COL ROWCOL".indexOf(this.getField(string, "selector"))) {
            case 8: {
                this.iColSelected = PT.parseInt(this.getField(string, "index2"));
            }
            case 0: {
                this.iRowSelected = n;
                System.out.println("r set to " + n);
                break;
            }
            case 4: {
                this.iColSelected = n;
                System.out.println("c set to " + n);
            }
        }
        if (this.iColSelected >= 0 && this.iRowSelected >= 0) {
            this.tableCellSelect(this.iRowSelected, this.iColSelected);
        }
    }

    private String getField(String string, String string2) {
        String string3;
        int n = (string = string + "&").indexOf(string3 = "&" + string2 + "=");
        return n < 0 ? null : string.substring(n + string3.length(), string.indexOf("&", n + 1));
    }
}

