/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;

abstract class Content {
    private static final String URI_SCHEME = "truffle";
    String code;
    private volatile URI uri;
    private static final int[] S = new int[]{41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237, 31, 26, 219, 153, 141, 51, 159, 17, 131, 20};

    Content() {
    }

    abstract String findMimeType() throws IOException;

    abstract Reader getReader() throws IOException;

    abstract String getCode();

    abstract String getName();

    abstract String getShortName();

    abstract Object getHashKey();

    abstract String getPath();

    abstract URL getURL();

    abstract URI getURI();

    void appendCode(CharSequence chars) {
        throw new UnsupportedOperationException();
    }

    public final boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Content other = (Content)obj;
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return this.getHashKey().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final URI createURIOnce(CreateURI cu) {
        if (this.uri == null) {
            Content content = this;
            synchronized (content) {
                if (this.uri == null) {
                    this.uri = cu.createURI();
                }
            }
        }
        return this.uri;
    }

    protected final URI getNamedURI(String name) {
        return this.getNamedURI(name, null, 0, 0);
    }

    protected final URI getNamedURI(String name, byte[] bytes) {
        return this.getNamedURI(name, bytes, 0, bytes.length);
    }

    protected final URI getNamedURI(String name, byte[] bytes, int byteIndex, int length) {
        String digest = bytes != null ? Content.digest(bytes, byteIndex, length) : Integer.toString(System.identityHashCode(this), 16);
        try {
            return new URI(URI_SCHEME, digest + '/' + name, null);
        }
        catch (URISyntaxException ex) {
            throw new Error(ex);
        }
    }

    static String digest(byte[] message, int from, int length) {
        int[] m = new int[19];
        int[] x = new int[48];
        int[] c = new int[16];
        int loop = 1;
        int start = 0;
        int bytes = 0;
        for (int i = 0; i < 16; ++i) {
            c[i] = 0;
            x[i] = 0;
        }
        int last = 0;
        int index = from;
        m[18] = 0;
        m[17] = 0;
        m[16] = 0;
        while (loop == 1) {
            int t;
            int i;
            m[0] = m[16];
            m[1] = m[17];
            m[2] = m[18];
            for (i = 3; i < 16; ++i) {
                m[i] = 0;
            }
            i = start;
            while (index < length && i < 16) {
                int code = message[index];
                if (code < 0) {
                    code += 256;
                }
                m[i++] = code;
                ++index;
            }
            bytes += i - start;
            start = i - 16;
            if (index == length && i < 16) {
                loop = 2;
                t = 16 - (bytes & 0xF);
                while (i < 16) {
                    m[i] = t;
                    ++i;
                }
            }
            for (i = 0; i < 16; ++i) {
                int n = i;
                c[n] = c[n] ^ S[m[i] ^ last];
                last = c[i];
            }
            for (i = 0; i < loop; ++i) {
                int[] mOrC = i == 0 ? m : c;
                x[16] = mOrC[0];
                x[32] = x[16] ^ x[0];
                x[17] = mOrC[1];
                x[33] = x[17] ^ x[1];
                x[18] = mOrC[2];
                x[34] = x[18] ^ x[2];
                x[19] = mOrC[3];
                x[35] = x[19] ^ x[3];
                x[20] = mOrC[4];
                x[36] = x[20] ^ x[4];
                x[21] = mOrC[5];
                x[37] = x[21] ^ x[5];
                x[22] = mOrC[6];
                x[38] = x[22] ^ x[6];
                x[23] = mOrC[7];
                x[39] = x[23] ^ x[7];
                x[24] = mOrC[8];
                x[40] = x[24] ^ x[8];
                x[25] = mOrC[9];
                x[41] = x[25] ^ x[9];
                x[26] = mOrC[10];
                x[42] = x[26] ^ x[10];
                x[27] = mOrC[11];
                x[43] = x[27] ^ x[11];
                x[28] = mOrC[12];
                x[44] = x[28] ^ x[12];
                x[29] = mOrC[13];
                x[45] = x[29] ^ x[13];
                x[30] = mOrC[14];
                x[46] = x[30] ^ x[14];
                x[31] = mOrC[15];
                x[47] = x[31] ^ x[15];
                t = 0;
                for (int j = 0; j < 18; ++j) {
                    for (int k = 0; k < 48; ++k) {
                        x[k] = t = x[k] ^ S[t];
                    }
                    t = t + j & 0xFF;
                }
            }
        }
        StringBuilder result = new StringBuilder(32);
        for (int i = 0; i < 16; ++i) {
            String hex = Integer.toHexString(x[i]);
            if (result.length() == 0) {
                if (hex.equals("0")) {
                    continue;
                }
            } else if (hex.length() == 1) {
                result.append("0");
            }
            result.append(hex);
        }
        return result.toString();
    }

    protected static interface CreateURI {
        public URI createURI();
    }
}

