/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsNew
extends JsExpressionImpl.JsExpressionHasArguments {
    private JsExpression constructorExpression;

    public JsNew(JsExpression constructorExpression) {
        this(constructorExpression, new SmartList<JsExpression>());
    }

    public JsNew(JsExpression constructorExpression, List<JsExpression> arguments2) {
        super(arguments2);
        this.constructorExpression = constructorExpression;
    }

    public JsExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public void setConstructorExpression(JsExpression constructorExpression) {
        this.constructorExpression = constructorExpression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitNew(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.constructorExpression);
        visitor2.acceptList(this.arguments);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.constructorExpression = v.accept(this.constructorExpression);
            v.acceptList(this.arguments);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsNew deepCopy() {
        JsExpression constructorCopy = AstUtil.deepCopy(this.constructorExpression);
        List<JsExpression> argumentsCopy = AstUtil.deepCopy(this.arguments);
        JsNew jsNew = new JsNew(constructorCopy, argumentsCopy).withMetadataFrom(this);
        if (jsNew == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsNew", "deepCopy"));
        }
        return jsNew;
    }
}

