/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

public class CharStack {
    private char[] data = new char[this.maxCapacity];
    private float loadFactor = 1.75f;
    private int maxCapacity = 10;
    private int stackPointer = -1;

    public synchronized boolean isEmpty() {
        return this.stackPointer == -1;
    }

    public synchronized void clear() {
        this.stackPointer = -1;
    }

    public synchronized char peek() throws IllegalStateException {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.data[this.stackPointer];
    }

    public synchronized char pop() throws IllegalStateException {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.data[this.stackPointer--];
    }

    public synchronized void push(char c) {
        if (this.stackPointer >= this.maxCapacity - 1) {
            int n = (int)((float)this.maxCapacity * this.loadFactor);
            char[] cArray = new char[n];
            System.arraycopy(this.data, 0, cArray, 0, this.data.length);
            this.data = cArray;
            this.maxCapacity = n;
            cArray = null;
        }
        this.data[++this.stackPointer] = c;
    }
}

