/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.main;

import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class RestMainAction
extends BaseRestHandler {
    private final Version version;
    private final ClusterName clusterName;
    private final ClusterService clusterService;

    @Inject
    public RestMainAction(Settings settings, Version version, RestController controller, ClusterName clusterName, Client client, ClusterService clusterService) {
        super(settings, controller, client);
        this.version = version;
        this.clusterName = clusterName;
        this.clusterService = clusterService;
        controller.registerHandler(RestRequest.Method.GET, "/", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        RestStatus status = RestStatus.OK;
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.blocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE)) {
            status = RestStatus.SERVICE_UNAVAILABLE;
        }
        if (request.method() == RestRequest.Method.HEAD) {
            channel.sendResponse(new BytesRestResponse(status));
            return;
        }
        XContentBuilder builder = channel.newBuilder();
        if (!request.hasParam("pretty")) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.startObject();
        if (this.settings.get("name") != null) {
            builder.field("name", this.settings.get("name"));
        }
        builder.field("cluster_name", this.clusterName.value());
        builder.field("cluster_uuid", clusterState.metaData().clusterUUID());
        builder.startObject("version").field("number", this.version.number()).field("build_hash", Build.CURRENT.hash()).field("build_timestamp", Build.CURRENT.timestamp()).field("build_snapshot", (Object)this.version.snapshot).field("lucene_version", this.version.luceneVersion.toString()).endObject();
        builder.field("tagline", "You Know, for Search");
        builder.endObject();
        channel.sendResponse(new BytesRestResponse(status, builder));
    }
}

