/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.findDocComment.FindDocCommentKt;

public abstract class KtDeclarationImpl
extends KtExpressionImpl
implements KtDeclaration {
    public KtDeclarationImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public KtModifierList getModifierList() {
        return (KtModifierList)this.findChildByType(KtNodeTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(@NotNull KtModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "hasModifier"));
        }
        KtModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "addModifier"));
        }
        AddRemoveModifierKt.addModifier(this, modifier);
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "removeModifier"));
        }
        AddRemoveModifierKt.removeModifier(this, modifier);
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
        if (annotationEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntry", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "addAnnotationEntry"));
        }
        KtAnnotationEntry ktAnnotationEntry = AddRemoveModifierKt.addAnnotationEntry(this, annotationEntry);
        if (ktAnnotationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "addAnnotationEntry"));
        }
        return ktAnnotationEntry;
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getAnnotationEntries() {
        KtModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<KtAnnotationEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "getAnnotationEntries"));
            }
            return list2;
        }
        List<KtAnnotationEntry> list3 = modifierList.getAnnotationEntries();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "getAnnotationEntries"));
        }
        return list3;
    }

    @Override
    @NotNull
    public List<KtAnnotation> getAnnotations() {
        KtModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<KtAnnotation> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "getAnnotations"));
            }
            return list2;
        }
        List<KtAnnotation> list3 = modifierList.getAnnotations();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtDeclarationImpl", "getAnnotations"));
        }
        return list3;
    }

    @Override
    @Nullable
    public KDoc getDocComment() {
        return FindDocCommentKt.findDocComment(this);
    }
}

