/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportReplicationAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    private static final String OP_TYPE_UPDATE = "update";
    private static final String OP_TYPE_DELETE = "delete";
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private final UpdateHelper updateHelper;
    private final boolean allowIdGeneration;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, mappingUpdatedAction, actionFilters, indexNameExpressionResolver, BulkShardRequest.class, BulkShardRequest.class, "bulk");
        this.updateHelper = updateHelper;
        this.allowIdGeneration = settings.getAsBoolean("action.allow_id_generation", (Boolean)true);
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    protected Tuple<BulkShardResponse, BulkShardRequest> shardOperationOnPrimary(MetaData metaData, BulkShardRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId().id());
        long[] preVersions = new long[request.items().length];
        VersionType[] preVersionTypes = new VersionType[request.items().length];
        Translog.Location location = null;
        for (int requestIndex = 0; requestIndex < request.items().length; ++requestIndex) {
            BulkItemRequest item;
            block51: {
                item = request.items()[requestIndex];
                item.request().copyContextAndHeadersFrom(request);
                if (item.request() instanceof IndexRequest) {
                    IndexRequest indexRequest = (IndexRequest)item.request();
                    preVersions[requestIndex] = indexRequest.version();
                    preVersionTypes[requestIndex] = indexRequest.versionType();
                    try {
                        TransportReplicationAction.WriteResult<IndexResponse> result = this.shardIndexOperation(request, indexRequest, metaData, indexShard, true);
                        location = this.locationToSync(location, result.location);
                        IndexResponse indexResponse = result.response();
                        this.setResponse(item, new BulkItemResponse(item.id(), indexRequest.opType().lowercase(), indexResponse));
                    }
                    catch (Throwable e) {
                        if (this.retryPrimaryException(e)) {
                            for (int j = 0; j < requestIndex; ++j) {
                                this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                            }
                            throw (ElasticsearchException)e;
                        }
                        if (ExceptionsHelper.status(e) == RestStatus.CONFLICT) {
                            this.logger.trace("{} failed to execute bulk item (index) {}", e, request.shardId(), indexRequest);
                        } else {
                            this.logger.debug("{} failed to execute bulk item (index) {}", e, request.shardId(), indexRequest);
                        }
                        if (item.getPrimaryResponse() != null && this.isConflictException(e)) {
                            this.setResponse(item, item.getPrimaryResponse());
                            break block51;
                        }
                        this.setResponse(item, new BulkItemResponse(item.id(), indexRequest.opType().lowercase(), new BulkItemResponse.Failure(request.index(), indexRequest.type(), indexRequest.id(), e)));
                    }
                } else if (item.request() instanceof DeleteRequest) {
                    DeleteRequest deleteRequest = (DeleteRequest)item.request();
                    preVersions[requestIndex] = deleteRequest.version();
                    preVersionTypes[requestIndex] = deleteRequest.versionType();
                    try {
                        TransportReplicationAction.WriteResult<DeleteResponse> writeResult = TransportDeleteAction.executeDeleteRequestOnPrimary(deleteRequest, indexShard);
                        DeleteResponse deleteResponse = writeResult.response();
                        location = this.locationToSync(location, writeResult.location);
                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, deleteResponse));
                    }
                    catch (Throwable e) {
                        if (this.retryPrimaryException(e)) {
                            for (int j = 0; j < requestIndex; ++j) {
                                this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                            }
                            throw (ElasticsearchException)e;
                        }
                        if (ExceptionsHelper.status(e) == RestStatus.CONFLICT) {
                            this.logger.trace("{} failed to execute bulk item (delete) {}", e, request.shardId(), deleteRequest);
                        } else {
                            this.logger.debug("{} failed to execute bulk item (delete) {}", e, request.shardId(), deleteRequest);
                        }
                        if (item.getPrimaryResponse() != null && this.isConflictException(e)) {
                            this.setResponse(item, item.getPrimaryResponse());
                            break block51;
                        }
                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, new BulkItemResponse.Failure(request.index(), deleteRequest.type(), deleteRequest.id(), e)));
                    }
                } else if (item.request() instanceof UpdateRequest) {
                    UpdateRequest updateRequest = (UpdateRequest)item.request();
                    preVersions[requestIndex] = updateRequest.version();
                    preVersionTypes[requestIndex] = updateRequest.versionType();
                    for (int updateAttemptsCount = 0; updateAttemptsCount <= updateRequest.retryOnConflict(); ++updateAttemptsCount) {
                        IndexRequest indexRequest;
                        UpdateResult updateResult;
                        try {
                            updateResult = this.shardUpdateOperation(metaData, request, updateRequest, indexShard);
                        }
                        catch (Throwable t) {
                            updateResult = new UpdateResult(null, null, false, t, null);
                        }
                        if (updateResult.success()) {
                            if (updateResult.writeResult != null) {
                                location = this.locationToSync(location, updateResult.writeResult.location);
                            }
                            switch (updateResult.result.operation()) {
                                case UPSERT: 
                                case INDEX: {
                                    TransportReplicationAction.WriteResult result = updateResult.writeResult;
                                    indexRequest = (IndexRequest)updateResult.request();
                                    BytesReference indexSourceAsBytes = indexRequest.source();
                                    IndexResponse indexResponse = (IndexResponse)result.response();
                                    UpdateResponse updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getIndex(), indexResponse.getType(), indexResponse.getId(), indexResponse.getVersion(), indexResponse.isCreated());
                                    if (updateRequest.fields() != null && updateRequest.fields().length > 0) {
                                        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true);
                                        updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, request.index(), indexResponse.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), indexSourceAsBytes));
                                    }
                                    BulkItemRequest bulkItemRequest = new BulkItemRequest(request.items()[requestIndex].id(), indexRequest);
                                    request.items()[requestIndex] = bulkItemRequest;
                                    item = bulkItemRequest;
                                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResponse));
                                    break;
                                }
                                case DELETE: {
                                    TransportReplicationAction.WriteResult writeResult = updateResult.writeResult;
                                    DeleteResponse response = (DeleteResponse)writeResult.response();
                                    DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                                    UpdateResponse updateResponse = new UpdateResponse(response.getShardInfo(), response.getIndex(), response.getType(), response.getId(), response.getVersion(), false);
                                    updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, request.index(), response.getVersion(), updateResult.result.updatedSourceAsMap(), updateResult.result.updateSourceContentType(), null));
                                    BulkItemRequest bulkItemRequest = new BulkItemRequest(request.items()[requestIndex].id(), deleteRequest);
                                    request.items()[requestIndex] = bulkItemRequest;
                                    item = bulkItemRequest;
                                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResponse));
                                    break;
                                }
                                case NONE: {
                                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResult.noopResult));
                                    item.setIgnoreOnReplica();
                                }
                            }
                        } else {
                            if (!updateResult.failure()) continue;
                            t = updateResult.error;
                            if (updateResult.retry) {
                                if (updateAttemptsCount < updateRequest.retryOnConflict()) continue;
                                this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), updateRequest.type(), updateRequest.id(), t)));
                                continue;
                            }
                            if (this.retryPrimaryException(t)) {
                                for (int j = 0; j < requestIndex; ++j) {
                                    this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                                }
                                throw (ElasticsearchException)t;
                            }
                            if (item.getPrimaryResponse() != null && this.isConflictException(t)) {
                                this.setResponse(item, item.getPrimaryResponse());
                            } else if (updateResult.result == null) {
                                this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), updateRequest.type(), updateRequest.id(), t)));
                            } else {
                                switch (updateResult.result.operation()) {
                                    case UPSERT: 
                                    case INDEX: {
                                        indexRequest = (IndexRequest)updateResult.request();
                                        if (ExceptionsHelper.status(t) == RestStatus.CONFLICT) {
                                            this.logger.trace("{} failed to execute bulk item (index) {}", t, request.shardId(), indexRequest);
                                        } else {
                                            this.logger.debug("{} failed to execute bulk item (index) {}", t, request.shardId(), indexRequest);
                                        }
                                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), indexRequest.type(), indexRequest.id(), t)));
                                        break;
                                    }
                                    case DELETE: {
                                        DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                                        if (ExceptionsHelper.status(t) == RestStatus.CONFLICT) {
                                            this.logger.trace("{} failed to execute bulk item (delete) {}", t, request.shardId(), deleteRequest);
                                        } else {
                                            this.logger.debug("{} failed to execute bulk item (delete) {}", t, request.shardId(), deleteRequest);
                                        }
                                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, new BulkItemResponse.Failure(request.index(), deleteRequest.type(), deleteRequest.id(), t)));
                                    }
                                }
                            }
                        }
                        break;
                    }
                } else {
                    throw new IllegalStateException("Unexpected index operation: " + item.request());
                }
            }
            assert (item.getPrimaryResponse() != null);
            assert (preVersionTypes[requestIndex] != null);
        }
        this.processAfterWrite(request.refresh(), indexShard, location);
        BulkItemResponse[] responses = new BulkItemResponse[request.items().length];
        BulkItemRequest[] items = request.items();
        for (int i = 0; i < items.length; ++i) {
            responses[i] = items[i].getPrimaryResponse();
        }
        return new Tuple<BulkShardResponse, BulkShardRequest>(new BulkShardResponse(request.shardId(), responses), request);
    }

    private void setResponse(BulkItemRequest request, BulkItemResponse response) {
        request.setPrimaryResponse(response);
        if (response.isFailed()) {
            request.setIgnoreOnReplica();
        }
    }

    private TransportReplicationAction.WriteResult<IndexResponse> shardIndexOperation(BulkShardRequest request, IndexRequest indexRequest, MetaData metaData, IndexShard indexShard, boolean processed) throws Throwable {
        MappingMetaData mappingMd = metaData.index(request.index()).mappingOrDefault(indexRequest.type());
        if (mappingMd != null && mappingMd.routing().required() && indexRequest.routing() == null) {
            throw new RoutingMissingException(request.index(), indexRequest.type(), indexRequest.id());
        }
        if (!processed) {
            indexRequest.process(metaData, mappingMd, this.allowIdGeneration, request.index());
        }
        return TransportIndexAction.executeIndexRequestOnPrimary(request, indexRequest, indexShard, this.mappingUpdatedAction);
    }

    private UpdateResult shardUpdateOperation(MetaData metaData, BulkShardRequest bulkShardRequest, UpdateRequest updateRequest, IndexShard indexShard) {
        UpdateHelper.Result translate = this.updateHelper.prepare(updateRequest, indexShard);
        switch (translate.operation()) {
            case UPSERT: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)translate.action();
                try {
                    TransportReplicationAction.WriteResult<IndexResponse> result = this.shardIndexOperation(bulkShardRequest, indexRequest, metaData, indexShard, false);
                    return new UpdateResult(translate, indexRequest, result);
                }
                catch (Throwable t) {
                    t = ExceptionsHelper.unwrapCause(t);
                    boolean retry = false;
                    if (t instanceof VersionConflictEngineException || t instanceof DocumentAlreadyExistsException && translate.operation() == UpdateHelper.Operation.UPSERT) {
                        retry = true;
                    }
                    return new UpdateResult(translate, indexRequest, retry, t, null);
                }
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)translate.action();
                try {
                    TransportReplicationAction.WriteResult<DeleteResponse> result = TransportDeleteAction.executeDeleteRequestOnPrimary(deleteRequest, indexShard);
                    return new UpdateResult(translate, deleteRequest, result);
                }
                catch (Throwable t) {
                    t = ExceptionsHelper.unwrapCause(t);
                    boolean retry = false;
                    if (t instanceof VersionConflictEngineException) {
                        retry = true;
                    }
                    return new UpdateResult(translate, deleteRequest, retry, t, null);
                }
            }
            case NONE: {
                UpdateResponse updateResponse = (UpdateResponse)translate.action();
                indexShard.indexingService().noopUpdate(updateRequest.type());
                return new UpdateResult(translate, updateResponse);
            }
        }
        throw new IllegalStateException("Illegal update operation " + (Object)((Object)translate.operation()));
    }

    @Override
    protected void shardOperationOnReplica(BulkShardRequest request) {
        ShardId shardId = request.shardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.shardSafe(shardId.id());
        Translog.Location location = null;
        for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            if (item == null || item.isIgnoreOnReplica()) continue;
            if (item.request() instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)item.request();
                try {
                    Engine.IndexingOperation operation = TransportIndexAction.executeIndexRequestOnReplica(indexRequest, indexShard);
                    location = this.locationToSync(location, operation.getTranslogLocation());
                    continue;
                }
                catch (Throwable e) {
                    if (this.ignoreReplicaException(e)) continue;
                    throw e;
                }
            }
            if (item.request() instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)item.request();
                try {
                    Engine.Delete delete = TransportDeleteAction.executeDeleteRequestOnReplica(deleteRequest, indexShard);
                    location = this.locationToSync(location, delete.getTranslogLocation());
                    continue;
                }
                catch (Throwable e) {
                    if (this.ignoreReplicaException(e)) continue;
                    throw e;
                }
            }
            throw new IllegalStateException("Unexpected index operation: " + item.request());
        }
        this.processAfterWrite(request.refresh(), indexShard, location);
    }

    private void applyVersion(BulkItemRequest item, long version, VersionType versionType) {
        if (item.request() instanceof IndexRequest) {
            ((IndexRequest)item.request()).version(version).versionType(versionType);
        } else if (item.request() instanceof DeleteRequest) {
            ((DeleteRequest)item.request()).version(version).versionType();
        } else if (item.request() instanceof UpdateRequest) {
            ((UpdateRequest)item.request()).version(version).versionType();
        }
    }

    private Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    static class UpdateResult {
        final UpdateHelper.Result result;
        final ActionRequest actionRequest;
        final boolean retry;
        final Throwable error;
        final TransportReplicationAction.WriteResult writeResult;
        final UpdateResponse noopResult;

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, boolean retry, Throwable error, TransportReplicationAction.WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.retry = retry;
            this.error = error;
            this.writeResult = writeResult;
            this.noopResult = null;
        }

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, TransportReplicationAction.WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.writeResult = writeResult;
            this.retry = false;
            this.error = null;
            this.noopResult = null;
        }

        public UpdateResult(UpdateHelper.Result result, UpdateResponse updateResponse) {
            this.result = result;
            this.noopResult = updateResponse;
            this.actionRequest = null;
            this.writeResult = null;
            this.retry = false;
            this.error = null;
        }

        boolean failure() {
            return this.error != null;
        }

        boolean success() {
            return this.noopResult != null || this.writeResult != null;
        }

        <T extends ActionRequest> T request() {
            return (T)this.actionRequest;
        }
    }
}

