/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.binding.ClassInitializer;
import org.jruby.javasupport.binding.ConstantField;
import org.jruby.javasupport.binding.ConstructorInvokerInstaller;
import org.jruby.javasupport.binding.InstanceFieldGetterInstaller;
import org.jruby.javasupport.binding.InstanceFieldSetterInstaller;
import org.jruby.javasupport.binding.InterfaceInitializer;
import org.jruby.javasupport.binding.MethodInstaller;
import org.jruby.javasupport.binding.NamedInstaller;
import org.jruby.javasupport.binding.Priority;
import org.jruby.javasupport.binding.SingletonMethodInvokerInstaller;
import org.jruby.javasupport.binding.StaticFieldGetterInstaller;
import org.jruby.javasupport.binding.StaticFieldSetterInstaller;
import org.jruby.javasupport.binding.StaticMethodInvokerInstaller;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IdUtil;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class Initializer {
    protected final Ruby runtime;
    protected final JavaSupport javaSupport;
    protected final Class javaClass;
    private static final Logger LOG = LoggerFactory.getLogger(Initializer.class);
    private static final int ACC_BRIDGE = 64;
    public static final boolean DEBUG_SCALA = false;
    public static final String METHOD_MANGLE = "__method";
    private static final Map<String, String> SCALA_OPERATORS;
    protected static final Map<String, AssignedName> STATIC_RESERVED_NAMES;
    protected static final Map<String, AssignedName> INSTANCE_RESERVED_NAMES;
    public static final ClassValue<Method[]> DECLARED_METHODS;
    public static final ClassValue<Method[]> METHODS;
    public static final ClassValue<Class<?>[]> INTERFACES;

    private static Map<String, AssignedName> newReservedNamesMap(int size2) {
        HashMap<String, AssignedName> RESERVED_NAMES = new HashMap<String, AssignedName>(size2 + 4, 1.0f);
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", Priority.RESERVED));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", Priority.RESERVED));
        RESERVED_NAMES.put("instance_of?", new AssignedName("instance_of?", Priority.RESERVED));
        return RESERVED_NAMES;
    }

    public Initializer(Ruby runtime, Class javaClass) {
        this.runtime = runtime;
        this.javaSupport = runtime.getJavaSupport();
        this.javaClass = javaClass;
    }

    public static RubyModule setupProxyClass(Ruby runtime, Class<?> javaClass, RubyClass proxy2) {
        Initializer.setJavaClassFor(javaClass, proxy2);
        proxy2.setReifiedClass(javaClass);
        if (javaClass.isArray()) {
            Initializer.flagAsJavaProxy(proxy2);
            return proxy2;
        }
        if (javaClass.isPrimitive()) {
            RubyClass proxySingleton = proxy2.getSingletonClass();
            proxySingleton.undefineMethod("new");
            if (javaClass == Void.TYPE) {
                proxySingleton.undefineMethod("[]");
                proxySingleton.undefineMethod("new_array");
            }
            Initializer.flagAsJavaProxy(proxy2);
            return proxy2;
        }
        proxy2 = new ClassInitializer(runtime, javaClass).initialize(proxy2);
        Initializer.flagAsJavaProxy(proxy2);
        return proxy2;
    }

    public static RubyModule setupProxyModule(Ruby runtime, Class<?> javaClass, RubyModule proxy2) {
        Initializer.setJavaClassFor(javaClass, proxy2);
        assert (javaClass.isInterface());
        proxy2 = new InterfaceInitializer(runtime, javaClass).initialize(proxy2);
        Initializer.flagAsJavaProxy(proxy2);
        return proxy2;
    }

    private static void flagAsJavaProxy(RubyModule proxy2) {
        proxy2.setJavaProxy(true);
        proxy2.getSingletonClass().setJavaProxy(true);
    }

    protected static void addField(Map<String, NamedInstaller> callbacks, Map<String, AssignedName> names2, Field field2, boolean isFinal, boolean isStatic) {
        String name2 = field2.getName();
        if (Priority.FIELD.lessImportantThan(names2.get(name2))) {
            return;
        }
        names2.put(name2, new AssignedName(name2, Priority.FIELD));
        callbacks.put(name2, isStatic ? new StaticFieldGetterInstaller(name2, field2) : new InstanceFieldGetterInstaller(name2, field2));
        if (!isFinal) {
            String setName2 = name2 + '=';
            callbacks.put(setName2, isStatic ? new StaticFieldSetterInstaller(setName2, field2) : new InstanceFieldSetterInstaller(setName2, field2));
        }
    }

    protected static void prepareStaticMethod(Class<?> javaClass, State state2, Method method, String name2) {
        AssignedName assignedName = state2.staticNames.get(name2);
        if (STATIC_RESERVED_NAMES.containsKey(method.getName())) {
            Initializer.setupStaticMethods(state2.staticInstallers, javaClass, method, name2 + METHOD_MANGLE);
            return;
        }
        if (assignedName == null) {
            state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
        } else {
            if (Priority.METHOD.lessImportantThan(assignedName)) {
                return;
            }
            if (!Priority.METHOD.asImportantAs(assignedName)) {
                state2.staticInstallers.remove(name2);
                state2.staticInstallers.remove(name2 + '=');
                state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
            }
        }
        Initializer.setupStaticMethods(state2.staticInstallers, javaClass, method, name2);
    }

    private static void setupStaticMethods(Map<String, NamedInstaller> methodCallbacks, Class<?> javaClass, Method method, String name2) {
        MethodInstaller invoker = (MethodInstaller)methodCallbacks.get(name2);
        if (invoker == null) {
            invoker = new StaticMethodInvokerInstaller(name2);
            methodCallbacks.put(name2, invoker);
        }
        invoker.addMethod(method, javaClass);
    }

    protected static void assignStaticAliases(State state2) {
        for (Map.Entry<String, NamedInstaller> entry : state2.staticInstallers.entrySet()) {
            if (entry.getKey().endsWith(METHOD_MANGLE) || entry.getValue().type != 2 || !entry.getValue().hasLocalMethod()) continue;
            Initializer.assignAliases((MethodInstaller)entry.getValue(), state2.staticNames);
        }
    }

    protected static void assignAliases(MethodInstaller installer, Map<String, AssignedName> assignedNames) {
        String name2 = installer.name;
        String rubyCasedName = JavaUtil.getRubyCasedName(name2);
        Initializer.addUnassignedAlias(rubyCasedName, assignedNames, installer);
        String javaPropertyName = JavaUtil.getJavaPropertyName(name2);
        String rubyPropertyName = null;
        for (Method method : installer.methods) {
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (rubyCasedName.equals("apply")) {
                Initializer.addUnassignedAlias("[]", assignedNames, installer);
            }
            if (rubyCasedName.equals("update") && argCount == 2) {
                Initializer.addUnassignedAlias("[]=", assignedNames, installer);
            }
            if (name2.startsWith("$")) {
                Initializer.addUnassignedAlias(ClassInitializer.fixScalaNames(name2), assignedNames, installer);
            }
            if (javaPropertyName != null) {
                if (rubyCasedName.startsWith("get_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 0) {
                        Initializer.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        Initializer.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("set_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 1 && resultType == Void.TYPE) {
                        Initializer.addUnassignedAlias(javaPropertyName + '=', assignedNames, installer);
                        Initializer.addUnassignedAlias(rubyPropertyName + '=', assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("is_")) {
                    rubyPropertyName = rubyCasedName.substring(3);
                    if (resultType == Boolean.TYPE) {
                        Initializer.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        Initializer.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                }
            }
            if (resultType != Boolean.TYPE) continue;
            Initializer.addUnassignedAlias(rubyCasedName + '?', assignedNames, installer);
            if (rubyPropertyName == null) continue;
            Initializer.addUnassignedAlias(rubyPropertyName + '?', assignedNames, installer);
        }
    }

    private static void addUnassignedAlias(String name2, Map<String, AssignedName> assignedNames, MethodInstaller installer) {
        if (name2 == null) {
            return;
        }
        AssignedName assignedName = assignedNames.get(name2);
        if (Priority.ALIAS.moreImportantThan(assignedName)) {
            installer.addAlias(name2);
            assignedNames.put(name2, new AssignedName(name2, Priority.ALIAS));
        } else if (Priority.ALIAS.asImportantAs(assignedName)) {
            installer.addAlias(name2);
        }
    }

    protected static String fixScalaNames(String name2) {
        String s2 = name2;
        for (Map.Entry<String, String> entry : SCALA_OPERATORS.entrySet()) {
            s2 = s2.replaceAll(entry.getKey(), entry.getValue());
        }
        return s2;
    }

    protected static void handleScalaSingletons(Class<?> javaClass, State state2) {
        try {
            ClassLoader loader = javaClass.getClassLoader();
            if (loader == null) {
                return;
            }
            Annotation[] annotations2 = javaClass.getAnnotations();
            boolean foundScala = false;
            for (int i2 = 0; i2 < annotations2.length; ++i2) {
                if (!annotations2[i2].annotationType().getPackage().getName().startsWith("scala.")) continue;
                foundScala = true;
            }
            if (!foundScala) {
                return;
            }
            Class<?> companionClass = loader.loadClass(javaClass.getName() + '$');
            Field field2 = companionClass.getField("MODULE$");
            Object singleton = field2.get(null);
            if (singleton == null) {
                return;
            }
            Map<String, List<Method>> scalaMethods = Initializer.getMethods(companionClass);
            for (List<Method> methods2 : scalaMethods.values()) {
                for (int j = 0; j < methods2.size(); ++j) {
                    Method method = methods2.get(j);
                    String name2 = method.getName();
                    if (name2.indexOf(36) >= 0) {
                        name2 = Initializer.fixScalaNames(name2);
                    }
                    if (Modifier.isStatic(method.getModifiers())) continue;
                    AssignedName assignedName = state2.staticNames.get(name2);
                    if (INSTANCE_RESERVED_NAMES.containsKey(method.getName())) {
                        Initializer.setupSingletonMethods(state2.staticInstallers, javaClass, singleton, method, name2 + METHOD_MANGLE);
                        continue;
                    }
                    if (assignedName == null) {
                        state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
                    } else {
                        if (Priority.METHOD.lessImportantThan(assignedName)) continue;
                        if (!Priority.METHOD.asImportantAs(assignedName)) {
                            state2.staticInstallers.remove(name2);
                            state2.staticInstallers.remove(name2 + '=');
                            state2.staticNames.put(name2, new AssignedName(name2, Priority.METHOD));
                        }
                    }
                    Initializer.setupSingletonMethods(state2.staticInstallers, javaClass, singleton, method, name2);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private static void setupSingletonMethods(Map<String, NamedInstaller> methodCallbacks, Class<?> javaClass, Object singleton, Method method, String name2) {
        MethodInstaller invoker = (MethodInstaller)methodCallbacks.get(name2);
        if (invoker == null) {
            invoker = new SingletonMethodInvokerInstaller(name2, singleton);
            methodCallbacks.put(name2, invoker);
        }
        invoker.addMethod(method, javaClass);
    }

    protected static void installClassFields(RubyModule proxy2, State state2) {
        for (ConstantField field2 : state2.constantFields) {
            field2.install(proxy2);
        }
    }

    protected static void installClassStaticMethods(RubyModule proxy2, State state2) {
        for (Map.Entry<String, NamedInstaller> entry : state2.staticInstallers.entrySet()) {
            entry.getValue().install(proxy2);
        }
    }

    protected static void installClassClasses(Class<?> javaClass, RubyModule proxy2) {
        Class<?>[] classes2 = JavaClass.getDeclaredClasses(javaClass);
        Ruby runtime = proxy2.getRuntime();
        int i2 = classes2.length;
        while (--i2 >= 0) {
            String simpleName;
            Class<?> clazz = classes2[i2];
            if (javaClass != clazz.getDeclaringClass() || !Modifier.isPublic(clazz.getModifiers()) || (simpleName = JavaClass.getSimpleName(clazz)).length() == 0) continue;
            final RubyModule innerProxy = Java.getProxyClass(runtime, JavaClass.get(runtime, clazz));
            if (IdUtil.isConstant(simpleName)) {
                if (proxy2.getConstantAt(simpleName) != null) continue;
                proxy2.const_set(runtime.newString(simpleName), innerProxy);
                continue;
            }
            if (proxy2.respondsTo(simpleName)) continue;
            proxy2.getSingletonClass().addMethod(simpleName, new JavaMethod.JavaMethodZero((RubyModule)proxy2.getSingletonClass(), Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                    return innerProxy;
                }
            });
        }
    }

    private static void setJavaClassFor(Class<?> javaClass, RubyModule proxy2) {
        proxy2.setInstanceVariable("@java_class", proxy2.getRuntime().getJavaSupport().getJavaClassFromCache(javaClass));
        proxy2.dataWrapStruct(javaClass);
    }

    public abstract RubyModule initialize(RubyModule var1);

    static Map<String, List<Method>> getMethods(Class<?> javaClass) {
        HashMap<String, List<Method>> nameMethods = new HashMap<String, List<Method>>(32);
        int totalMethods = 0;
        for (Class<?> klass = javaClass; klass != null; klass = klass.getSuperclass()) {
            if (Modifier.isPublic(klass.getModifiers()) || JavaUtil.CAN_SET_ACCESSIBLE) {
                try {
                    totalMethods += Initializer.addNewMethods(nameMethods, DECLARED_METHODS.get(klass), klass == javaClass, true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            for (Class<?> iface : INTERFACES.get(klass)) {
                try {
                    totalMethods += Initializer.addNewMethods(nameMethods, METHODS.get(iface), false, false);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return nameMethods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean methodsAreEquivalent(Method child, Method parent) {
        if (!parent.getDeclaringClass().isAssignableFrom(child.getDeclaringClass())) return false;
        if (child.getReturnType() != parent.getReturnType()) return false;
        if (child.isVarArgs() != parent.isVarArgs()) return false;
        int childModifiers = child.getModifiers();
        int parentModifiers = parent.getModifiers();
        if (Modifier.isPublic(childModifiers) != Modifier.isPublic(parentModifiers)) return false;
        if (Modifier.isProtected(childModifiers) != Modifier.isProtected(parentModifiers)) return false;
        if (Modifier.isStatic(childModifiers) != Modifier.isStatic(parentModifiers)) return false;
        if (!Arrays.equals(child.getParameterTypes(), parent.getParameterTypes())) return false;
        return true;
    }

    private static int addNewMethods(HashMap<String, List<Method>> nameMethods, Method[] methods2, boolean includeStatic, boolean removeDuplicate) {
        int added = 0;
        block0: for (Method method : methods2) {
            int mod = method.getModifiers();
            if (Modifier.isPrivate(mod) || (mod & 0x40) != 0 || !includeStatic && Modifier.isStatic(mod)) continue;
            List<Method> childMethods = nameMethods.get(method.getName());
            if (childMethods == null) {
                childMethods = new ArrayList<Method>(4);
                childMethods.add(method);
                ++added;
                nameMethods.put(method.getName(), childMethods);
                continue;
            }
            for (int i2 = 0; i2 < childMethods.size(); ++i2) {
                Method current2 = childMethods.get(i2);
                if (!Initializer.methodsAreEquivalent(current2, method)) continue;
                if (!removeDuplicate) continue block0;
                childMethods.set(i2, method);
                continue block0;
            }
            childMethods.add(method);
            ++added;
        }
        return added;
    }

    static {
        STATIC_RESERVED_NAMES = Initializer.newReservedNamesMap(1);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", Priority.RESERVED));
        INSTANCE_RESERVED_NAMES = Initializer.newReservedNamesMap(2);
        INSTANCE_RESERVED_NAMES.put("class", new AssignedName("class", Priority.RESERVED));
        INSTANCE_RESERVED_NAMES.put("initialize", new AssignedName("initialize", Priority.RESERVED));
        HashMap<String, String> scalaOperators = new HashMap<String, String>();
        scalaOperators.put("\\$plus", "+");
        scalaOperators.put("\\$minus", "-");
        scalaOperators.put("\\$colon", ":");
        scalaOperators.put("\\$div", "/");
        scalaOperators.put("\\$eq", "=");
        scalaOperators.put("\\$less", "<");
        scalaOperators.put("\\$greater", ">");
        scalaOperators.put("\\$bslash", "\\\\");
        scalaOperators.put("\\$hash", "#");
        scalaOperators.put("\\$times", "*");
        scalaOperators.put("\\$bang", "!");
        scalaOperators.put("\\$at", "@");
        scalaOperators.put("\\$percent", "%");
        scalaOperators.put("\\$up", "^");
        scalaOperators.put("\\$amp", "&");
        scalaOperators.put("\\$tilde", "~");
        scalaOperators.put("\\$qmark", "?");
        scalaOperators.put("\\$bar", "|");
        SCALA_OPERATORS = Collections.unmodifiableMap(scalaOperators);
        DECLARED_METHODS = new ClassValue<Method[]>(){

            @Override
            public Method[] computeValue(Class cls) {
                return cls.getDeclaredMethods();
            }
        };
        METHODS = new ClassValue<Method[]>(){

            @Override
            public Method[] computeValue(Class cls) {
                return cls.getMethods();
            }
        };
        INTERFACES = new ClassValue<Class<?>[]>(){

            @Override
            public Class<?>[] computeValue(Class cls) {
                return cls.getInterfaces();
            }
        };
    }

    public static class State {
        final Map<String, AssignedName> staticNames;
        final Map<String, AssignedName> instanceNames;
        final Map<String, NamedInstaller> staticInstallers = new HashMap<String, NamedInstaller>();
        final Map<String, NamedInstaller> instanceInstallers = new HashMap<String, NamedInstaller>();
        final List<ConstantField> constantFields = new ArrayList<ConstantField>();
        ConstructorInvokerInstaller constructorInstaller;

        State(Ruby runtime, Class superClass) {
            if (superClass == null) {
                this.staticNames = new HashMap<String, AssignedName>();
                this.instanceNames = new HashMap<String, AssignedName>();
            } else {
                this.staticNames = new HashMap<String, AssignedName>(runtime.getJavaSupport().getStaticAssignedNames().get(superClass));
                this.instanceNames = new HashMap<String, AssignedName>(runtime.getJavaSupport().getInstanceAssignedNames().get(superClass));
            }
            this.staticNames.putAll(STATIC_RESERVED_NAMES);
            this.instanceNames.putAll(INSTANCE_RESERVED_NAMES);
        }
    }
}

