/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.LookupConstantInterface;
import org.jruby.truffle.language.control.RaiseException;

public abstract class LookupConstantWithLexicalScopeNode
extends RubyNode
implements LookupConstantInterface {
    private final LexicalScope lexicalScope;
    private final String name;

    public LookupConstantWithLexicalScopeNode(LexicalScope lexicalScope, String name) {
        this.lexicalScope = lexicalScope;
        this.name = name;
    }

    public DynamicObject getModule() {
        return this.lexicalScope.getLiveModule();
    }

    public abstract RubyConstant executeLookupConstant(VirtualFrame var1);

    @Override
    public RubyConstant lookupConstant(VirtualFrame frame, Object module, String name) {
        assert (name == this.name);
        return this.executeLookupConstant(frame);
    }

    @Specialization(assumptions={"getUnmodifiedAssumption(getModule())"})
    protected RubyConstant lookupConstant(VirtualFrame frame, @Cached(value="doLookup()") RubyConstant constant, @Cached(value="isVisible(constant)") boolean isVisible) {
        if (!isVisible) {
            throw new RaiseException(this.coreExceptions().nameErrorPrivateConstant(this.getModule(), this.name, this));
        }
        return constant;
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    protected RubyConstant doLookup() {
        return ModuleOperations.lookupConstantWithLexicalScope(this.getContext(), this.lexicalScope, this.name);
    }

    protected boolean isVisible(RubyConstant constant) {
        return constant == null || constant.isVisibleTo(this.getContext(), this.lexicalScope, this.getModule());
    }
}

