/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.QueryRescorer;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;

public class RescoreParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                this.parseSingleRescoreContext(parser, context);
            }
        } else {
            this.parseSingleRescoreContext(parser, context);
        }
    }

    public void parseSingleRescoreContext(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        String fieldName = null;
        RescoreSearchContext rescoreContext = null;
        Integer windowSize = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                if (!"query".equals(fieldName)) continue;
                Rescorer rescorer = QueryRescorer.INSTANCE;
                token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("rescore type malformed, must start with start_object", new Object[0]);
                }
                rescoreContext = rescorer.parse(parser, context);
                continue;
            }
            if (!token.isValue()) continue;
            if ("window_size".equals(fieldName)) {
                windowSize = parser.intValue();
                continue;
            }
            throw new IllegalArgumentException("rescore doesn't support [" + fieldName + "]");
        }
        if (rescoreContext == null) {
            throw new IllegalArgumentException("missing rescore type");
        }
        if (windowSize != null) {
            rescoreContext.setWindowSize(windowSize);
        }
        context.addRescore(rescoreContext);
    }
}

