/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.prebuilt;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryResolveException;
import org.gradle.nativeplatform.platform.NativePlatform;

public abstract class AbstractPrebuiltLibraryBinary
implements NativeLibraryBinary {
    private final String name;
    private final PrebuiltLibrary library;
    private final BuildType buildType;
    private final NativePlatform targetPlatform;
    private final Flavor flavor;
    protected final FileCollectionFactory fileCollectionFactory;

    public AbstractPrebuiltLibraryBinary(String name, PrebuiltLibrary library, BuildType buildType, NativePlatform targetPlatform, Flavor flavor, FileCollectionFactory fileCollectionFactory) {
        this.name = name;
        this.library = library;
        this.buildType = buildType;
        this.targetPlatform = targetPlatform;
        this.flavor = flavor;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.name;
    }

    public PrebuiltLibrary getComponent() {
        return this.library;
    }

    @Override
    public BuildType getBuildType() {
        return this.buildType;
    }

    @Override
    public Flavor getFlavor() {
        return this.flavor;
    }

    @Override
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @Override
    public FileCollection getHeaderDirs() {
        return this.fileCollectionFactory.fixed("Headers for " + this.getDisplayName(), (Collection)this.library.getHeaders().getSrcDirs());
    }

    protected FileCollection createFileCollection(File file, String fileCollectionDisplayName, String fileDescription) {
        return this.fileCollectionFactory.create((MinimalFileSet)new ValidatingFileSet(file, fileCollectionDisplayName, fileDescription));
    }

    private class ValidatingFileSet
    implements MinimalFileSet {
        private final File file;
        private final String fileCollectionDisplayName;
        private final String fileDescription;

        private ValidatingFileSet(File file, String fileCollectionDisplayName, String fileDescription) {
            this.file = file;
            this.fileCollectionDisplayName = fileCollectionDisplayName;
            this.fileDescription = fileDescription;
        }

        public String getDisplayName() {
            return this.fileCollectionDisplayName + " for " + AbstractPrebuiltLibraryBinary.this.getDisplayName();
        }

        public Set<File> getFiles() {
            if (this.file == null) {
                throw new PrebuiltLibraryResolveException(String.format("%s not set for %s.", this.fileDescription, AbstractPrebuiltLibraryBinary.this.getDisplayName()));
            }
            if (!this.file.exists() || !this.file.isFile()) {
                throw new PrebuiltLibraryResolveException(String.format("%s %s does not exist for %s.", this.fileDescription, this.file.getAbsolutePath(), AbstractPrebuiltLibraryBinary.this.getDisplayName()));
            }
            return Collections.singleton(this.file);
        }
    }
}

