/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.narayana;

import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class DataSourceXAResourceRecoveryHelper
implements XAResourceRecoveryHelper,
XAResource {
    private static final XAResource[] NO_XA_RESOURCES = new XAResource[0];
    private static final Log logger = LogFactory.getLog(DataSourceXAResourceRecoveryHelper.class);
    private final XADataSource xaDataSource;
    private final String user;
    private final String password;
    private XAConnection xaConnection;
    private XAResource delegate;

    public DataSourceXAResourceRecoveryHelper(XADataSource xaDataSource) {
        this(xaDataSource, null, null);
    }

    public DataSourceXAResourceRecoveryHelper(XADataSource xaDataSource, String user, String password) {
        Assert.notNull((Object)xaDataSource, (String)"XADataSource must not be null");
        this.xaDataSource = xaDataSource;
        this.user = user;
        this.password = password;
    }

    public boolean initialise(String properties) {
        return true;
    }

    public XAResource[] getXAResources() {
        if (this.connect()) {
            return new XAResource[]{this};
        }
        return NO_XA_RESOURCES;
    }

    private boolean connect() {
        if (this.delegate == null) {
            try {
                this.xaConnection = this.getXaConnection();
                this.delegate = this.xaConnection.getXAResource();
            }
            catch (SQLException ex) {
                logger.warn((Object)"Failed to create connection", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private XAConnection getXaConnection() throws SQLException {
        if (this.user == null && this.password == null) {
            return this.xaDataSource.getXAConnection();
        }
        return this.xaDataSource.getXAConnection(this.user, this.password);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            Xid[] xidArray = this.getDelegate(true).recover(flag);
            return xidArray;
        }
        finally {
            if (flag == 0x800000) {
                this.disconnect();
            }
        }
    }

    private void disconnect() throws XAException {
        try {
            this.xaConnection.close();
        }
        catch (SQLException e) {
            logger.warn((Object)"Failed to close connection", (Throwable)e);
        }
        finally {
            this.xaConnection = null;
            this.delegate = null;
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.getDelegate(true).start(xid, flags);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.getDelegate(true).end(xid, flags);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.getDelegate(true).prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getDelegate(true).commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.getDelegate(true).rollback(xid);
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.getDelegate(true).isSameRM(xaResource);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.getDelegate(true).forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.getDelegate(true).getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.getDelegate(true).setTransactionTimeout(seconds);
    }

    private XAResource getDelegate(boolean required) {
        Assert.state((this.delegate != null || !required ? 1 : 0) != 0, (String)"Connection has not been opened");
        return this.delegate;
    }
}

