/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ModeProvider {
    public static ModeProvider instance = new ModeProvider();
    private final LinkedHashMap<String, Mode> modes = new LinkedHashMap(220);

    public void removeAll() {
        this.modes.clear();
    }

    public void removeMode(String string) throws IOException {
        Mode mode = this.modes.get(string);
        if (mode.isUserMode()) {
            this.modes.remove(string);
            String string2 = (String)mode.getProperty("file");
            File file = new File(string2);
            if (file.exists()) {
                Path path = FileSystems.getDefault().getPath(string2, new String[0]);
                Files.move(path, path.resolveSibling(string2 + "_unused"), StandardCopyOption.REPLACE_EXISTING);
                File file2 = new File(file.getParent(), "catalog");
                if (file2.exists()) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                        String string3 = null;
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((string3 = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string3).append('\n');
                        }
                        bufferedReader.close();
                        Pattern pattern = Pattern.compile("(?m)(^\\s*[<]MODE.*?NAME=\"" + string + "\".*?[>])");
                        Matcher matcher = pattern.matcher(stringBuilder);
                        String string4 = matcher.replaceFirst("<!--$1-->");
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                        bufferedWriter.write(string4, 0, string4.length());
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Mode getMode(String string) {
        return this.modes.get(string);
    }

    public Mode getModeForFile(String string, String string2) {
        return this.getModeForFile(null, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public Mode getModeForFile(String string, String string2, String string3) {
        if (string != null && string.endsWith(".gz")) {
            string = string.substring(0, string.length() - 3);
        }
        if (string2 != null && string2.endsWith(".gz")) {
            string2 = string2.substring(0, string2.length() - 3);
        }
        ArrayList<Mode> arrayList = new ArrayList<Mode>(1);
        for (Mode object2 : this.modes.values()) {
            if (!object2.accept(string, string2, string3)) continue;
            arrayList.add(object2);
        }
        if (arrayList.size() == 1) {
            return (Mode)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            Collections.reverse(arrayList);
            for (Mode mode : arrayList) {
                if (!mode.acceptIdentical(string, string2)) continue;
                return mode;
            }
            for (Mode mode : arrayList) {
                if (!mode.acceptFile(string, string2) || !mode.acceptFirstLine(string3)) continue;
                return mode;
            }
            ArrayList arrayList2 = new ArrayList();
            for (Mode mode : arrayList) {
                if (!mode.acceptFile(string, string2)) continue;
                arrayList2.add(mode);
            }
            if (arrayList2.size() == 1) {
                return (Mode)arrayList2.get(0);
            }
            if (arrayList2.size() > 1) {
                void var6_13;
                Mode mode = (Mode)arrayList2.get(0);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    Mode mode2 = (Mode)iterator.next();
                    if (((String)mode2.getProperty("filenameGlob")).length() <= ((String)var6_13.getProperty("filenameGlob")).length()) continue;
                    Mode mode3 = mode2;
                }
                return var6_13;
            }
            return (Mode)arrayList.get(0);
        }
        return null;
    }

    public Mode[] getModes() {
        return this.modes.values().toArray(new Mode[this.modes.size()]);
    }

    public void addMode(Mode mode) {
        String string = mode.getName();
        this.modes.remove(string);
        this.modes.put(string, mode);
    }

    public void addUserMode(Mode mode, Path path) throws IOException {
        mode.setUserMode(true);
        String string = mode.getName();
        String string2 = (String)mode.getProperty("file");
        String string3 = (String)mode.getProperty("filenameGlob");
        String string4 = (String)mode.getProperty("firstlineGlob");
        Path path2 = FileSystems.getDefault().getPath(string2, new String[0]);
        Files.copy(path2, path, StandardCopyOption.REPLACE_EXISTING);
        File file = new File(path.toFile().getParent(), "catalog");
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string5 = null;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string5 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string5).append('\n');
                }
                bufferedReader.close();
                Pattern pattern = Pattern.compile("(?m)(^\\s*[<]MODE.*?NAME=\"" + string + "\".*?[>])");
                Matcher matcher = pattern.matcher(stringBuilder);
                String string6 = matcher.replaceFirst("<!--$1-->");
                pattern = Pattern.compile("(?m)(</MODES>)");
                matcher = pattern.matcher(stringBuilder);
                StringBuilder stringBuilder2 = new StringBuilder("\t<MODE NAME=\"");
                stringBuilder2.append(string).append("\" FILE=\"").append(path.toFile().getName()).append("\"");
                stringBuilder2.append(string3 == null || string3.isEmpty() ? "" : " FILE_NAME_GLOB=\"" + string3 + "\"");
                stringBuilder2.append(string4 == null || string4.isEmpty() ? "" : " FIRST_LINE_GLOB=\"" + string4 + "\"");
                stringBuilder2.append("/>");
                string6 = matcher.replaceFirst(stringBuilder2 + "\n$1");
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(string6, 0, string6.length());
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addMode(mode);
        this.loadMode(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMode(Mode mode, XModeHandler xModeHandler) {
        BufferedInputStream bufferedInputStream;
        XMLReader xMLReader;
        String string = (String)mode.getProperty("file");
        Log.log(5, this, "Loading edit mode " + string);
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            Log.log(9, this, sAXException);
            return;
        }
        mode.setTokenMarker(xModeHandler.getTokenMarker());
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream inputStream = ModeProvider.class.getResourceAsStream(string);
            if (inputStream == null) {
                this.error(string, fileNotFoundException);
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
        }
        try {
            InputSource inputSource = new InputSource(bufferedInputStream);
            inputSource.setSystemId("jedit.jar");
            xMLReader.setContentHandler(xModeHandler);
            xMLReader.setDTDHandler(xModeHandler);
            xMLReader.setEntityResolver(xModeHandler);
            xMLReader.setErrorHandler(xModeHandler);
            xMLReader.parse(inputSource);
            mode.setProperties(xModeHandler.getModeProperties());
        }
        catch (Throwable throwable) {
            this.error(string, throwable);
        }
        finally {
            IOUtilities.closeQuietly(bufferedInputStream);
        }
    }

    public void loadMode(Mode mode) {
        XModeHandler xModeHandler = new XModeHandler(mode.getName()){

            @Override
            public void error(String string, Object object) {
                Log.log(9, this, object);
            }

            @Override
            public TokenMarker getTokenMarker(String string) {
                Mode mode = ModeProvider.this.getMode(string);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        this.loadMode(mode, xModeHandler);
    }

    protected void error(String string, Throwable throwable) {
        Log.log(9, this, throwable);
    }
}

