/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control.event;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEvent;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementEventQueue
implements IElementEventQueue {
    private static final String THREAD_PREFIX = "JCS-ElementEventQueue-";
    private static final Log log = LogFactory.getLog(ElementEventQueue.class);
    private boolean destroyed = false;
    private LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor queueProcessor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.queue, new DaemonThreadFactory("JCS-ElementEventQueue-"));

    public ElementEventQueue() {
        if (log.isDebugEnabled()) {
            log.debug("Constructed: " + this);
        }
    }

    @Override
    public void dispose() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.queueProcessor.shutdownNow();
            this.queueProcessor = null;
            if (log.isInfoEnabled()) {
                log.info("Element event queue destroyed: " + this);
            }
        }
    }

    @Override
    public <T> void addElementEvent(IElementEventHandler iElementEventHandler, IElementEvent<T> iElementEvent) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Adding Event Handler to QUEUE, !destroyed = " + !this.destroyed);
        }
        if (this.destroyed) {
            log.warn("Event submitted to disposed element event queue " + iElementEvent);
        } else {
            ElementEventRunner elementEventRunner = new ElementEventRunner(iElementEventHandler, iElementEvent);
            if (log.isDebugEnabled()) {
                log.debug("runner = " + elementEventRunner);
            }
            this.queueProcessor.execute(elementEventRunner);
        }
    }

    private class ElementEventRunner
    extends AbstractElementEventRunner {
        private final IElementEventHandler hand;
        private final IElementEvent<?> event;

        ElementEventRunner(IElementEventHandler iElementEventHandler, IElementEvent<?> iElementEvent) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("Constructing " + this);
            }
            this.hand = iElementEventHandler;
            this.event = iElementEvent;
        }

        @Override
        protected void doRun() throws IOException {
            this.hand.handleElementEvent(this.event);
        }
    }

    protected abstract class AbstractElementEventRunner
    implements Runnable {
        protected AbstractElementEventRunner() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (IOException iOException) {
                log.warn("Giving up element event handling " + ElementEventQueue.this, iOException);
            }
        }

        protected abstract void doRun() throws IOException;
    }
}

