/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleLinkedList<T> {
    private static final Log log = LogFactory.getLog(SingleLinkedList.class);
    private final Object lock = new Object();
    private Node<T> head = new Node();
    private Node<T> tail = this.head;
    private int size = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T takeFirst() {
        Object object = this.lock;
        synchronized (object) {
            if (this.head == this.tail) {
                return null;
            }
            Node node = this.head.next;
            Object t = node.payload;
            if (log.isDebugEnabled()) {
                log.debug("head.payload = " + this.head.payload);
                log.debug("node.payload = " + node.payload);
            }
            node.payload = null;
            this.head = node;
            --this.size;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(T t) {
        Node node = new Node();
        node.payload = t;
        Object object = this.lock;
        synchronized (object) {
            ++this.size;
            this.tail.next = node;
            this.tail = node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.head = this.tail;
            this.size = 0;
        }
    }

    public int size() {
        return this.size;
    }

    protected static class Node<T> {
        Node<T> next = null;
        T payload;

        protected Node() {
        }
    }
}

