/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import oauth.signpost.AbstractOAuthConsumer;
import oauth.signpost.AbstractOAuthProvider;
import org.openstreetmap.josm.tools.HttpClient;

public final class SignpostAdapters {
    private SignpostAdapters() {
    }

    static final class HttpResponse
    implements oauth.signpost.http.HttpResponse {
        final HttpClient.Response response;

        HttpResponse(HttpClient.Response response) {
            this.response = response;
        }

        @Override
        public int getStatusCode() throws IOException {
            return this.response.getResponseCode();
        }

        @Override
        public String getReasonPhrase() throws Exception {
            return this.response.getResponseMessage();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getContent();
        }

        @Override
        public Object unwrap() {
            throw new IllegalStateException();
        }
    }

    static final class HttpRequest
    implements oauth.signpost.http.HttpRequest {
        final HttpClient request;

        HttpRequest(HttpClient httpClient) {
            this.request = httpClient;
        }

        @Override
        public void setHeader(String string, String string2) {
            this.request.setHeader(string, string2);
        }

        @Override
        public String getMethod() {
            return this.request.getRequestMethod();
        }

        @Override
        public String getRequestUrl() {
            return this.request.getURL().toExternalForm();
        }

        @Override
        public String getContentType() {
            return this.request.getRequestHeader("Content-Type");
        }

        @Override
        public String getHeader(String string) {
            return this.request.getRequestHeader(string);
        }

        @Override
        public InputStream getMessagePayload() throws IOException {
            return null;
        }

        @Override
        public void setRequestUrl(String string) {
            throw new IllegalStateException();
        }

        @Override
        public Map<String, String> getAllHeaders() {
            throw new IllegalStateException();
        }

        @Override
        public Object unwrap() {
            throw new IllegalStateException();
        }
    }

    public static class OAuthConsumer
    extends AbstractOAuthConsumer {
        public OAuthConsumer(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected HttpRequest wrap(Object object) {
            return new HttpRequest((HttpClient)object);
        }
    }

    public static class OAuthProvider
    extends AbstractOAuthProvider {
        public OAuthProvider(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        @Override
        protected HttpRequest createRequest(String string) throws Exception {
            return new HttpRequest(HttpClient.create(new URL(string), "GET"));
        }

        @Override
        protected HttpResponse sendRequest(oauth.signpost.http.HttpRequest httpRequest) throws Exception {
            return new HttpResponse(((HttpRequest)httpRequest).request.connect());
        }

        @Override
        protected void closeConnection(oauth.signpost.http.HttpRequest httpRequest, oauth.signpost.http.HttpResponse httpResponse) throws Exception {
            if (httpResponse != null) {
                ((HttpResponse)httpResponse).response.disconnect();
            } else if (httpRequest != null) {
                ((HttpRequest)httpRequest).request.disconnect();
            }
        }
    }
}

