/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class SimilarNamedWays
extends Test {
    protected static final int SIMILAR_NAMED = 701;
    private Map<Point2D, List<Way>> cellWays;
    private MultiMap<Way, Way> errorWays;
    private final List<NormalizeRule> rules = new ArrayList<NormalizeRule>();

    public SimilarNamedWays() {
        super(I18n.tr("Similarly named ways", new Object[0]), I18n.tr("This test checks for ways with similar names that may have been misspelled.", new Object[0]));
        this.addRegExprRule("\\d+", "0");
        this.addRegExprRule("\\d+(st|nd|rd|th)", "0st");
        this.addRegExprRule("^[A-Z] ", "X");
        this.addSynonyms("east", "west", "north", "south");
        this.addSynonyms("first", "second", "third");
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.cellWays = new HashMap<Point2D, List<Way>>(1000);
        this.errorWays = new MultiMap();
    }

    @Override
    public void endTest() {
        this.cellWays = null;
        this.errorWays = null;
        super.endTest();
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        String string = way.get("name");
        if (string == null || string.length() < 6) {
            return;
        }
        List<List<Way>> list = ValUtil.getWaysInCell(way, this.cellWays);
        for (List<Way> list2 : list) {
            for (Way way2 : list2) {
                String string2;
                if (this.errorWays.contains(way, way2) || this.errorWays.contains(way2, way) || (string2 = way2.get("name")) == null || string2.length() < 6 || !this.similaryName(string, string2)) continue;
                ArrayList<Way> arrayList = new ArrayList<Way>(2);
                arrayList.add(way);
                arrayList.add(way2);
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Similarly named ways", new Object[0]), 701, arrayList));
                this.errorWays.put(way, way2);
            }
            list2.add(way);
        }
    }

    public static int getLevenshteinDistance(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n = 0; n <= n4; ++n) {
            nArray[0][n] = n;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            char c = string.charAt(n2 - 1);
            for (n = 1; n <= n4; ++n) {
                char c2 = string2.charAt(n - 1);
                int n5 = c == c2 ? 0 : 1;
                nArray[n2][n] = Math.min(Math.min(nArray[n2 - 1][n] + 1, nArray[n2][n - 1] + 1), nArray[n2 - 1][n - 1] + n5);
            }
        }
        return nArray[n3][n4];
    }

    public void addRegExprRule(String string, String string2) {
        this.rules.add(new RegExprRule(string, string2));
    }

    public void addSynonyms(String ... stringArray) {
        for (String string : stringArray) {
            this.rules.add(new SynonymRule(string, stringArray));
        }
    }

    public boolean similaryName(String string, String string2) {
        int n = SimilarNamedWays.getLevenshteinDistance(string, string2);
        boolean bl = n > 0 && n <= 2;
        for (NormalizeRule normalizeRule : this.rules) {
            int n2 = SimilarNamedWays.getLevenshteinDistance(normalizeRule.normalize(string), normalizeRule.normalize(string2));
            if (n2 == 0) {
                return false;
            }
            if (n2 > 2) continue;
            bl = true;
        }
        return bl;
    }

    public static class SynonymRule
    implements NormalizeRule {
        private final String[] words;
        private final Pattern regExpr;
        private final String replacement;

        public SynonymRule(String string, String ... stringArray) {
            this.replacement = string.toLowerCase(Locale.ENGLISH);
            this.words = stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() > n) {
                    n = stringArray[i].length();
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('|');
                }
                stringBuilder.append(Pattern.quote(stringArray[i]));
            }
            this.regExpr = Pattern.compile(stringBuilder.toString(), 66);
        }

        @Override
        public String normalize(String string) {
            String string2;
            Matcher matcher = this.regExpr.matcher(string);
            if (!matcher.find()) {
                return string;
            }
            int n = matcher.start();
            String string3 = "";
            for (int i = 0; i < this.words.length && !(string2 = this.words[i]).equalsIgnoreCase(string3 = string.substring(n, n + string2.length())); ++i) {
            }
            char[] cArray = matcher.replaceFirst(this.replacement).toCharArray();
            int n2 = Math.min(this.replacement.length(), string3.length());
            for (int i = 0; i < n2; ++i) {
                if (!Character.isUpperCase(string3.charAt(i))) continue;
                cArray[n + i] = Character.toUpperCase(cArray[n + i]);
            }
            return new String(cArray);
        }

        public String toString() {
            return "synonyms(" + this.replacement + ", " + Arrays.toString(this.words) + ')';
        }
    }

    public static class RegExprRule
    implements NormalizeRule {
        private final Pattern regExpr;
        private final String replacement;

        public RegExprRule(String string, String string2) {
            this.regExpr = Pattern.compile(string);
            this.replacement = string2;
        }

        @Override
        public String normalize(String string) {
            return this.regExpr.matcher(string).replaceAll(this.replacement);
        }

        public String toString() {
            return "replaceAll(" + this.regExpr + ", " + this.replacement + ')';
        }
    }

    @FunctionalInterface
    public static interface NormalizeRule {
        public String normalize(String var1);
    }
}

